/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.libloader.LoadState;
import de.ibapl.jnhw.linux.sys.Eventfd;
import de.ibapl.jnhw.posix.Errno;
import de.ibapl.jnhw.posix.Fcntl;
import de.ibapl.jnhw.posix.Poll;
import de.ibapl.jnhw.posix.Termios;
import de.ibapl.jnhw.posix.Time;
import de.ibapl.jnhw.posix.Unistd;
import de.ibapl.jnhw.unix.sys.Ioctl;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.spsw.api.AsyncSerialPortSocket;
import de.ibapl.spsw.api.AsynchronousCancelException;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.InOutSpeedConfiguration;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.api.TimeoutIOException;
import de.ibapl.spsw.jnhwprovider.AbstractSerialPortSocket;
import de.ibapl.spsw.jnhwprovider.PosixConfiguration;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PosixAsyncSerialPortSocket
extends AbstractSerialPortSocket<PosixAsyncSerialPortSocket>
implements AsyncSerialPortSocket,
InOutSpeedConfiguration {
    private static final int POLL_INFINITE_TIMEOUT = -1;
    public static final Cleaner CLEANER = Cleaner.create();
    private static final Logger LOG = Logger.getLogger(PosixAsyncSerialPortSocket.class.getCanonicalName());
    private static final int POLL_TIMEOUT_INFINITE = -1;
    private static final int INVALID_FD = -1;
    private static final int PORT_FD_IDX = 0;
    private static final int CANCEL_FD_IDX = 1;
    private volatile int fd = -1;
    private final PosixConfiguration posixConfiguration;
    private volatile int cancel_read_event__write_fd = -1;
    private volatile int cancel_read_event__read_fd = -1;
    private volatile int cancel_write_event__write_fd = -1;
    private volatile int cancel_write_event__read_fd = -1;
    private int interByteReadTimeout = 100;
    private int pollReadTimeout = -1;
    private int pollWriteTimeout = -1;
    private ExecutorService executor;
    private final FdCleaner fdCleaner = new FdCleaner();
    private final Semaphore readSemaphore = new Semaphore(1, true);
    private final Semaphore writeSemaphore = new Semaphore(1, true);
    private final Poll.PollFds readPollFds = new Poll.PollFds(2);
    private final Poll.PollFds writePollFds = new Poll.PollFds(2);
    private static final boolean JNHW_HAVE_SYS_EVENTFD_H = Eventfd.HAVE_SYS_EVENTFD_H;

    public void readAsync(ByteBuffer dst, Consumer<ByteBuffer> callbackOnSuccess, Consumer<IOException> callbackOnFailure) {
        int nread;
        boolean readSemaphoreAquired;
        block7: {
            readSemaphoreAquired = this.readSemaphore.tryAcquire();
            if (readSemaphoreAquired) {
                try {
                    nread = this.startRead(dst);
                    if (!dst.hasRemaining()) {
                        this.readSemaphore.release();
                        callbackOnSuccess.accept(dst);
                        return;
                    }
                    break block7;
                }
                catch (IOException ioe) {
                    this.readSemaphore.release();
                    callbackOnFailure.accept(ioe);
                    return;
                }
                catch (Exception e) {
                    this.readSemaphore.release();
                    callbackOnFailure.accept(new IOException(e));
                    return;
                }
            }
            nread = 0;
        }
        int start = nread;
        Runnable runnable = () -> {
            try {
                int nRead;
                if (readSemaphoreAquired) {
                    nRead = start;
                } else {
                    try {
                        this.readSemaphore.acquire();
                    }
                    catch (InterruptedException ex) {
                        callbackOnFailure.accept(new IOException(ex));
                        return;
                    }
                    nRead = this.startRead(dst);
                }
                if (!dst.hasRemaining()) {
                    this.readSemaphore.release();
                    callbackOnSuccess.accept(dst);
                    return;
                }
                int read = this.continueRead(dst, nRead);
                this.readSemaphore.release();
                callbackOnSuccess.accept(dst);
                return;
            }
            catch (IOException ioe) {
                this.readSemaphore.release();
                callbackOnFailure.accept(ioe);
                return;
            }
            catch (Exception e) {
                this.readSemaphore.release();
                callbackOnFailure.accept(new IOException(e));
                return;
            }
        };
        if (this.executor == null) {
            new Thread(runnable).start();
        } else {
            this.executor.execute(runnable);
        }
    }

    public void readAsync(ByteBuffer dst, BiConsumer<ByteBuffer, IOException> callback) {
        this.readAsync(dst, bb -> callback.accept((ByteBuffer)bb, (IOException)null), ioEx -> callback.accept((ByteBuffer)null, (IOException)ioEx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ByteBuffer> readAsync(ByteBuffer dst) {
        int nread;
        boolean readSemaphoreAquired;
        block9: {
            readSemaphoreAquired = this.readSemaphore.tryAcquire();
            if (readSemaphoreAquired) {
                try {
                    nread = this.startRead(dst);
                    if (!dst.hasRemaining()) {
                        FutureDone<ByteBuffer> futureDone = new FutureDone<ByteBuffer>(dst);
                        return futureDone;
                    }
                    break block9;
                }
                catch (Exception e) {
                    FutureDone<ByteBuffer> futureDone = new FutureDone<ByteBuffer>(e);
                    return futureDone;
                }
                finally {
                    this.readSemaphore.release();
                }
            }
            nread = 0;
        }
        int start = nread;
        FutureTask<ByteBuffer> result = new FutureTask<ByteBuffer>(() -> {
            int nread1;
            if (readSemaphoreAquired) {
                nread1 = start;
            } else {
                this.readSemaphore.acquire();
                try {
                    nread1 = this.startRead(dst);
                    if (!dst.hasRemaining()) {
                        this.readSemaphore.release();
                        return dst;
                    }
                }
                catch (Exception e) {
                    this.readSemaphore.release();
                    throw e;
                }
            }
            try {
                this.continueRead(dst, nread1);
                ByteBuffer byteBuffer = dst;
                return byteBuffer;
            }
            finally {
                this.readSemaphore.release();
            }
        }){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return super.cancel(false);
            }
        };
        if (this.executor == null) {
            new Thread(result).start();
        } else {
            this.executor.submit(result);
        }
        return result;
    }

    public void writeAsync(ByteBuffer src, Consumer<ByteBuffer> callbackOnSuccess, Consumer<IOException> callbackOnFailure) {
        int written;
        boolean writeSemaphoreAquired;
        block7: {
            writeSemaphoreAquired = this.writeSemaphore.tryAcquire();
            if (writeSemaphoreAquired) {
                try {
                    written = this.startWrite(src);
                    if (!src.hasRemaining()) {
                        this.writeSemaphore.release();
                        callbackOnSuccess.accept(src);
                        return;
                    }
                    break block7;
                }
                catch (IOException ioe) {
                    this.writeSemaphore.release();
                    callbackOnFailure.accept(ioe);
                    return;
                }
                catch (Exception e) {
                    this.writeSemaphore.release();
                    callbackOnFailure.accept(new IOException(e));
                    return;
                }
            }
            written = 0;
        }
        int start = written;
        Runnable runnable = () -> {
            try {
                int written1;
                if (writeSemaphoreAquired) {
                    written1 = start;
                } else {
                    try {
                        this.writeSemaphore.acquire();
                    }
                    catch (InterruptedException ex) {
                        callbackOnFailure.accept(new IOException(ex));
                        return;
                    }
                    written1 = this.startWrite(src);
                    if (!src.hasRemaining()) {
                        this.writeSemaphore.release();
                        callbackOnSuccess.accept(src);
                        return;
                    }
                }
                int wrote = this.continueWrite(src, written1);
                callbackOnSuccess.accept(src);
                return;
            }
            catch (IOException ioe) {
                this.writeSemaphore.release();
                callbackOnFailure.accept(ioe);
                return;
            }
            catch (Exception e) {
                this.writeSemaphore.release();
                callbackOnFailure.accept(new IOException(e));
                return;
            }
        };
        if (this.executor == null) {
            new Thread(runnable).start();
        } else {
            this.executor.execute(runnable);
        }
    }

    public void writeAsync(ByteBuffer src, BiConsumer<ByteBuffer, IOException> callback) {
        this.writeAsync(src, bb -> callback.accept((ByteBuffer)bb, (IOException)null), ioEx -> callback.accept((ByteBuffer)null, (IOException)ioEx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ByteBuffer> writeAsync(ByteBuffer src) {
        int written;
        boolean writeSemaphoreAquired;
        block9: {
            writeSemaphoreAquired = this.writeSemaphore.tryAcquire();
            if (writeSemaphoreAquired) {
                try {
                    written = this.startWrite(src);
                    if (!src.hasRemaining()) {
                        FutureDone<ByteBuffer> futureDone = new FutureDone<ByteBuffer>(src);
                        return futureDone;
                    }
                    break block9;
                }
                catch (Exception e) {
                    FutureDone<ByteBuffer> futureDone = new FutureDone<ByteBuffer>(e);
                    return futureDone;
                }
                finally {
                    this.writeSemaphore.release();
                }
            }
            written = 0;
        }
        int start = written;
        FutureTask<ByteBuffer> result = new FutureTask<ByteBuffer>(() -> {
            int written1;
            if (writeSemaphoreAquired) {
                written1 = start;
            } else {
                this.writeSemaphore.acquire();
                try {
                    written1 = this.startWrite(src);
                    if (!src.hasRemaining()) {
                        this.writeSemaphore.release();
                        return src;
                    }
                }
                catch (Exception e) {
                    this.writeSemaphore.release();
                    throw e;
                }
            }
            try {
                this.continueWrite(src, written1);
                ByteBuffer byteBuffer = src;
                return byteBuffer;
            }
            finally {
                this.writeSemaphore.release();
            }
        }){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return super.cancel(false);
            }
        };
        if (this.executor == null) {
            new Thread(result).start();
        } else {
            this.executor.submit(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainOutputBuffer() throws IOException {
        try {
            this.writeSemaphore.acquire();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        try {
            boolean completed = false;
            try {
                this.begin();
                try {
                    int poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)this.pollWriteTimeout);
                    if (poll_result == 0) {
                        throw new TimeoutIOException();
                    }
                    if (((Poll.PollFd)this.writePollFds.get(1)).revents() == Poll.POLLIN) {
                        throw new IOException("Port is closed");
                    }
                    if (((Poll.PollFd)this.writePollFds.get(0)).revents() != Poll.POLLOUT) {
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            throw new IOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (this.fd == -1) {
                            throw new IOException("Port is closed");
                        }
                        throw new IOException("drainOutputBuffer poll => : received unexpected event and port not closed");
                    }
                }
                catch (NativeErrorException nee) {
                    throw new IOException(this.formatMsg(nee, "drainOutputBuffer poll: Error during poll ", new Object[0]));
                }
                try {
                    Termios.tcdrain((int)this.fd);
                    completed = true;
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't drain the output buffer ", new Object[0]));
                }
            }
            finally {
                this.end(completed);
            }
        }
        finally {
            this.writeSemaphore.release();
        }
    }

    PosixAsyncSerialPortSocket(String portName) throws IOException {
        this(portName, null, null, null, null, null);
    }

    PosixAsyncSerialPortSocket(String portName, ExecutorService executor) throws IOException {
        this(portName, null, null, null, null, null);
        this.executor = executor;
    }

    PosixAsyncSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        super(portName);
        this.posixConfiguration = new PosixConfiguration(portName);
        if (LoadState.SUCCESS != LibJnhwPosixLoader.touch()) {
            throw new RuntimeException("Could not load native lib: ", LibJnhwPosixLoader.getLoadResult().loadError);
        }
        this.open(speed, dataBits, stopBits, parity, flowControls);
    }

    PosixAsyncSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls, ExecutorService executor) throws IOException {
        this(portName, speed, dataBits, stopBits, parity, flowControls);
        this.executor = executor;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        if (this.fd != -1) {
            int tempFd = this.fd;
            this.fd = -1;
            ByteBuffer evt_buff = ByteBuffer.allocateDirect(8);
            evt_buff.putLong(1L);
            evt_buff.flip();
            try {
                Unistd.write((int)this.cancel_write_event__write_fd, (ByteBuffer)evt_buff);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Error writing to cancel_write_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            evt_buff.clear();
            evt_buff.putLong(1L);
            evt_buff.flip();
            try {
                Unistd.write((int)this.cancel_read_event__write_fd, (ByteBuffer)evt_buff);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Error writing to cancel_read_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            try {
                Termios.tcflush((int)tempFd, (int)Termios.TCIOFLUSH);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Native Error flushing " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "unknown Error flushing ", t);
            }
            try {
                Unistd.close((int)tempFd);
                this.fdCleaner.fd = -1;
                this.cancel_read_event__read_fd = -1;
                this.cancel_read_event__write_fd = -1;
                this.cancel_write_event__read_fd = -1;
                this.cancel_write_event__write_fd = -1;
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "unknown Error during closing " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
        }
    }

    public DataBits getDatatBits() throws IOException {
        return this.posixConfiguration.getDatatBits();
    }

    public Set<FlowControl> getFlowControl() throws IOException {
        return this.posixConfiguration.getFlowControl();
    }

    public int getInBufferBytesCount() throws IOException {
        return this.posixConfiguration.getInBufferBytesCount();
    }

    public int getInterByteReadTimeout() throws IOException {
        return this.interByteReadTimeout;
    }

    public int getOutBufferBytesCount() throws IOException {
        return this.posixConfiguration.getOutBufferBytesCount();
    }

    public int getOverallReadTimeout() throws IOException {
        return this.pollReadTimeout == -1 ? 0 : this.pollReadTimeout;
    }

    public int getOverallWriteTimeout() throws IOException {
        return this.pollWriteTimeout == -1 ? 0 : this.pollWriteTimeout;
    }

    public Parity getParity() throws IOException {
        return this.posixConfiguration.getParity();
    }

    public Speed getSpeed() throws IOException {
        return this.posixConfiguration.getSpeed();
    }

    public Speed getInSpeed() throws IOException {
        return this.posixConfiguration.getInSpeed();
    }

    public Speed getOutSpeed() throws IOException {
        return this.posixConfiguration.getOutSpeed();
    }

    public StopBits getStopBits() throws IOException {
        return this.posixConfiguration.getStopBits();
    }

    public char getXOFFChar() throws IOException {
        return this.posixConfiguration.getXOFFChar();
    }

    public char getXONChar() throws IOException {
        return this.posixConfiguration.getXONChar();
    }

    public boolean isCTS() throws IOException {
        return this.posixConfiguration.isCTS();
    }

    public boolean isDCD() throws IOException {
        return this.posixConfiguration.isDCD();
    }

    public boolean isDSR() throws IOException {
        return this.posixConfiguration.isDSR();
    }

    private boolean isFdValid() {
        try {
            return Fcntl.fcntl((int)this.fd, (int)Fcntl.F_GETFL) != -1;
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.EBADF) {
                LOG.log(Level.SEVERE, "Port {0} has invalid file descriptor", this.portName);
                return false;
            }
            LOG.log(Level.SEVERE, "file descriptor of port " + this.portName + " not valid unknown Native exception " + Errno.getErrnoSymbol((int)nee.errno), nee);
            return false;
        }
    }

    public boolean isRI() throws IOException {
        return this.posixConfiguration.isRI();
    }

    private synchronized void open(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        this.fd = this.posixConfiguration.open(speed, dataBits, stopBits, parity, flowControls);
        try {
            if (JNHW_HAVE_SYS_EVENTFD_H) {
                this.cancel_read_event__write_fd = this.cancel_read_event__read_fd = Eventfd.eventfd((int)0, (int)Eventfd.EFD_NONBLOCK);
                this.cancel_write_event__write_fd = this.cancel_write_event__read_fd = Eventfd.eventfd((int)0, (int)Eventfd.EFD_NONBLOCK);
            } else {
                Int32_t read_fd = new Int32_t();
                Int32_t write_fd = new Int32_t();
                Unistd.pipe((Int32_t)read_fd, (Int32_t)write_fd);
                this.cancel_read_event__read_fd = read_fd.int32_t();
                this.cancel_read_event__write_fd = write_fd.int32_t();
                Fcntl.fcntl((int)this.cancel_read_event__read_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Fcntl.fcntl((int)this.cancel_read_event__write_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Unistd.pipe((Int32_t)read_fd, (Int32_t)write_fd);
                this.cancel_write_event__read_fd = read_fd.int32_t();
                this.cancel_write_event__write_fd = write_fd.int32_t();
                Fcntl.fcntl((int)this.cancel_write_event__read_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Fcntl.fcntl((int)this.cancel_write_event__write_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
            }
        }
        catch (NativeErrorException nee) {
            try {
                Unistd.close((int)this.fd);
                this.fd = -1;
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            throw new IOException("Can't create close_event_fd");
        }
        this.fdCleaner.fd = this.fd;
        this.fdCleaner.cancel_read_event__read_fd = this.cancel_read_event__read_fd;
        this.fdCleaner.cancel_read_event__write_fd = this.cancel_read_event__write_fd;
        this.fdCleaner.cancel_write_event__read_fd = this.cancel_write_event__read_fd;
        this.fdCleaner.cancel_write_event__write_fd = this.cancel_write_event__write_fd;
        CLEANER.register(this, this.fdCleaner);
        ((Poll.PollFd)this.writePollFds.get(0)).fd(this.fd);
        ((Poll.PollFd)this.writePollFds.get(0)).events(Poll.POLLOUT);
        ((Poll.PollFd)this.writePollFds.get(1)).fd(this.cancel_write_event__read_fd);
        ((Poll.PollFd)this.writePollFds.get(1)).events(Poll.POLLIN);
        ((Poll.PollFd)this.readPollFds.get(0)).fd(this.fd);
        ((Poll.PollFd)this.readPollFds.get(0)).events(Poll.POLLIN);
        ((Poll.PollFd)this.readPollFds.get(1)).fd(this.cancel_read_event__read_fd);
        ((Poll.PollFd)this.readPollFds.get(1)).events(Poll.POLLIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBreak(int duration) throws IOException {
        try {
            this.writeSemaphore.acquire();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        try {
            if (duration <= 0) {
                throw new IllegalArgumentException("sendBreak duration must be greater than 0)");
            }
            boolean completed = false;
            try {
                this.begin();
                try {
                    Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCSBRK);
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't set Break ", new Object[0]));
                }
                try {
                    Thread.sleep(duration);
                }
                catch (InterruptedException ie) {
                    try {
                        Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCCBRK);
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new IOException(this.formatMsg(nee, "Can't clear Break after aborted wait", new Object[0]), ie);
                    }
                    completed = true;
                    throw new RuntimeException("Wait interrupted", ie);
                }
                try {
                    Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCCBRK);
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't clear Break ", new Object[0]));
                }
                completed = true;
            }
            finally {
                this.end(completed);
            }
        }
        finally {
            this.writeSemaphore.release();
        }
    }

    public void sendXOFF() throws IOException {
        throw new IllegalArgumentException("sendXOFF not implemented yet");
    }

    public void sendXON() throws IOException {
        throw new IllegalArgumentException("sendXON not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreak(boolean enabled) throws IOException {
        try {
            this.writeSemaphore.acquire();
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        try {
            int arg = enabled ? Ioctl.TIOCSBRK : Ioctl.TIOCCBRK;
            try {
                Ioctl.ioctl((int)this.fd, (int)arg);
            }
            catch (NativeErrorException nee) {
                throw new IOException(this.formatMsg(nee, "Can't set Break ", new Object[0]));
            }
        }
        finally {
            this.writeSemaphore.release();
        }
    }

    public void setDataBits(DataBits dataBits) throws IOException {
        this.posixConfiguration.setParams(null, dataBits, null, null, null);
    }

    public void setDTR(boolean enabled) throws IOException {
        this.posixConfiguration.setDTR(enabled);
    }

    public void setFlowControl(Set<FlowControl> flowControls) throws IOException {
        this.posixConfiguration.setParams(null, null, null, null, flowControls);
    }

    public void setParity(Parity parity) throws IOException {
        this.posixConfiguration.setParams(null, null, null, parity, null);
    }

    public void setRTS(boolean enabled) throws IOException {
        this.posixConfiguration.setRTS(enabled);
    }

    public void setSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setParams(speed, null, null, null, null);
    }

    public void setInSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setInSpeed(speed);
    }

    public void setOutSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setOutSpeed(speed);
    }

    public void setStopBits(StopBits stopBits) throws IOException {
        this.posixConfiguration.setParams(null, null, stopBits, null, null);
    }

    public void setTimeouts(int interByteReadTimeout, int overallReadTimeout, int overallWriteTimeout) throws IOException {
        if (overallWriteTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallWriteTimeout must >= 0");
        }
        if (overallReadTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallReadTimeout must >= 0");
        }
        if (interByteReadTimeout < 0) {
            throw new IllegalArgumentException("setReadTimeouts: interByteReadTimeout must >= 0");
        }
        this.interByteReadTimeout = interByteReadTimeout;
        this.pollReadTimeout = overallReadTimeout == 0 ? -1 : overallReadTimeout;
        this.pollWriteTimeout = overallWriteTimeout == 0 ? -1 : overallWriteTimeout;
    }

    public void setXOFFChar(char c) throws IOException {
        this.posixConfiguration.setXOFFChar(c);
    }

    private String formatMsg(NativeErrorException nee, String formatString, Object ... args) {
        if (this.fd == -1) {
            return "Port is closed";
        }
        if (this.isFdValid()) {
            return String.format("Native port error on %s, \"%s\" %s", this.portName, Errno.getErrnoSymbol((int)nee.errno), String.format(formatString, args));
        }
        return "File descriptor of serial port is invalid";
    }

    public void setXONChar(char c) throws IOException {
        this.posixConfiguration.setXONChar(c);
    }

    public String termiosToString() throws IOException {
        return this.posixConfiguration.termiosToString();
    }

    private int startWrite(ByteBuffer src) throws IOException {
        if (!src.hasRemaining()) {
            return 0;
        }
        try {
            return Unistd.write((int)this.fd, (ByteBuffer)src);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.EAGAIN) {
                return 0;
            }
            if (this.fd == -1) {
                throw new AsynchronousCloseException();
            }
            if (nee.errno == Errno.EBADF) {
                throw new InterruptedIOException("File descriptor of serial port is invalid");
            }
            throw new InterruptedIOException(this.formatMsg(nee, "unknown port error write ", new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int continueWrite(ByteBuffer src, int written) throws IOException {
        Time.Timespec endTime = this.pollWriteTimeout != -1 ? new Time.Timespec(AbstractNativeMemory.SetMem.DO_NOT_SET) : null;
        try {
            if (this.pollWriteTimeout != -1) {
                Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)endTime);
                endTime.tv_sec(endTime.tv_sec() + (long)(this.pollWriteTimeout / 1000));
                endTime.tv_nsec(endTime.tv_nsec() + (long)(this.pollWriteTimeout % 1000 * 1000000));
                if (endTime.tv_nsec() > 1000000000L) {
                    endTime.tv_sec(endTime.tv_sec() + 1L);
                    endTime.tv_nsec(endTime.tv_nsec() - 1000000000L);
                }
            }
        }
        catch (NativeErrorException ex) {
            throw new RuntimeException(ex);
        }
        boolean completed = false;
        try {
            this.begin();
            int offset = written;
            do {
                InterruptedIOException iioe;
                try {
                    int poll_result;
                    if (this.pollWriteTimeout == -1) {
                        poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)-1);
                    } else {
                        Time.Timespec currentTime = new Time.Timespec(AbstractNativeMemory.SetMem.DO_NOT_SET);
                        Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)currentTime);
                        int remainingTimeOut = (int)(endTime.tv_sec() - currentTime.tv_sec()) * 1000 + (int)((endTime.tv_nsec() - currentTime.tv_nsec()) / 1000000L);
                        if (remainingTimeOut < 0) {
                            throw new TimeoutIOException();
                        }
                        poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)remainingTimeOut);
                    }
                    if (poll_result == 0) {
                        TimeoutIOException tioe = new TimeoutIOException();
                        tioe.bytesTransferred = written;
                        completed = true;
                        throw tioe;
                    }
                    if (((Poll.PollFd)this.writePollFds.get(1)).revents() == Poll.POLLIN) {
                        completed = true;
                        if (this.fd == -1) {
                            throw new AsynchronousCloseException();
                        }
                        throw new AsynchronousCancelException();
                    }
                    if (((Poll.PollFd)this.writePollFds.get(0)).revents() != Poll.POLLOUT) {
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        iioe = new InterruptedIOException("poll returned with poll event write ");
                        iioe.bytesTransferred = offset;
                        completed = true;
                        throw iioe;
                    }
                }
                catch (NativeErrorException nee) {
                    iioe = new InterruptedIOException(this.formatMsg(nee, "poll timeout with error in write!", new Object[0]));
                    iioe.initCause(nee);
                    iioe.bytesTransferred = offset;
                    completed = true;
                    throw iioe;
                }
                try {
                    offset += Unistd.write((int)this.fd, (ByteBuffer)src);
                }
                catch (NativeErrorException nee) {
                    if (this.fd == -1) {
                        completed = true;
                        if (this.fd == -1) {
                            throw new AsynchronousCloseException();
                        }
                        throw new AsynchronousCancelException();
                    }
                    if (nee.errno == Errno.EBADF) {
                        completed = true;
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    iioe = new InterruptedIOException(this.formatMsg(nee, "error during Unistd.write", new Object[0]));
                    iioe.bytesTransferred = offset;
                    completed = true;
                    throw iioe;
                }
            } while (src.hasRemaining());
            completed = true;
            int n = offset;
            return n;
        }
        finally {
            this.end(completed);
        }
    }

    private int startRead(ByteBuffer dst) throws IOException {
        if (!dst.hasRemaining()) {
            return 0;
        }
        try {
            return Unistd.read((int)this.fd, (ByteBuffer)dst);
        }
        catch (NativeErrorException nee) {
            if (this.fd == -1) {
                throw new AsynchronousCloseException();
            }
            if (nee.errno == Errno.EAGAIN) {
                return 0;
            }
            if (nee.errno == Errno.EBADF) {
                throw new InterruptedIOException("File descriptor of serial port is invalid");
            }
            throw new InterruptedIOException("read: read error during first invocation of read() " + Errno.getErrnoSymbol((int)nee.errno));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int continueRead(ByteBuffer dst, int nread) throws IOException {
        Time.Timespec endTime;
        block41: {
            endTime = this.pollReadTimeout != -1 ? new Time.Timespec(AbstractNativeMemory.SetMem.DO_NOT_SET) : null;
            try {
                if (this.pollReadTimeout == -1) break block41;
                Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)endTime);
                endTime.tv_sec(endTime.tv_sec() + (long)(this.pollReadTimeout / 1000));
                endTime.tv_nsec(endTime.tv_nsec() + (long)(this.pollReadTimeout % 1000 * 1000000));
                if (endTime.tv_nsec() > 1000000000L) {
                    endTime.tv_sec(endTime.tv_sec() + 1L);
                    endTime.tv_nsec(endTime.tv_nsec() - 1000000000L);
                }
            }
            catch (NativeErrorException ex) {
                throw new RuntimeException(ex);
            }
        }
        boolean completed = false;
        try {
            block42: {
                this.begin();
                if (nread == 0) {
                    try {
                        int poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)this.pollReadTimeout);
                        if (poll_result == 0) {
                            completed = true;
                            throw new TimeoutIOException();
                        }
                        if (((Poll.PollFd)this.readPollFds.get(1)).revents() == Poll.POLLIN) {
                            completed = true;
                            if (this.fd != -1) throw new AsynchronousCancelException();
                            throw new AsynchronousCloseException();
                        }
                        if (((Poll.PollFd)this.readPollFds.get(0)).revents() == Poll.POLLIN) {
                            try {
                                nread = Unistd.read((int)this.fd, (ByteBuffer)dst);
                                if (!dst.hasRemaining()) {
                                    completed = true;
                                    int n = nread;
                                    return n;
                                }
                                break block42;
                            }
                            catch (NativeErrorException nee) {
                                if (this.fd == -1) {
                                    completed = true;
                                    if (this.fd != -1) throw new AsynchronousCancelException();
                                    throw new AsynchronousCloseException();
                                }
                                if (nee.errno == Errno.EBADF) {
                                    completed = true;
                                    throw new InterruptedIOException("File descriptor of serial port is invalid");
                                }
                                completed = true;
                                throw new IOException("Readed " + nread + " bytes.  Unknown Error: " + Errno.getErrnoSymbol((int)nee.errno));
                            }
                        }
                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd != -1) throw new AsynchronousCancelException();
                            throw new AsynchronousCloseException();
                        }
                        completed = true;
                        throw new InterruptedIOException("read poll: received poll event fds:\n" + this.readPollFds.toString());
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new InterruptedIOException("read poll: Error during poll errno: " + Errno.getErrnoSymbol((int)nee.errno));
                    }
                }
            }
            int overallRead = nread;
            do {
                int poll_result;
                block43: {
                    try {
                        if (this.pollReadTimeout == -1) {
                            poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)this.interByteReadTimeout);
                            break block43;
                        }
                        Time.Timespec currentTime = new Time.Timespec(AbstractNativeMemory.SetMem.DO_NOT_SET);
                        Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)currentTime);
                        int remainingTimeOut = (int)(endTime.tv_sec() - currentTime.tv_sec()) * 1000 + (int)((endTime.tv_nsec() - currentTime.tv_nsec()) / 1000000L);
                        if (remainingTimeOut < 0) {
                            completed = true;
                            int n = overallRead;
                            return n;
                        }
                        poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)(this.interByteReadTimeout < remainingTimeOut ? this.interByteReadTimeout : remainingTimeOut));
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new InterruptedIOException("read poll: Error during poll " + Errno.getErrnoSymbol((int)nee.errno));
                    }
                }
                if (poll_result == 0) {
                    completed = true;
                    int n = overallRead;
                    return n;
                }
                if (((Poll.PollFd)this.readPollFds.get(1)).revents() == Poll.POLLIN) {
                    completed = true;
                    int n = -1;
                    return n;
                }
                if (((Poll.PollFd)this.readPollFds.get(0)).revents() != Poll.POLLIN) {
                    if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                        completed = true;
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                        completed = true;
                        if (this.fd != -1) throw new AsynchronousCancelException();
                        throw new AsynchronousCloseException();
                    }
                    completed = true;
                    throw new InterruptedIOException("read poll: received poll event fds:\n" + this.readPollFds.toString());
                }
                try {
                    overallRead += Unistd.read((int)this.fd, (ByteBuffer)dst);
                }
                catch (NativeErrorException nee) {
                    if (this.fd == -1) {
                        completed = true;
                        if (this.fd != -1) throw new AsynchronousCancelException();
                        throw new AsynchronousCloseException();
                    }
                    if (nee.errno == Errno.EBADF) {
                        completed = true;
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    completed = true;
                    throw new IOException("Readed " + overallRead + " bytes.  Unknown Error: " + Errno.getErrnoSymbol((int)nee.errno));
                }
            } while (dst.hasRemaining());
            completed = true;
            int n = overallRead;
            return n;
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "IO ex for: " + this.portName, ioe);
            throw ioe;
        }
        finally {
            this.end(completed);
        }
    }

    public boolean isDTR() throws IOException {
        return this.posixConfiguration.isDTR();
    }

    public boolean isRTS() throws IOException {
        return this.posixConfiguration.isRTS();
    }

    static class FdCleaner
    implements Runnable {
        int fd = -1;
        int cancel_read_event__write_fd = -1;
        int cancel_read_event__read_fd = -1;
        int cancel_write_event__write_fd = -1;
        int cancel_write_event__read_fd = -1;

        FdCleaner() {
        }

        @Override
        public void run() {
            ByteBuffer evt_buff;
            if (this.cancel_read_event__write_fd != -1) {
                evt_buff = ByteBuffer.allocateDirect(8);
                evt_buff.putLong(1L);
                evt_buff.flip();
                try {
                    Unistd.write((int)this.cancel_read_event__write_fd, (ByteBuffer)evt_buff);
                    Unistd.usleep((int)1000);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "Error writing to cancel_read_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
                }
            }
            if (this.cancel_write_event__write_fd != -1) {
                evt_buff = ByteBuffer.allocateDirect(8);
                evt_buff.putLong(1L);
                evt_buff.flip();
                try {
                    Unistd.write((int)this.cancel_write_event__write_fd, (ByteBuffer)evt_buff);
                    Unistd.usleep((int)1000);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "Error writing to cancel_write_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
                }
            }
            if (this.fd != -1) {
                try {
                    Unistd.close((int)this.fd);
                    this.fd = -1;
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean fd");
                }
            }
            if (this.cancel_read_event__write_fd != -1) {
                try {
                    Unistd.close((int)this.cancel_read_event__write_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_read_event__write_fd");
                }
            }
            if (this.cancel_read_event__read_fd != -1 && this.cancel_read_event__read_fd != this.cancel_read_event__write_fd) {
                try {
                    Unistd.close((int)this.cancel_read_event__read_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_read_event__read_fd");
                }
            }
            this.cancel_read_event__read_fd = -1;
            this.cancel_read_event__write_fd = -1;
            if (this.cancel_write_event__write_fd != -1) {
                try {
                    Unistd.close((int)this.cancel_write_event__write_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_write_event__write_fd");
                }
            }
            if (this.cancel_write_event__read_fd != -1 && this.cancel_write_event__read_fd != this.cancel_write_event__write_fd) {
                try {
                    Unistd.close((int)this.cancel_write_event__read_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean close_event_read_fd");
                }
            }
            this.cancel_write_event__read_fd = -1;
            this.cancel_write_event__write_fd = -1;
        }
    }

    private static class FutureDone<V>
    implements Future<V> {
        private final Object outcome;

        FutureDone(V outcome) {
            this.outcome = outcome;
        }

        FutureDone(Exception outcome) {
            this.outcome = outcome;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            if (this.outcome instanceof Exception) {
                throw new ExecutionException((Exception)this.outcome);
            }
            return (V)this.outcome;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (unit == null) {
                throw new NullPointerException();
            }
            return this.get();
        }
    }
}

