/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.posix.Errno;
import de.ibapl.jnhw.posix.Fcntl;
import de.ibapl.jnhw.posix.Termios;
import de.ibapl.jnhw.posix.Unistd;
import de.ibapl.jnhw.unix.sys.Ioctl;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class PosixConfiguration {
    private static final Logger LOG = Logger.getLogger("d.i.s.jnhwprovider.PosixConfiguration");
    private static final int CMSPAR_OR_PAREXT;
    static final int INVALID_FD = -1;
    private final String portName;
    private int fd = -1;

    PosixConfiguration(String portName) {
        this.portName = portName;
    }

    int open(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        try {
            this.fd = Fcntl.open((String)this.portName, (int)(Fcntl.O_RDWR | Fcntl.O_NOCTTY | Fcntl.O_NONBLOCK));
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.EBUSY) {
                throw new IOException(String.format("Port is busy: \"%s\"", this.portName));
            }
            if (nee.errno == Errno.ENOENT) {
                throw new IOException(String.format("Port not found: \"%s\"", this.portName));
            }
            if (nee.errno == Errno.EACCES) {
                throw new IOException(String.format("Permission denied: \"%s\"", this.portName));
            }
            if (nee.errno == Errno.EIO) {
                throw new IOException(String.format("Not a serial port: \"%s\"", this.portName));
            }
            throw new IOException(String.format("Native port error \"%s:\" open \"%s\"", Errno.getErrnoSymbol((int)nee.errno), this.portName));
        }
        Termios.StructTermios termios = new Termios.StructTermios();
        try {
            Termios.tcgetattr((int)this.fd, (Termios.StructTermios)termios);
        }
        catch (NativeErrorException nee) {
            try {
                Unistd.close((int)this.fd);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            this.fd = -1;
            if (nee.errno == Errno.ENOTTY) {
                throw new IOException(String.format("Not a serial port: \"%s\"", this.portName));
            }
            throw new IOException("open tcgetattr " + Errno.getErrnoSymbol((int)nee.errno));
        }
        try {
            if (Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCEXCL) != 0) {
                LOG.severe("Unexpected result from ioctl(fd, TIOCEXCL())!");
            }
        }
        catch (NativeErrorException nee) {
            try {
                Unistd.close((int)this.fd);
                this.fd = -1;
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            throw new IOException("Can't set exclusive access errno: " + Errno.getErrnoSymbol((int)nee.errno));
        }
        termios.c_iflag(termios.c_iflag() & ~(Termios.IGNBRK | Termios.BRKINT | Termios.PARMRK | Termios.ISTRIP | Termios.INLCR | Termios.IGNCR | Termios.ICRNL | Termios.IXON));
        termios.c_oflag(termios.c_oflag() & ~Termios.OPOST);
        termios.c_lflag(termios.c_lflag() & ~(Termios.ECHO | Termios.ECHONL | Termios.ICANON | Termios.ISIG | Termios.IEXTEN));
        termios.c_cflag(termios.c_cflag() & ~(Termios.CSIZE | Termios.PARENB) | Termios.CS8 | Termios.CREAD | Termios.CLOCAL | Termios.HUPCL);
        termios.c_cc(Termios.VMIN, (byte)0);
        termios.c_cc(Termios.VTIME, (byte)0);
        try {
            this.setParams(termios, speed, dataBits, stopBits, parity, flowControls);
        }
        catch (Throwable t) {
            try {
                Unistd.close((int)this.fd);
                this.fd = -1;
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            throw t;
        }
        try {
            Termios.tcflush((int)this.fd, (int)Termios.TCIOFLUSH);
        }
        catch (NativeErrorException nee) {
            try {
                Unistd.close((int)this.fd);
                this.fd = -1;
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            throw new IOException("Can't flush device errno: " + Errno.getErrnoSymbol((int)nee.errno));
        }
        return this.fd;
    }

    void setInSpeed(Speed speed) throws IOException {
        Termios.StructTermios termios = this.getTermios();
        int speedValue = PosixConfiguration.speed2speed_t(speed);
        try {
            Termios.cfsetispeed((Termios.StructTermios)termios, (long)speedValue);
        }
        catch (NativeErrorException nee) {
            throw new IllegalArgumentException(this.formatMsg(nee, "Can't set Speed cfsetispeed(settings, speedValue)", new Object[0]));
        }
        if (this.getInSpeed(termios) != speed) {
            throw new IllegalArgumentException("Could not set inSpeed to: " + speed + " instead it is: " + this.getInSpeed(termios));
        }
    }

    void setOutSpeed(Speed speed) throws IOException {
        Termios.StructTermios termios = this.getTermios();
        int speedValue = PosixConfiguration.speed2speed_t(speed);
        try {
            Termios.cfsetospeed((Termios.StructTermios)termios, (long)speedValue);
        }
        catch (NativeErrorException nee) {
            throw new IllegalArgumentException(this.formatMsg(nee, "Can't set Speed cfsetospeed(settings, speedValue)", new Object[0]));
        }
        if (this.getOutSpeed(termios) != speed) {
            throw new IllegalArgumentException("Could not set outSpeed to: " + speed + " instead it is: " + this.getOutSpeed(termios));
        }
    }

    void setParams(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        this.setParams(this.getTermios(), speed, dataBits, stopBits, parity, flowControls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParams(Termios.StructTermios termios, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        if (speed != null) {
            int speedValue = PosixConfiguration.speed2speed_t(speed);
            try {
                Termios.cfsetspeed((Termios.StructTermios)termios, (long)speedValue);
            }
            catch (NativeErrorException nee) {
                throw new IllegalArgumentException(this.formatMsg(nee, "Can't set Speed cfsetspeed(settings, speedValue)", new Object[0]));
            }
        }
        if (dataBits != null) {
            termios.c_cflag(termios.c_cflag() & ~Termios.CSIZE);
            switch (dataBits) {
                case DB_5: {
                    termios.c_cflag(termios.c_cflag() | Termios.CS5);
                    break;
                }
                case DB_6: {
                    termios.c_cflag(termios.c_cflag() | Termios.CS6);
                    break;
                }
                case DB_7: {
                    termios.c_cflag(termios.c_cflag() | Termios.CS7);
                    break;
                }
                case DB_8: {
                    termios.c_cflag(termios.c_cflag() | Termios.CS8);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong databits");
                }
            }
        }
        if (stopBits != null) {
            switch (stopBits) {
                case SB_1: {
                    termios.c_cflag(termios.c_cflag() & ~Termios.CSTOPB);
                    break;
                }
                case SB_1_5: {
                    if ((termios.c_cflag() & Termios.CSIZE) != Termios.CS5) throw new IllegalArgumentException("setStopBits 1.5 stop bits are only valid for 5 DataBits");
                    termios.c_cflag(termios.c_cflag() | Termios.CSTOPB);
                    break;
                }
                case SB_2: {
                    if ((termios.c_cflag() & Termios.CSIZE) == Termios.CS5) {
                        throw new IllegalArgumentException("setStopBits 2 stop bits are only valid for 6,7,8 DataBits");
                    }
                    termios.c_cflag(termios.c_cflag() | Termios.CSTOPB);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown stopbits " + stopBits);
                }
            }
        }
        if (parity != null) {
            termios.c_cflag(termios.c_cflag() & ~(Termios.PARENB | Termios.PARODD | CMSPAR_OR_PAREXT));
            switch (parity) {
                case NONE: {
                    termios.c_iflag(termios.c_iflag() & ~Termios.INPCK);
                    break;
                }
                case ODD: {
                    termios.c_cflag(termios.c_cflag() | Termios.PARENB | Termios.PARODD);
                    termios.c_iflag(termios.c_iflag() | Termios.INPCK);
                    break;
                }
                case EVEN: {
                    termios.c_cflag(termios.c_cflag() | Termios.PARENB);
                    termios.c_iflag(termios.c_iflag() | Termios.INPCK);
                    break;
                }
                case MARK: {
                    termios.c_cflag(termios.c_cflag() | Termios.PARENB | Termios.PARODD | CMSPAR_OR_PAREXT);
                    termios.c_iflag(termios.c_iflag() | Termios.INPCK);
                    break;
                }
                case SPACE: {
                    termios.c_cflag(termios.c_cflag() | Termios.PARENB | CMSPAR_OR_PAREXT);
                    termios.c_iflag(termios.c_iflag() | Termios.INPCK);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong parity");
                }
            }
        }
        if (flowControls != null) {
            termios.c_cflag(termios.c_cflag() & ~Termios.CRTSCTS);
            termios.c_iflag(termios.c_iflag() & ~(Termios.IXON | Termios.IXOFF));
            if (flowControls.contains(FlowControl.RTS_CTS_IN)) {
                if (!flowControls.contains(FlowControl.RTS_CTS_OUT)) throw new IllegalArgumentException("Can only set RTS/CTS for both in and out");
                termios.c_cflag(termios.c_cflag() | Termios.CRTSCTS);
            } else if (flowControls.contains(FlowControl.RTS_CTS_OUT)) {
                throw new IllegalArgumentException("Can only set RTS/CTS for both in and out");
            }
            if (flowControls.contains(FlowControl.XON_XOFF_IN)) {
                termios.c_iflag(termios.c_iflag() | Termios.IXOFF);
            }
            if (flowControls.contains(FlowControl.XON_XOFF_OUT)) {
                termios.c_iflag(termios.c_iflag() | Termios.IXON);
            }
        }
        try {
            Termios.tcsetattr((int)this.fd, (int)Termios.TCSANOW, (Termios.StructTermios)termios);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.ERANGE) {
                throw new IllegalArgumentException(String.format("Native port error \"%s\" => setParams tcsetattr portname=%s, speed=%s, dataBits=%s, stopBits=%s, parity=%s, flowControls=%s", Errno.getErrnoSymbol((int)nee.errno), this.portName, speed, dataBits, stopBits, parity, flowControls));
            }
            if (nee.errno != Errno.EINVAL) throw new IOException(String.format("Native port error \"%s\" => setParams tcsetattr portname=%s, speed=%s, dataBits=%s, stopBits=%s, parity=%s, flowControls=%s", Errno.getErrnoSymbol((int)nee.errno), this.portName, speed, dataBits, stopBits, parity, flowControls));
            throw new IllegalArgumentException(String.format("Native port error \"%s\" => setParams tcsetattr portname=%s, speed=%s, dataBits=%s, stopBits=%s, parity=%s, flowControls=%s", Errno.getErrnoSymbol((int)nee.errno), this.portName, speed, dataBits, stopBits, parity, flowControls));
        }
        StringBuilder sb = null;
        termios = this.getTermios();
        if (parity != null && this.getParity(termios) != parity) {
            if (sb == null) {
                sb = new StringBuilder();
            }
            sb.append("Could not set parity to: ").append(parity).append(" instead it is: ").append(this.getParity(termios));
        }
        if (speed != null && this.getSpeed(termios) != speed) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append("Could not set speed to: ").append(speed).append(" instead it is: ").append(this.getSpeed(termios));
        }
        if (stopBits != null && this.getStopBits(termios) != stopBits) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append("Could not set stopBits to: ").append(stopBits).append(" instead it is: ").append(this.getStopBits(termios));
        }
        if (dataBits != null && this.getDatatBits(termios) != dataBits) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append("Could not set dataBits to: ").append(dataBits).append(" instead it is: ").append(this.getDatatBits(termios));
        }
        if (flowControls != null && !flowControls.equals(this.getFlowControl(termios))) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append("\n");
            }
            sb.append("Could not set flowContrel to: ").append(flowControls).append(" instead it is: ").append(this.getFlowControl(termios));
        }
        if (sb == null) return;
        throw new IllegalArgumentException(sb.toString());
    }

    DataBits getDatatBits() throws IOException {
        return this.getDatatBits(this.getTermios());
    }

    private DataBits getDatatBits(Termios.StructTermios termios) throws IOException {
        try {
            int masked = termios.c_cflag() & Termios.CSIZE;
            if (masked == Termios.CS5) {
                return DataBits.DB_5;
            }
            if (masked == Termios.CS6) {
                return DataBits.DB_6;
            }
            if (masked == Termios.CS7) {
                return DataBits.DB_7;
            }
            if (masked == Termios.CS8) {
                return DataBits.DB_8;
            }
            throw new IllegalArgumentException("Unknown databits in termios.c_cflag: " + termios.c_cflag());
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    Set<FlowControl> getFlowControl() throws IOException {
        return this.getFlowControl(this.getTermios());
    }

    private Set<FlowControl> getFlowControl(Termios.StructTermios termios) throws IOException {
        EnumSet<FlowControl> result = EnumSet.noneOf(FlowControl.class);
        if ((termios.c_cflag() & Termios.CRTSCTS) == Termios.CRTSCTS) {
            result.addAll(FlowControl.getFC_RTS_CTS());
        }
        if ((termios.c_iflag() & Termios.IXOFF) == Termios.IXOFF) {
            result.add(FlowControl.XON_XOFF_IN);
        }
        if ((termios.c_iflag() & Termios.IXON) == Termios.IXON) {
            result.add(FlowControl.XON_XOFF_OUT);
        }
        return result;
    }

    int getInBufferBytesCount() throws IOException {
        try {
            return Ioctl.ioctl_ReturnValue((int)this.fd, (int)Ioctl.FIONREAD, (int)0);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Can't read in buffer size ", new Object[0]));
        }
    }

    int getOutBufferBytesCount() throws IOException {
        try {
            return Ioctl.ioctl_ReturnValue((int)this.fd, (int)Ioctl.TIOCOUTQ, (int)0);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Can't read out buffer size ", new Object[0]));
        }
    }

    Parity getParity() throws IOException {
        return this.getParity(this.getTermios());
    }

    private Parity getParity(Termios.StructTermios termios) throws IOException {
        if ((termios.c_cflag() & Termios.PARENB) == 0) {
            return Parity.NONE;
        }
        if ((termios.c_cflag() & Termios.PARODD) == 0) {
            if ((termios.c_cflag() & CMSPAR_OR_PAREXT) == 0) {
                return Parity.EVEN;
            }
            return Parity.SPACE;
        }
        if ((termios.c_cflag() & CMSPAR_OR_PAREXT) == 0) {
            return Parity.ODD;
        }
        return Parity.MARK;
    }

    Speed getSpeed() throws IOException {
        return this.getSpeed(this.getTermios());
    }

    private Speed getSpeed(Termios.StructTermios termios) throws IOException {
        long outSpeed;
        long inSpeed = Termios.cfgetispeed((Termios.StructTermios)termios);
        if (inSpeed != (outSpeed = Termios.cfgetospeed((Termios.StructTermios)termios))) {
            throw new IOException("In and out speed mismatch In:" + PosixConfiguration.speed_t2speed(inSpeed) + " Out: " + PosixConfiguration.speed_t2speed(outSpeed));
        }
        return PosixConfiguration.speed_t2speed(inSpeed);
    }

    Speed getInSpeed() throws IOException {
        return this.getInSpeed(this.getTermios());
    }

    private Speed getInSpeed(Termios.StructTermios termios) throws IOException {
        return PosixConfiguration.speed_t2speed(Termios.cfgetispeed((Termios.StructTermios)termios));
    }

    Speed getOutSpeed() throws IOException {
        return this.getOutSpeed(this.getTermios());
    }

    private Speed getOutSpeed(Termios.StructTermios termios) throws IOException {
        return PosixConfiguration.speed_t2speed(Termios.cfgetospeed((Termios.StructTermios)termios));
    }

    char getXOFFChar() throws IOException {
        Termios.StructTermios termios = this.getTermios();
        return (char)termios.c_cc(Termios.VSTOP);
    }

    static Speed speed_t2speed(long speed_t) {
        if (speed_t == (long)Termios.B0) {
            return Speed._0_BPS;
        }
        if (speed_t == (long)Termios.B50) {
            return Speed._50_BPS;
        }
        if (speed_t == (long)Termios.B75) {
            return Speed._75_BPS;
        }
        if (speed_t == (long)Termios.B110) {
            return Speed._110_BPS;
        }
        if (speed_t == (long)Termios.B134) {
            return Speed._134_BPS;
        }
        if (speed_t == (long)Termios.B150) {
            return Speed._150_BPS;
        }
        if (speed_t == (long)Termios.B200) {
            return Speed._200_BPS;
        }
        if (speed_t == (long)Termios.B300) {
            return Speed._300_BPS;
        }
        if (speed_t == (long)Termios.B600) {
            return Speed._600_BPS;
        }
        if (speed_t == (long)Termios.B1200) {
            return Speed._1200_BPS;
        }
        if (speed_t == (long)Termios.B1800) {
            return Speed._1800_BPS;
        }
        if (speed_t == (long)Termios.B2400) {
            return Speed._2400_BPS;
        }
        if (speed_t == (long)Termios.B4800) {
            return Speed._4800_BPS;
        }
        if (speed_t == (long)Termios.B9600) {
            return Speed._9600_BPS;
        }
        if (speed_t == (long)Termios.B19200) {
            return Speed._19200_BPS;
        }
        if (speed_t == (long)Termios.B38400) {
            return Speed._38400_BPS;
        }
        if (speed_t == (long)Termios.B57600) {
            return Speed._57600_BPS;
        }
        if (speed_t == (long)Termios.B115200) {
            return Speed._115200_BPS;
        }
        if (speed_t == (long)Termios.B230400) {
            return Speed._230400_BPS;
        }
        if (Termios.B460800.isEqualsTo(speed_t)) {
            return Speed._460800_BPS;
        }
        if (Termios.B500000.isEqualsTo(speed_t)) {
            return Speed._500000_BPS;
        }
        if (Termios.B576000.isEqualsTo(speed_t)) {
            return Speed._576000_BPS;
        }
        if (Termios.B921600.isEqualsTo(speed_t)) {
            return Speed._921600_BPS;
        }
        if (Termios.B1000000.isEqualsTo(speed_t)) {
            return Speed._1000000_BPS;
        }
        if (Termios.B1152000.isEqualsTo(speed_t)) {
            return Speed._1152000_BPS;
        }
        if (Termios.B1500000.isEqualsTo(speed_t)) {
            return Speed._1500000_BPS;
        }
        if (Termios.B2000000.isEqualsTo(speed_t)) {
            return Speed._2000000_BPS;
        }
        if (Termios.B2500000.isEqualsTo(speed_t)) {
            return Speed._2500000_BPS;
        }
        if (Termios.B3000000.isEqualsTo(speed_t)) {
            return Speed._3000000_BPS;
        }
        if (Termios.B3500000.isEqualsTo(speed_t)) {
            return Speed._3500000_BPS;
        }
        if (Termios.B4000000.isEqualsTo(speed_t)) {
            return Speed._4000000_BPS;
        }
        throw new IllegalArgumentException("speed not supported: " + speed_t);
    }

    private static int speed2speed_t(Speed speed) {
        switch (speed) {
            case _0_BPS: {
                return Termios.B0;
            }
            case _50_BPS: {
                return Termios.B50;
            }
            case _75_BPS: {
                return Termios.B75;
            }
            case _110_BPS: {
                return Termios.B110;
            }
            case _134_BPS: {
                return Termios.B134;
            }
            case _150_BPS: {
                return Termios.B150;
            }
            case _200_BPS: {
                return Termios.B200;
            }
            case _300_BPS: {
                return Termios.B300;
            }
            case _600_BPS: {
                return Termios.B600;
            }
            case _1200_BPS: {
                return Termios.B1200;
            }
            case _1800_BPS: {
                return Termios.B1800;
            }
            case _2400_BPS: {
                return Termios.B2400;
            }
            case _4800_BPS: {
                return Termios.B4800;
            }
            case _9600_BPS: {
                return Termios.B9600;
            }
            case _19200_BPS: {
                return Termios.B19200;
            }
            case _38400_BPS: {
                return Termios.B38400;
            }
            case _57600_BPS: {
                return Termios.B57600;
            }
            case _115200_BPS: {
                return Termios.B115200;
            }
            case _230400_BPS: {
                return Termios.B230400;
            }
            case _460800_BPS: {
                if (Termios.B460800.isDefined()) {
                    return Termios.B460800.get();
                }
                throw new IllegalArgumentException("No defined! posix.B460800");
            }
            case _500000_BPS: {
                if (Termios.B500000.isDefined()) {
                    return Termios.B500000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B500000");
            }
            case _576000_BPS: {
                if (Termios.B576000.isDefined()) {
                    return Termios.B576000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B576000");
            }
            case _921600_BPS: {
                if (Termios.B921600.isDefined()) {
                    return Termios.B921600.get();
                }
                throw new IllegalArgumentException("No defined! posix.B921600");
            }
            case _1000000_BPS: {
                if (Termios.B1000000.isDefined()) {
                    return Termios.B1000000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B1000000");
            }
            case _1152000_BPS: {
                if (Termios.B1152000.isDefined()) {
                    return Termios.B1152000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B1152000");
            }
            case _1500000_BPS: {
                if (Termios.B1500000.isDefined()) {
                    return Termios.B1500000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B1500000");
            }
            case _2000000_BPS: {
                if (Termios.B2000000.isDefined()) {
                    return Termios.B2000000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B2000000");
            }
            case _2500000_BPS: {
                if (Termios.B2500000.isDefined()) {
                    return Termios.B2500000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B2500000");
            }
            case _3000000_BPS: {
                if (Termios.B3000000.isDefined()) {
                    return Termios.B3000000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B3000000");
            }
            case _3500000_BPS: {
                if (Termios.B3500000.isDefined()) {
                    return Termios.B3500000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B3500000");
            }
            case _4000000_BPS: {
                if (Termios.B4000000.isDefined()) {
                    return Termios.B4000000.get();
                }
                throw new IllegalArgumentException("No defined! posix.B4000000");
            }
        }
        throw new IllegalArgumentException("Speed not supported: " + speed);
    }

    StopBits getStopBits() throws IOException {
        return this.getStopBits(this.getTermios());
    }

    StopBits getStopBits(Termios.StructTermios termios) throws IOException {
        if ((termios.c_cflag() & Termios.CSTOPB) == 0) {
            return StopBits.SB_1;
        }
        if ((termios.c_cflag() & Termios.CSTOPB) == Termios.CSTOPB) {
            if ((termios.c_cflag() & Termios.CSIZE) == Termios.CS5) {
                return StopBits.SB_1_5;
            }
            return StopBits.SB_2;
        }
        throw new IllegalArgumentException("Can't figure out stop bits!");
    }

    char getXONChar() throws IOException {
        Termios.StructTermios termios = this.getTermios();
        return (char)termios.c_cc(Termios.VSTART);
    }

    boolean isCTS() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_CTS);
    }

    boolean isDCD() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_CAR);
    }

    boolean isDSR() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_DSR);
    }

    private boolean isFdValid() {
        try {
            return Fcntl.fcntl((int)this.fd, (int)Fcntl.F_GETFL) != -1;
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.EBADF) {
                LOG.log(Level.SEVERE, "Port {0} has invalid file descriptor", this.portName);
                return false;
            }
            LOG.log(Level.SEVERE, "file descriptor of port " + this.portName + " not valid unknown Native exception " + Errno.getErrnoSymbol((int)nee.errno), nee);
            return false;
        }
    }

    boolean isRI() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_RNG);
    }

    boolean getLineStatus(int bitMask) throws IOException {
        try {
            int lineStatusRef = Ioctl.ioctl_ReturnValue((int)this.fd, (int)Ioctl.TIOCMGET, (int)0);
            return (lineStatusRef & bitMask) == bitMask;
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Can't get line status ", new Object[0]));
        }
    }

    void setLineStatus(boolean enabled, int bitMask) throws IOException {
        int lineStatusRef;
        try {
            lineStatusRef = Ioctl.ioctl_ReturnValue((int)this.fd, (int)Ioctl.TIOCMGET, (int)0);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Can't get line status ", new Object[0]));
        }
        lineStatusRef = enabled ? (lineStatusRef |= bitMask) : (lineStatusRef &= ~bitMask);
        try {
            Ioctl.ioctl_ReturnValue((int)this.fd, (int)Ioctl.TIOCMSET, (int)lineStatusRef);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Can't set line status", new Object[0]));
        }
    }

    void setRTS(boolean enabled) throws IOException {
        this.setLineStatus(enabled, Ioctl.TIOCM_RTS);
    }

    void setDTR(boolean enabled) throws IOException {
        this.setLineStatus(enabled, Ioctl.TIOCM_DTR);
    }

    private Termios.StructTermios getTermios() throws IOException {
        Termios.StructTermios termios = new Termios.StructTermios();
        try {
            Termios.tcgetattr((int)this.fd, (Termios.StructTermios)termios);
            return termios;
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "Native port error => tcgetattr (%s)", this.portName));
        }
    }

    private String formatMsg(NativeErrorException nee, String formatString, Object ... args) {
        if (this.fd == -1) {
            return "Port is closed";
        }
        if (this.isFdValid()) {
            return String.format("Native port error on %s, \"%s\" %s", this.portName, Errno.getErrnoSymbol((int)nee.errno), String.format(formatString, args));
        }
        return "File descriptor of serial port is invalid";
    }

    public void setFd(int fd) {
        this.fd = fd;
    }

    void setXOFFChar(char c) throws IOException {
        Termios.StructTermios termios = this.getTermios();
        termios.c_cc(Termios.VSTOP, (byte)c);
        try {
            Termios.tcsetattr((int)this.fd, (int)Termios.TCSANOW, (Termios.StructTermios)termios);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "setXOFFChar tcsetattr", new Object[0]));
        }
        if (this.getXOFFChar() != c) {
            throw new RuntimeException("Cant't set XOFF char");
        }
    }

    void setXONChar(char c) throws IOException {
        Termios.StructTermios termios = this.getTermios();
        termios.c_cc(Termios.VSTART, (byte)c);
        try {
            Termios.tcsetattr((int)this.fd, (int)Termios.TCSANOW, (Termios.StructTermios)termios);
        }
        catch (NativeErrorException nee) {
            throw new IOException(this.formatMsg(nee, "setXONChar tcsetattr ", new Object[0]));
        }
        if (this.getXONChar() != c) {
            throw new RuntimeException("Cant't set XON char");
        }
    }

    String termiosToString() throws IOException {
        return this.getTermios().toString();
    }

    boolean isDTR() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_DTR);
    }

    boolean isRTS() throws IOException {
        return this.getLineStatus(Ioctl.TIOCM_RTS);
    }

    static {
        int value = 0;
        if (Termios.CMSPAR.isDefined()) {
            value = Termios.CMSPAR.get();
        } else if (Termios.PAREXT.isDefined()) {
            value = Termios.PAREXT.get();
        } else {
            LOG.warning("Parites SPACE and MARK will not work!");
        }
        CMSPAR_OR_PAREXT = value;
    }
}

