/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.common.memory.Memory32Heap;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.libloader.LoadState;
import de.ibapl.jnhw.linux.sys.Eventfd;
import de.ibapl.jnhw.posix.Errno;
import de.ibapl.jnhw.posix.Fcntl;
import de.ibapl.jnhw.posix.Poll;
import de.ibapl.jnhw.posix.Termios;
import de.ibapl.jnhw.posix.Time;
import de.ibapl.jnhw.posix.Unistd;
import de.ibapl.jnhw.unix.sys.Ioctl;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.spsw.api.AsynchronousCancelException;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.InOutSpeedConfiguration;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.api.TimeoutIOException;
import de.ibapl.spsw.jnhwprovider.PosixConfiguration;
import de.ibapl.spsw.jnhwprovider.StreamSerialPortSocket;
import de.ibapl.spsw.spi.SerialInputStream;
import de.ibapl.spsw.spi.SerialOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PosixSerialPortSocket
extends StreamSerialPortSocket<PosixSerialPortSocket>
implements InOutSpeedConfiguration {
    private static final int POLL_INFINITE_TIMEOUT = -1;
    public static final Cleaner CLEANER = Cleaner.create();
    private static final Logger LOG = Logger.getLogger("d.i.s.jnhwprovider.PosixPosixSerialPortSocket");
    private static final int POLL_TIMEOUT_INFINITE = -1;
    private static final int PORT_FD_IDX = 0;
    private static final int CANCEL_FD_IDX = 1;
    private volatile int fd = -1;
    private final PosixConfiguration posixConfiguration;
    private volatile int cancel_read_event__write_fd = -1;
    private volatile int cancel_read_event__read_fd = -1;
    private volatile int cancel_write_event__write_fd = -1;
    private volatile int cancel_write_event__read_fd = -1;
    private int interByteReadTimeout = 100;
    private int pollReadTimeout = -1;
    private int pollWriteTimeout = -1;
    private final FdCleaner fdCleaner = new FdCleaner();
    private final Object readLock = new Object();
    private final Object writeLock = new Object();
    private final Memory32Heap nativeMemoryBlock = new Memory32Heap(null, 0L, 1024, AbstractNativeMemory.SetMem.DO_NOT_SET);
    private final Poll.PollFds readPollFds;
    private final Poll.PollFds writePollFds;
    private final Time.Timespec readTimeout;
    private final Time.Timespec writeTimeout;
    private final Time.Timespec currentReadTime;
    private final Time.Timespec currentWriteTime;
    private static final boolean JNHW_HAVE_SYS_EVENTFD_H = Eventfd.HAVE_SYS_EVENTFD_H;

    PosixSerialPortSocket(String portName) throws IOException {
        this(portName, null, null, null, null, null);
    }

    PosixSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        super(portName);
        long offset = 0L;
        this.readPollFds = new Poll.PollFds((AbstractNativeMemory)this.nativeMemoryBlock, offset, 2);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.readPollFds, Poll.PollFd.alignof);
        this.writePollFds = new Poll.PollFds((AbstractNativeMemory)this.nativeMemoryBlock, offset, 2);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.writePollFds, Poll.PollFd.alignof);
        this.readTimeout = new Time.Timespec((AbstractNativeMemory)this.nativeMemoryBlock, offset, AbstractNativeMemory.SetMem.DO_NOT_SET);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.readTimeout, Poll.PollFd.alignof);
        this.writeTimeout = new Time.Timespec((AbstractNativeMemory)this.nativeMemoryBlock, offset, AbstractNativeMemory.SetMem.DO_NOT_SET);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.writeTimeout, Poll.PollFd.alignof);
        this.currentReadTime = new Time.Timespec((AbstractNativeMemory)this.nativeMemoryBlock, offset, AbstractNativeMemory.SetMem.DO_NOT_SET);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.currentReadTime, Poll.PollFd.alignof);
        this.currentWriteTime = new Time.Timespec((AbstractNativeMemory)this.nativeMemoryBlock, offset, AbstractNativeMemory.SetMem.DO_NOT_SET);
        offset = this.nativeMemoryBlock.nextOffset((AbstractNativeMemory)this.currentWriteTime, Alignment.AT_1);
        this.posixConfiguration = new PosixConfiguration(portName);
        if (LoadState.SUCCESS != LibJnhwPosixLoader.touch()) {
            throw new RuntimeException("Could not load native lib: ", LibJnhwPosixLoader.getLoadResult().loadError);
        }
        this.open(speed, dataBits, stopBits, parity, flowControls);
    }

    @Override
    protected void implCloseChannel() throws IOException {
        super.implCloseChannel();
        if (this.fd != -1) {
            int tempFd = this.fd;
            this.fd = -1;
            this.posixConfiguration.setFd(this.fd);
            ByteBuffer evt_buff = ByteBuffer.allocateDirect(8);
            evt_buff.putLong(1L);
            evt_buff.flip();
            try {
                Unistd.write((int)this.cancel_write_event__write_fd, (ByteBuffer)evt_buff);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Error writing to cancel_write_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            evt_buff.clear();
            evt_buff.putLong(1L);
            evt_buff.flip();
            try {
                Unistd.write((int)this.cancel_read_event__write_fd, (ByteBuffer)evt_buff);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Error writing to cancel_read_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            try {
                Termios.tcflush((int)tempFd, (int)Termios.TCIOFLUSH);
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "Native Error flushing " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "unknown Error flushing ", t);
            }
            try {
                Unistd.close((int)tempFd);
                this.fdCleaner.fd = -1;
                this.cancel_read_event__read_fd = -1;
                this.cancel_read_event__write_fd = -1;
                this.cancel_write_event__read_fd = -1;
                this.cancel_write_event__write_fd = -1;
            }
            catch (NativeErrorException nee) {
                LOG.log(Level.SEVERE, "unknown Error during closing " + Errno.getErrnoSymbol((int)nee.errno), nee);
            }
        }
    }

    public DataBits getDatatBits() throws IOException {
        return this.posixConfiguration.getDatatBits();
    }

    public Set<FlowControl> getFlowControl() throws IOException {
        return this.posixConfiguration.getFlowControl();
    }

    public int getInBufferBytesCount() throws IOException {
        return this.posixConfiguration.getInBufferBytesCount();
    }

    public int getInterByteReadTimeout() throws IOException {
        return this.interByteReadTimeout;
    }

    public int getOutBufferBytesCount() throws IOException {
        return this.posixConfiguration.getOutBufferBytesCount();
    }

    public int getOverallReadTimeout() throws IOException {
        return this.pollReadTimeout == -1 ? 0 : this.pollReadTimeout;
    }

    public int getOverallWriteTimeout() throws IOException {
        return this.pollWriteTimeout == -1 ? 0 : this.pollWriteTimeout;
    }

    public Parity getParity() throws IOException {
        return this.posixConfiguration.getParity();
    }

    public Speed getSpeed() throws IOException {
        return this.posixConfiguration.getSpeed();
    }

    public Speed getInSpeed() throws IOException {
        return this.posixConfiguration.getInSpeed();
    }

    public Speed getOutSpeed() throws IOException {
        return this.posixConfiguration.getOutSpeed();
    }

    public StopBits getStopBits() throws IOException {
        return this.posixConfiguration.getStopBits();
    }

    public char getXOFFChar() throws IOException {
        return this.posixConfiguration.getXOFFChar();
    }

    public char getXONChar() throws IOException {
        return this.posixConfiguration.getXONChar();
    }

    public boolean isCTS() throws IOException {
        return this.posixConfiguration.isCTS();
    }

    public boolean isDCD() throws IOException {
        return this.posixConfiguration.isDCD();
    }

    public boolean isDSR() throws IOException {
        return this.posixConfiguration.isDSR();
    }

    private boolean isFdValid() {
        try {
            return Fcntl.fcntl((int)this.fd, (int)Fcntl.F_GETFL) != -1;
        }
        catch (NativeErrorException nee) {
            if (nee.errno == Errno.EBADF) {
                LOG.log(Level.SEVERE, "Port {0} has invalid file descriptor", this.portName);
                return false;
            }
            LOG.log(Level.SEVERE, "file descriptor of port " + this.portName + " not valid unknown Native exception " + Errno.getErrnoSymbol((int)nee.errno), nee);
            return false;
        }
    }

    public boolean isRI() throws IOException {
        return this.posixConfiguration.isRI();
    }

    private synchronized void open(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        this.fd = this.posixConfiguration.open(speed, dataBits, stopBits, parity, flowControls);
        try {
            if (JNHW_HAVE_SYS_EVENTFD_H) {
                this.cancel_read_event__write_fd = this.cancel_read_event__read_fd = Eventfd.eventfd((int)0, (int)Eventfd.EFD_NONBLOCK);
                this.cancel_write_event__write_fd = this.cancel_write_event__read_fd = Eventfd.eventfd((int)0, (int)Eventfd.EFD_NONBLOCK);
            } else {
                Int32_t read_fd = new Int32_t();
                Int32_t write_fd = new Int32_t();
                Unistd.pipe((Int32_t)read_fd, (Int32_t)write_fd);
                this.cancel_read_event__read_fd = read_fd.int32_t();
                this.cancel_read_event__write_fd = write_fd.int32_t();
                Fcntl.fcntl((int)this.cancel_read_event__read_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Fcntl.fcntl((int)this.cancel_read_event__write_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Unistd.pipe((Int32_t)read_fd, (Int32_t)write_fd);
                this.cancel_write_event__read_fd = read_fd.int32_t();
                this.cancel_write_event__write_fd = write_fd.int32_t();
                Fcntl.fcntl((int)this.cancel_write_event__read_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
                Fcntl.fcntl((int)this.cancel_write_event__write_fd, (int)Fcntl.F_SETFL, (int)Fcntl.O_NONBLOCK);
            }
        }
        catch (NativeErrorException nee) {
            try {
                Unistd.close((int)this.fd);
                this.fd = -1;
                this.posixConfiguration.setFd(this.fd);
            }
            catch (NativeErrorException nativeErrorException) {
                // empty catch block
            }
            throw new IOException("Can't create close_event_fd");
        }
        this.fdCleaner.fd = this.fd;
        this.fdCleaner.cancel_read_event__read_fd = this.cancel_read_event__read_fd;
        this.fdCleaner.cancel_read_event__write_fd = this.cancel_read_event__write_fd;
        this.fdCleaner.cancel_write_event__read_fd = this.cancel_write_event__read_fd;
        this.fdCleaner.cancel_write_event__write_fd = this.cancel_write_event__write_fd;
        CLEANER.register(this, this.fdCleaner);
        ((Poll.PollFd)this.writePollFds.get(0)).fd(this.fd);
        ((Poll.PollFd)this.writePollFds.get(0)).events(Poll.POLLOUT);
        ((Poll.PollFd)this.writePollFds.get(1)).fd(this.cancel_write_event__read_fd);
        ((Poll.PollFd)this.writePollFds.get(1)).events(Poll.POLLIN);
        ((Poll.PollFd)this.readPollFds.get(0)).fd(this.fd);
        ((Poll.PollFd)this.readPollFds.get(0)).events(Poll.POLLIN);
        ((Poll.PollFd)this.readPollFds.get(1)).fd(this.cancel_read_event__read_fd);
        ((Poll.PollFd)this.readPollFds.get(1)).events(Poll.POLLIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBreak(int duration) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (duration <= 0) {
                throw new IllegalArgumentException("sendBreak duration must be greater than 0)");
            }
            boolean completed = false;
            try {
                this.begin();
                try {
                    Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCSBRK);
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't set Break ", new Object[0]));
                }
                try {
                    Thread.sleep(duration);
                }
                catch (InterruptedException ie) {
                    try {
                        Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCCBRK);
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new IOException(this.formatMsg(nee, "Can't clear Break after aborted wait", new Object[0]), ie);
                    }
                    completed = true;
                    throw new RuntimeException("Wait interrupted", ie);
                }
                try {
                    Ioctl.ioctl((int)this.fd, (int)Ioctl.TIOCCBRK);
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't clear Break ", new Object[0]));
                }
                completed = true;
            }
            finally {
                this.end(completed);
            }
        }
    }

    public void sendXOFF() throws IOException {
        throw new IllegalArgumentException("sendXOFF not implemented yet");
    }

    public void sendXON() throws IOException {
        throw new IllegalArgumentException("sendXON not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreak(boolean enabled) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int arg = enabled ? Ioctl.TIOCSBRK : Ioctl.TIOCCBRK;
            try {
                Ioctl.ioctl((int)this.fd, (int)arg);
            }
            catch (NativeErrorException nee) {
                throw new IOException(this.formatMsg(nee, "Can't set Break ", new Object[0]));
            }
        }
    }

    public void setDataBits(DataBits dataBits) throws IOException {
        this.posixConfiguration.setParams(null, dataBits, null, null, null);
    }

    public void setDTR(boolean enabled) throws IOException {
        this.posixConfiguration.setDTR(enabled);
    }

    public void setFlowControl(Set<FlowControl> flowControls) throws IOException {
        this.posixConfiguration.setParams(null, null, null, null, flowControls);
    }

    public void setParity(Parity parity) throws IOException {
        this.posixConfiguration.setParams(null, null, null, parity, null);
    }

    public void setRTS(boolean enabled) throws IOException {
        this.posixConfiguration.setRTS(enabled);
    }

    public void setSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setParams(speed, null, null, null, null);
    }

    public void setInSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setInSpeed(speed);
    }

    public void setOutSpeed(Speed speed) throws IOException {
        this.posixConfiguration.setOutSpeed(speed);
    }

    public void setStopBits(StopBits stopBits) throws IOException {
        this.posixConfiguration.setParams(null, null, stopBits, null, null);
    }

    public void setTimeouts(int interByteReadTimeout, int overallReadTimeout, int overallWriteTimeout) throws IOException {
        if (overallWriteTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallWriteTimeout must >= 0");
        }
        if (overallReadTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallReadTimeout must >= 0");
        }
        if (interByteReadTimeout < 0) {
            throw new IllegalArgumentException("setReadTimeouts: interByteReadTimeout must >= 0");
        }
        this.interByteReadTimeout = interByteReadTimeout;
        this.pollReadTimeout = overallReadTimeout == 0 ? -1 : overallReadTimeout;
        this.pollWriteTimeout = overallWriteTimeout == 0 ? -1 : overallWriteTimeout;
    }

    public void setXOFFChar(char c) throws IOException {
        this.posixConfiguration.setXOFFChar(c);
    }

    public void setXONChar(char c) throws IOException {
        this.posixConfiguration.setXONChar(c);
    }

    public String termiosToString() throws IOException {
        return this.posixConfiguration.termiosToString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            int n;
            int written;
            if (!src.hasRemaining()) {
                return 0;
            }
            try {
                written = Unistd.write((int)this.fd, (ByteBuffer)src);
                if (!src.hasRemaining()) {
                    return written;
                }
            }
            catch (NativeErrorException nee) {
                if (nee.errno == Errno.EAGAIN) {
                    written = 0;
                }
                if (this.fd == -1) {
                    throw new AsynchronousCloseException();
                }
                if (nee.errno == Errno.EBADF) {
                    throw new InterruptedIOException("File descriptor of serial port is invalid");
                }
                throw new InterruptedIOException(this.formatMsg(nee, "unknown port error write ", new Object[0]));
            }
            Time.Timespec endTime = this.pollWriteTimeout != -1 ? this.writeTimeout : null;
            try {
                if (this.pollWriteTimeout != -1) {
                    Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)endTime);
                    endTime.tv_sec(endTime.tv_sec() + (long)(this.pollWriteTimeout / 1000));
                    endTime.tv_nsec(endTime.tv_nsec() + (long)(this.pollWriteTimeout % 1000 * 1000000));
                    if (endTime.tv_nsec() > 1000000000L) {
                        endTime.tv_sec(endTime.tv_sec() + 1L);
                        endTime.tv_nsec(endTime.tv_nsec() - 1000000000L);
                    }
                }
            }
            catch (NativeErrorException ex) {
                throw new RuntimeException(ex);
            }
            boolean completed = false;
            try {
                this.begin();
                int offset = written;
                do {
                    try {
                        int poll_result;
                        if (this.pollWriteTimeout == -1) {
                            poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)-1);
                        } else {
                            Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)this.currentWriteTime);
                            int remainingTimeOut = (int)(endTime.tv_sec() - this.currentWriteTime.tv_sec()) * 1000 + (int)((endTime.tv_nsec() - this.currentWriteTime.tv_nsec()) / 1000000L);
                            if (remainingTimeOut < 0) {
                                throw new TimeoutIOException();
                            }
                            poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)remainingTimeOut);
                        }
                        if (poll_result == 0) {
                            TimeoutIOException tioe = new TimeoutIOException();
                            tioe.bytesTransferred = written;
                            completed = true;
                            throw tioe;
                        }
                        if (((Poll.PollFd)this.writePollFds.get(1)).revents() == Poll.POLLIN) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (((Poll.PollFd)this.writePollFds.get(0)).revents() != Poll.POLLOUT) {
                            if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                                completed = true;
                                throw new InterruptedIOException("File descriptor of serial port is invalid");
                            }
                            if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                                completed = true;
                                if (this.fd == -1) {
                                    throw new AsynchronousCloseException();
                                }
                                throw new AsynchronousCancelException();
                            }
                            InterruptedIOException iioe = new InterruptedIOException("poll returned with poll event write ");
                            iioe.bytesTransferred = offset;
                            completed = true;
                            throw iioe;
                        }
                    }
                    catch (NativeErrorException nee) {
                        InterruptedIOException iioe = new InterruptedIOException(this.formatMsg(nee, "poll timeout with error in write!", new Object[0]));
                        iioe.initCause(nee);
                        iioe.bytesTransferred = offset;
                        completed = true;
                        throw iioe;
                    }
                    try {
                        offset += Unistd.write((int)this.fd, (ByteBuffer)src);
                    }
                    catch (NativeErrorException nee) {
                        if (this.fd == -1) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (nee.errno == Errno.EBADF) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        InterruptedIOException iioe = new InterruptedIOException(this.formatMsg(nee, "error during Unistd.write", new Object[0]));
                        iioe.bytesTransferred = offset;
                        completed = true;
                        throw iioe;
                    }
                } while (src.hasRemaining());
                completed = true;
                n = offset;
            }
            catch (Throwable throwable) {
                this.end(completed);
                throw throwable;
            }
            this.end(completed);
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int write(byte b) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            block26: {
                try {
                    int written = Unistd.write((int)this.fd, (byte)b);
                    if (written == 1) {
                        return written;
                    }
                }
                catch (NativeErrorException nee) {
                    if (nee.errno == Errno.EAGAIN) break block26;
                    if (this.fd == -1) {
                        throw new AsynchronousCloseException();
                    }
                    if (nee.errno == Errno.EBADF) {
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    throw new InterruptedIOException(this.formatMsg(nee, "unknown port error write ", new Object[0]));
                }
            }
            boolean completed = false;
            try {
                block27: {
                    int iioe3;
                    this.begin();
                    try {
                        int poll_result = this.pollWriteTimeout == -1 ? Poll.poll((Poll.PollFds)this.writePollFds, (int)-1) : Poll.poll((Poll.PollFds)this.writePollFds, (int)this.pollWriteTimeout);
                        if (poll_result == 0) {
                            TimeoutIOException tioe = new TimeoutIOException();
                            tioe.bytesTransferred = 0;
                            completed = true;
                            throw tioe;
                        }
                        if (((Poll.PollFd)this.writePollFds.get(1)).revents() == Poll.POLLIN) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (((Poll.PollFd)this.writePollFds.get(0)).revents() != Poll.POLLOUT) {
                            if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                                completed = true;
                                throw new InterruptedIOException("File descriptor of serial port is invalid");
                            }
                            if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                                completed = true;
                                if (this.fd == -1) {
                                    throw new AsynchronousCloseException();
                                }
                                throw new AsynchronousCancelException();
                            }
                            InterruptedIOException iioe2 = new InterruptedIOException("poll returned with poll event write ");
                            iioe2.bytesTransferred = 0;
                            completed = true;
                            throw iioe2;
                        }
                    }
                    catch (NativeErrorException nee) {
                        InterruptedIOException iioe3 = new InterruptedIOException(this.formatMsg(nee, "poll timeout with error in write!", new Object[0]));
                        iioe3.initCause(nee);
                        iioe3.bytesTransferred = 0;
                        completed = true;
                        throw iioe3;
                    }
                    try {
                        int written = Unistd.write((int)this.fd, (byte)b);
                        if (written != 1) break block27;
                        completed = true;
                        iioe3 = written;
                    }
                    catch (NativeErrorException nee) {
                        if (this.fd == -1) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (nee.errno == Errno.EBADF) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        InterruptedIOException iioe4 = new InterruptedIOException(this.formatMsg(nee, "error during Unistd.write", new Object[0]));
                        iioe4.bytesTransferred = 0;
                        completed = true;
                        throw iioe4;
                    }
                    return iioe3;
                }
                completed = true;
                throw new RuntimeException("Should never ever happen!");
            }
            finally {
                this.end(completed);
            }
        }
    }

    private String formatMsg(NativeErrorException nee, String formatString, Object ... args) {
        if (this.fd == -1) {
            return "Port is closed";
        }
        if (this.isFdValid()) {
            return String.format("Native port error on %s, \"%s\" %s", this.portName, Errno.getErrnoSymbol((int)nee.errno), String.format(formatString, args));
        }
        return "File descriptor of serial port is invalid";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int read(ByteBuffer dst) throws IOException {
        Time.Timespec endTime;
        int nread;
        block49: {
            Object object = this.readLock;
            // MONITORENTER : object
            if (!dst.hasRemaining()) {
                // MONITOREXIT : object
                return 0;
            }
            try {
                nread = Unistd.read((int)this.fd, (ByteBuffer)dst);
                if (!dst.hasRemaining()) {
                    // MONITOREXIT : object
                    return nread;
                }
            }
            catch (NativeErrorException nee) {
                if (this.fd == -1) {
                    throw new AsynchronousCloseException();
                }
                if (nee.errno != Errno.EAGAIN) {
                    if (nee.errno != Errno.EBADF) throw new InterruptedIOException("read: read error during first invocation of read() " + Errno.getErrnoSymbol((int)nee.errno));
                    throw new InterruptedIOException("File descriptor of serial port is invalid");
                }
                nread = 0;
            }
            endTime = this.pollReadTimeout != -1 ? this.readTimeout : null;
            try {
                if (this.pollReadTimeout == -1) break block49;
                Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)endTime);
                endTime.tv_sec(endTime.tv_sec() + (long)(this.pollReadTimeout / 1000));
                endTime.tv_nsec(endTime.tv_nsec() + (long)(this.pollReadTimeout % 1000 * 1000000));
                if (endTime.tv_nsec() > 1000000000L) {
                    endTime.tv_sec(endTime.tv_sec() + 1L);
                    endTime.tv_nsec(endTime.tv_nsec() - 1000000000L);
                }
            }
            catch (NativeErrorException ex) {
                throw new RuntimeException(ex);
            }
        }
        boolean completed = false;
        try {
            block50: {
                this.begin();
                if (nread == 0) {
                    try {
                        int poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)this.pollReadTimeout);
                        if (poll_result == 0) {
                            completed = true;
                            throw new TimeoutIOException();
                        }
                        if (((Poll.PollFd)this.readPollFds.get(1)).revents() == Poll.POLLIN) {
                            completed = true;
                            if (this.fd != -1) throw new AsynchronousCancelException();
                            throw new AsynchronousCloseException();
                        }
                        if (((Poll.PollFd)this.readPollFds.get(0)).revents() == Poll.POLLIN) {
                            try {
                                nread = Unistd.read((int)this.fd, (ByteBuffer)dst);
                                if (!dst.hasRemaining()) {
                                    completed = true;
                                    int n = nread;
                                    return n;
                                }
                                break block50;
                            }
                            catch (NativeErrorException nee) {
                                if (this.fd == -1) {
                                    completed = true;
                                    if (this.fd != -1) throw new AsynchronousCancelException();
                                    throw new AsynchronousCloseException();
                                }
                                if (nee.errno == Errno.EBADF) {
                                    completed = true;
                                    throw new InterruptedIOException("File descriptor of serial port is invalid");
                                }
                                completed = true;
                                throw new IOException("Readed " + nread + " bytes.  Unknown Error: " + Errno.getErrnoSymbol((int)nee.errno));
                            }
                        }
                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd != -1) throw new AsynchronousCancelException();
                            throw new AsynchronousCloseException();
                        }
                        completed = true;
                        throw new InterruptedIOException("read poll: received poll event fds:\n" + this.readPollFds.toString());
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new InterruptedIOException("read poll: Error during poll errno: " + Errno.getErrnoSymbol((int)nee.errno));
                    }
                }
            }
            int overallRead = nread;
            do {
                int n;
                int poll_result;
                block51: {
                    try {
                        if (this.pollReadTimeout == -1) {
                            poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)this.interByteReadTimeout);
                            break block51;
                        }
                        Time.clock_gettime((int)Time.CLOCK_MONOTONIC, (Time.Timespec)this.currentReadTime);
                        int remainingTimeOut = (int)(endTime.tv_sec() - this.currentReadTime.tv_sec()) * 1000 + (int)((endTime.tv_nsec() - this.currentReadTime.tv_nsec()) / 1000000L);
                        if (remainingTimeOut < 0) {
                            completed = true;
                            int n2 = overallRead;
                            return n2;
                        }
                        poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)(this.interByteReadTimeout < remainingTimeOut ? this.interByteReadTimeout : remainingTimeOut));
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new InterruptedIOException("read poll: Error during poll " + Errno.getErrnoSymbol((int)nee.errno));
                    }
                }
                if (poll_result == 0) {
                    completed = true;
                    n = overallRead;
                    return n;
                }
                if (((Poll.PollFd)this.readPollFds.get(1)).revents() == Poll.POLLIN) {
                    completed = true;
                    n = -1;
                    return n;
                }
                if (((Poll.PollFd)this.readPollFds.get(0)).revents() != Poll.POLLIN) {
                    if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                        completed = true;
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                        completed = true;
                        if (this.fd != -1) throw new AsynchronousCancelException();
                        throw new AsynchronousCloseException();
                    }
                    completed = true;
                    throw new InterruptedIOException("read poll: received poll event fds:\n" + this.readPollFds.toString());
                }
                try {
                    overallRead += Unistd.read((int)this.fd, (ByteBuffer)dst);
                }
                catch (NativeErrorException nee) {
                    if (this.fd == -1) {
                        completed = true;
                        if (this.fd != -1) throw new AsynchronousCancelException();
                        throw new AsynchronousCloseException();
                    }
                    if (nee.errno == Errno.EBADF) {
                        completed = true;
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    completed = true;
                    throw new IOException("Readed " + overallRead + " bytes.  Unknown Error: " + Errno.getErrnoSymbol((int)nee.errno));
                }
            } while (dst.hasRemaining());
            completed = true;
            int n = overallRead;
            return n;
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "IO ex for: " + this.portName, ioe);
            throw ioe;
        }
        finally {
            this.end(completed);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public int read() throws IOException {
        var1_1 = this.readLock;
        synchronized (var1_1) {
            block29: {
                try {
                    nread = Unistd.read((int)this.fd);
                    if (Unistd.jnhwIsSingeByteRead((short)nread)) {
                        return Unistd.jnhwSingeByteReadToInt((short)nread);
                    }
                }
                catch (NativeErrorException nee) {
                    if (this.fd == -1) {
                        throw new AsynchronousCloseException();
                    }
                    if (nee.errno == Errno.EAGAIN) break block29;
                    if (nee.errno == Errno.EBADF) {
                        throw new InterruptedIOException("File descriptor of serial port is invalid");
                    }
                    throw new InterruptedIOException("read: read error during first invocation of read() " + Errno.getErrnoSymbol((int)nee.errno));
                }
            }
            completed = false;
            try {
                block30: {
                    this.begin();
                    poll_result = Poll.poll((Poll.PollFds)this.readPollFds, (int)this.pollReadTimeout);
                    if (poll_result == 0) {
                        completed = true;
                        throw new TimeoutIOException();
                    }
                    if (((Poll.PollFd)this.readPollFds.get(1)).revents() == Poll.POLLIN) {
                        completed = true;
                        if (this.fd == -1) {
                            throw new AsynchronousCloseException();
                        }
                        throw new AsynchronousCancelException();
                    }
                    if (((Poll.PollFd)this.readPollFds.get(0)).revents() != Poll.POLLIN) ** GOTO lbl54
                    nread = Unistd.read((int)this.fd);
                    if (!Unistd.jnhwIsSingeByteRead((short)nread)) break block30;
                    completed = true;
                    var5_9 = Unistd.jnhwSingeByteReadToInt((short)nread);
                    return var5_9;
                }
                try {
                    try {
                        completed = true;
                        throw new RuntimeException("Should never ever happen!");
                        {
                            catch (NativeErrorException nee) {
                                if (this.fd == -1) {
                                    completed = true;
                                    if (this.fd == -1) {
                                        throw new AsynchronousCloseException();
                                    }
                                    throw new AsynchronousCancelException();
                                }
                                if (nee.errno == Errno.EBADF) {
                                    completed = true;
                                    throw new InterruptedIOException("File descriptor of serial port is invalid");
                                }
                                completed = true;
                                throw new IOException("read single byte - Unknown Error: " + Errno.getErrnoSymbol((int)nee.errno));
                            }
                        }
lbl54:
                        // 1 sources

                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            completed = true;
                            throw new InterruptedIOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.readPollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        completed = true;
                        throw new InterruptedIOException("read poll: received poll event fds:\n" + this.readPollFds.toString());
                    }
                    catch (NativeErrorException nee) {
                        completed = true;
                        throw new InterruptedIOException("read poll: Error during poll errno: " + Errno.getErrnoSymbol((int)nee.errno));
                    }
                }
                catch (IOException ioe) {
                    PosixSerialPortSocket.LOG.log(Level.SEVERE, "IO ex for: " + this.portName, ioe);
                    completed = true;
                    throw ioe;
                }
            }
            finally {
                this.end(completed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainOutputBuffer() throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            boolean completed = false;
            try {
                this.begin();
                try {
                    int poll_result = Poll.poll((Poll.PollFds)this.writePollFds, (int)this.pollWriteTimeout);
                    if (poll_result == 0) {
                        throw new TimeoutIOException();
                    }
                    if (((Poll.PollFd)this.writePollFds.get(1)).revents() == Poll.POLLIN) {
                        throw new IOException("Port is closed");
                    }
                    if (((Poll.PollFd)this.writePollFds.get(0)).revents() != Poll.POLLOUT) {
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLHUP) == Poll.POLLHUP) {
                            throw new IOException("File descriptor of serial port is invalid");
                        }
                        if ((((Poll.PollFd)this.writePollFds.get(0)).revents() & Poll.POLLNVAL) == Poll.POLLNVAL) {
                            completed = true;
                            if (this.fd == -1) {
                                throw new AsynchronousCloseException();
                            }
                            throw new AsynchronousCancelException();
                        }
                        if (this.fd == -1) {
                            throw new IOException("Port is closed");
                        }
                        throw new IOException("drainOutputBuffer poll => : received unexpected event and port not closed");
                    }
                }
                catch (NativeErrorException nee) {
                    throw new IOException(this.formatMsg(nee, "drainOutputBuffer poll: Error during poll ", new Object[0]));
                }
                try {
                    Termios.tcdrain((int)this.fd);
                    completed = true;
                }
                catch (NativeErrorException nee) {
                    completed = true;
                    throw new IOException(this.formatMsg(nee, "Can't drain the output buffer ", new Object[0]));
                }
            }
            finally {
                this.end(completed);
            }
        }
    }

    public boolean isDTR() throws IOException {
        return this.posixConfiguration.isDTR();
    }

    public boolean isRTS() throws IOException {
        return this.posixConfiguration.isRTS();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.ensureOpen();
        if (this.is == null) {
            this.is = new SerialInputStream<PosixSerialPortSocket>(this){

                public int read() throws IOException {
                    try {
                        return ((PosixSerialPortSocket)this.serialPortSocket).read();
                    }
                    catch (AsynchronousCloseException ace) {
                        return -1;
                    }
                }
            };
        }
        return this.is;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        this.ensureOpen();
        if (this.os == null) {
            this.os = new SerialOutputStream<PosixSerialPortSocket>(this){

                public void write(int b) throws IOException {
                    ((PosixSerialPortSocket)this.serialPortSocket).write((byte)b);
                }
            };
        }
        return this.os;
    }

    static class FdCleaner
    implements Runnable {
        int fd = -1;
        int cancel_read_event__write_fd = -1;
        int cancel_read_event__read_fd = -1;
        int cancel_write_event__write_fd = -1;
        int cancel_write_event__read_fd = -1;

        FdCleaner() {
        }

        @Override
        public void run() {
            ByteBuffer evt_buff;
            if (this.cancel_read_event__write_fd != -1) {
                evt_buff = ByteBuffer.allocateDirect(8);
                evt_buff.putLong(1L);
                evt_buff.flip();
                try {
                    Unistd.write((int)this.cancel_read_event__write_fd, (ByteBuffer)evt_buff);
                    Unistd.usleep((int)1000);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "Error writing to cancel_read_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
                }
            }
            if (this.cancel_write_event__write_fd != -1) {
                evt_buff = ByteBuffer.allocateDirect(8);
                evt_buff.putLong(1L);
                evt_buff.flip();
                try {
                    Unistd.write((int)this.cancel_write_event__write_fd, (ByteBuffer)evt_buff);
                    Unistd.usleep((int)1000);
                }
                catch (NativeErrorException nee) {
                    LOG.log(Level.SEVERE, "Error writing to cancel_write_event__write_fd error: " + Errno.getErrnoSymbol((int)nee.errno), nee);
                }
            }
            if (this.fd != -1) {
                try {
                    Unistd.close((int)this.fd);
                    this.fd = -1;
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean fd");
                }
            }
            if (this.cancel_read_event__write_fd != -1) {
                try {
                    Unistd.close((int)this.cancel_read_event__write_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_read_event__write_fd");
                }
            }
            if (this.cancel_read_event__read_fd != -1 && this.cancel_read_event__read_fd != this.cancel_read_event__write_fd) {
                try {
                    Unistd.close((int)this.cancel_read_event__read_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_read_event__read_fd");
                }
            }
            this.cancel_read_event__read_fd = -1;
            this.cancel_read_event__write_fd = -1;
            if (this.cancel_write_event__write_fd != -1) {
                try {
                    Unistd.close((int)this.cancel_write_event__write_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean cancel_write_event__write_fd");
                }
            }
            if (this.cancel_write_event__read_fd != -1 && this.cancel_write_event__read_fd != this.cancel_write_event__write_fd) {
                try {
                    Unistd.close((int)this.cancel_write_event__read_fd);
                }
                catch (NativeErrorException ex) {
                    LOG.severe("can't clean close_event_read_fd");
                }
            }
            this.cancel_write_event__read_fd = -1;
            this.cancel_write_event__write_fd = -1;
        }
    }
}

