/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jnhwprovider;

import de.ibapl.jnhw.libloader.MultiarchTupelBuilder;
import de.ibapl.jnhw.libloader.OS;
import de.ibapl.spsw.api.AsyncSerialPortSocket;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.PortnamesComparator;
import de.ibapl.spsw.api.SerialPortSocket;
import de.ibapl.spsw.api.SerialPortSocketFactory;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.jnhwprovider.GenericWinSerialPortSocket;
import de.ibapl.spsw.jnhwprovider.PosixAsyncSerialPortSocket;
import de.ibapl.spsw.jnhwprovider.PosixSerialPortSocket;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ServiceScope;

@Component(name="de.ibapl.spsw.jnhwprovider", scope=ServiceScope.SINGLETON, immediate=true)
public class SerialPortSocketFactoryImpl
implements SerialPortSocketFactory {
    protected static final Logger LOG = Logger.getLogger("de.ibapl.spsw.jnhwprovider");
    private static final MultiarchTupelBuilder MULTIARCH_TUPEL_BUILDER = new MultiarchTupelBuilder();

    public SerialPortSocket open(String portName) throws IOException {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                return new PosixSerialPortSocket(portName);
            }
            case WINDOWS: {
                return new GenericWinSerialPortSocket(portName);
            }
        }
        throw new RuntimeException("Can't handle OS: " + MULTIARCH_TUPEL_BUILDER.getOS());
    }

    public SerialPortSocket open(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                return new PosixSerialPortSocket(portName, speed, dataBits, stopBits, parity, flowControls);
            }
            case WINDOWS: {
                return new GenericWinSerialPortSocket(portName, speed, dataBits, stopBits, parity, flowControls);
            }
        }
        throw new RuntimeException("Cant handle OS: " + MULTIARCH_TUPEL_BUILDER.getOS());
    }

    public AsyncSerialPortSocket openAsync(String portName, ExecutorService executor) throws IOException, IllegalStateException {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                return new PosixAsyncSerialPortSocket(portName, executor);
            }
        }
        throw new RuntimeException("Can't handle OS: " + MULTIARCH_TUPEL_BUILDER.getOS());
    }

    public AsyncSerialPortSocket openAsync(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls, ExecutorService executor) throws IOException {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                return new PosixAsyncSerialPortSocket(portName, speed, dataBits, stopBits, parity, flowControls, executor);
            }
        }
        throw new RuntimeException("Cant handle OS: " + MULTIARCH_TUPEL_BUILDER.getOS());
    }

    public void getPortNames(BiConsumer<String, Boolean> portNameConsumer) {
        Pattern pattern = this.getPortnamesRegExp();
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case WINDOWS: {
                List<String> portNames = this.getWindowsBasedPortNames();
                if (portNames == null) {
                    return;
                }
                for (String portName : portNames) {
                    if (!pattern.matcher(portName).find()) continue;
                    boolean busy = true;
                    try (SerialPortSocket sp = this.open(portName);){
                        busy = false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    portNameConsumer.accept(portName, busy);
                }
                break;
            }
        }
        File dir = new File(this.getPortnamesPath());
        dir.listFiles((parentDir, name) -> {
            if (pattern.matcher(name).find()) {
                File deviceFile = new File(parentDir, name);
                String deviceName = deviceFile.getAbsolutePath();
                if (!deviceFile.isDirectory() && !deviceFile.isFile()) {
                    boolean busy = true;
                    try (SerialPortSocket sp = this.open(deviceName);){
                        busy = false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    portNameConsumer.accept(deviceName, busy);
                }
            }
            return false;
        });
    }

    public List<String> getPortNames(boolean hideBusyPorts) {
        if (MULTIARCH_TUPEL_BUILDER.getOS() == OS.WINDOWS) {
            return this.getWindowsPortNames("", hideBusyPorts);
        }
        return this.getUnixBasedPortNames("", hideBusyPorts);
    }

    public List<String> getPortNames(String portToInclude, boolean hideBusyPorts) {
        if (portToInclude == null || portToInclude.isEmpty()) {
            throw new IllegalArgumentException("portToInclude is null or empty");
        }
        if (MULTIARCH_TUPEL_BUILDER.getOS() == OS.WINDOWS) {
            return this.getWindowsPortNames(portToInclude, hideBusyPorts);
        }
        return this.getUnixBasedPortNames(portToInclude, hideBusyPorts);
    }

    protected String getPortnamesPath() {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: {
                return "/dev/";
            }
            case FREE_BSD: {
                return "/dev/";
            }
            case OPEN_BSD: {
                return "/dev/";
            }
            case LINUX: {
                return "/dev/";
            }
            case SOLARIS: {
                return "/dev/term/";
            }
            case WINDOWS: {
                return "";
            }
        }
        LOG.log(Level.SEVERE, "Unknown OS, os.name: {0} mapped to: {1}", new Object[]{System.getProperty("os.name"), MULTIARCH_TUPEL_BUILDER.getOS()});
        return null;
    }

    protected Pattern getPortnamesRegExp() {
        switch (MULTIARCH_TUPEL_BUILDER.getOS()) {
            case DARWIN: {
                return Pattern.compile("tty.(serial|usbserial|usbmodem).*");
            }
            case FREE_BSD: {
                return Pattern.compile("(cua|cuaU)[0-9]{1,3}");
            }
            case OPEN_BSD: {
                return Pattern.compile("(cua|cuaU)[0-9]{1,3}");
            }
            case LINUX: {
                return Pattern.compile("(ttyS|ttyUSB|ttyACM|ttyAMA|rfcomm|ttyO)[0-9]{1,3}");
            }
            case SOLARIS: {
                return Pattern.compile("[0-9]*|[a-z]*");
            }
            case WINDOWS: {
                return Pattern.compile("(COM)[0-9]{1,3}");
            }
        }
        LOG.log(Level.SEVERE, "Unknown OS, os.name: {0} mapped to: {1}", new Object[]{System.getProperty("os.name"), MULTIARCH_TUPEL_BUILDER.getOS()});
        return null;
    }

    protected List<String> getUnixBasedPortNames(String portToInclude, boolean hideBusyPorts) {
        File dir = new File(this.getPortnamesPath());
        Pattern pattern = this.getPortnamesRegExp();
        LinkedList<String> result = new LinkedList<String>();
        dir.listFiles((parentDir, name) -> {
            block13: {
                if (pattern.matcher(name).find()) {
                    File deviceFile = new File(parentDir, name);
                    String deviceName = deviceFile.getAbsolutePath();
                    if (!deviceFile.isDirectory() && !deviceFile.isFile()) {
                        if (hideBusyPorts) {
                            try (SerialPortSocket sp = this.open(deviceName);){
                                result.add(deviceName);
                            }
                            catch (IOException ex) {
                                if (!portToInclude.isEmpty() && portToInclude.equals(deviceName)) {
                                    result.add(deviceName);
                                    break block13;
                                }
                                LOG.log(Level.FINEST, "found busy port: " + deviceName, ex);
                            }
                        } else {
                            result.add(deviceName);
                        }
                    }
                }
            }
            return false;
        });
        result.sort((Comparator<String>)new PortnamesComparator());
        return result;
    }

    protected List<String> getWindowsBasedPortNames() {
        return GenericWinSerialPortSocket.getWindowsBasedPortNames();
    }

    protected List<String> getWindowsPortNames(String portToInclude, boolean hideBusyPorts) {
        List<String> portNames = this.getWindowsBasedPortNames();
        if (portNames == null) {
            return Collections.emptyList();
        }
        Pattern pattern = this.getPortnamesRegExp();
        LinkedList<String> result = new LinkedList<String>();
        for (String portName : portNames) {
            if (!pattern.matcher(portName).find()) continue;
            if (hideBusyPorts) {
                try (SerialPortSocket sp = this.open(portName);){
                    result.add(portName);
                }
                catch (IOException ex) {
                    if (!portToInclude.isEmpty() && portToInclude.equals(portName)) {
                        result.add(portName);
                        continue;
                    }
                    LOG.log(Level.FINEST, "found busy port: " + portName, ex);
                }
                continue;
            }
            result.add(portName);
        }
        result.sort((Comparator<String>)new PortnamesComparator());
        return result;
    }
}

