/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jniprovider;

import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.SerialPortSocket;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.EnumSet;
import java.util.Set;

public abstract class AbstractSerialPortSocket<T extends AbstractSerialPortSocket<T>>
extends AbstractInterruptibleChannel
implements SerialPortSocket {
    static final int SPEED_0_BPS = 1;
    static final int SPEED_50_BPS = 2;
    static final int SPEED_75_BPS = 3;
    static final int SPEED_110_BPS = 4;
    static final int SPEED_134_BPS = 5;
    static final int SPEED_150_BPS = 6;
    static final int SPEED_200_BPS = 7;
    static final int SPEED_300_BPS = 8;
    static final int SPEED_600_BPS = 9;
    static final int SPEED_1200_BPS = 10;
    static final int SPEED_1800_BPS = 11;
    static final int SPEED_2400_BPS = 12;
    static final int SPEED_4800_BPS = 13;
    static final int SPEED_9600_BPS = 14;
    static final int SPEED_19200_BPS = 15;
    static final int SPEED_38400_BPS = 16;
    static final int SPEED_57600_BPS = 17;
    static final int SPEED_115200_BPS = 18;
    static final int SPEED_230400_BPS = 19;
    static final int SPEED_460800_BPS = 20;
    static final int SPEED_500000_BPS = 21;
    static final int SPEED_576000_BPS = 22;
    static final int SPEED_921600_BPS = 23;
    static final int SPEED_1000000_BPS = 24;
    static final int SPEED_1152000_BPS = 25;
    static final int SPEED_1500000_BPS = 26;
    static final int SPEED_2000000_BPS = 27;
    static final int SPEED_2500000_BPS = 28;
    static final int SPEED_3000000_BPS = 29;
    static final int SPEED_3500000_BPS = 30;
    static final int SPEED_4000000_BPS = 31;
    static final int SPEED_MASK = 255;
    static final int DATA_BITS_DB5 = 4096;
    static final int DATA_BITS_DB6 = 8192;
    static final int DATA_BITS_DB7 = 12288;
    static final int DATA_BITS_DB8 = 16384;
    static final int DATA_BITS_MASK = 61440;
    static final int FLOW_CONTROL_NONE = 65536;
    static final int FLOW_CONTROL_RTS_CTS_IN = 0x100000;
    static final int FLOW_CONTROL_RTS_CTS_OUT = 0x200000;
    static final int FLOW_CONTROL_XON_XOFF_IN = 0x400000;
    static final int FLOW_CONTROL_XON_XOFF_OUT = 0x800000;
    static final int FLOW_CONTROL_MASK = 0xFF0000;
    static final int STOP_BITS_1 = 0x1000000;
    static final int STOP_BITS_1_5 = 0x2000000;
    static final int STOP_BITS_2 = 0x3000000;
    static final int STOP_BITS_MASK = 0xF000000;
    static final int PARITY_NONE = 0x10000000;
    static final int PARITY_ODD = 0x20000000;
    static final int PARITY_EVEN = 0x30000000;
    static final int PARITY_MARK = 0x40000000;
    static final int PARITY_SPACE = 0x50000000;
    static final int PARITY_MASK = -268435456;
    static final int NO_PARAMS_TO_SET = 0;
    protected SerialInputStream is;
    protected SerialOutputStream os;
    private final String portName;
    private final Object readLock = new Object();
    private final Object writeLock = new Object();

    private native int read_ArgsOK(ByteBuffer var1, int var2, int var3) throws IOException;

    private native int readBytes(byte[] var1) throws IOException;

    private native int write_ArgsOK(ByteBuffer var1, int var2, int var3) throws IOException;

    private native void writeBytes(byte[] var1) throws IOException;

    private native int readBytes_ArgsOK(byte[] var1, int var2, int var3) throws IOException;

    private native int readSingle() throws IOException;

    private native void sendBreak0(int var1) throws IOException;

    private native void setBreak0(boolean var1) throws IOException;

    public native char getXOFFChar() throws IOException;

    public native char getXONChar() throws IOException;

    public native boolean isCTS() throws IOException;

    public native boolean isDSR() throws IOException;

    public native boolean isDCD() throws IOException;

    public native boolean isRI() throws IOException;

    protected native int getParameters(int var1) throws IOException;

    public native int getInBufferBytesCount() throws IOException;

    public native int getOutBufferBytesCount() throws IOException;

    public native void setDTR(boolean var1) throws IOException;

    protected native void setParameters(int var1) throws IOException;

    public native void setXOFFChar(char var1) throws IOException;

    public native void setXONChar(char var1) throws IOException;

    protected native void writeBytes_ParamsOK(byte[] var1, int var2, int var3) throws IOException;

    protected native void writeSingle(int var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer dst) throws IOException {
        if (dst.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        Object object = this.readLock;
        synchronized (object) {
            if (!dst.hasRemaining()) {
                return 0;
            }
            boolean completed = false;
            int result = 0;
            try {
                this.begin();
                result = this.read_ArgsOK(dst, dst.position(), dst.remaining());
                completed = true;
            }
            catch (IOException e) {
                completed = true;
                throw e;
            }
            finally {
                this.end(completed);
            }
            if (result > 0) {
                dst.position(dst.position() + result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer src) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            if (!src.hasRemaining()) {
                return 0;
            }
            boolean completed = false;
            int result = 0;
            try {
                this.begin();
                result = this.write_ArgsOK(src, src.position(), src.remaining());
                completed = true;
            }
            catch (IOException e) {
                completed = true;
                throw e;
            }
            finally {
                this.end(completed);
            }
            src.position(src.position() + result);
            return result;
        }
    }

    static Speed speedFromBitSet(int bitset) {
        switch (bitset & 0xFF) {
            case 1: {
                return Speed._0_BPS;
            }
            case 2: {
                return Speed._50_BPS;
            }
            case 3: {
                return Speed._75_BPS;
            }
            case 4: {
                return Speed._110_BPS;
            }
            case 5: {
                return Speed._134_BPS;
            }
            case 6: {
                return Speed._150_BPS;
            }
            case 7: {
                return Speed._200_BPS;
            }
            case 8: {
                return Speed._300_BPS;
            }
            case 9: {
                return Speed._600_BPS;
            }
            case 10: {
                return Speed._1200_BPS;
            }
            case 11: {
                return Speed._1800_BPS;
            }
            case 12: {
                return Speed._2400_BPS;
            }
            case 13: {
                return Speed._4800_BPS;
            }
            case 14: {
                return Speed._9600_BPS;
            }
            case 15: {
                return Speed._19200_BPS;
            }
            case 16: {
                return Speed._38400_BPS;
            }
            case 17: {
                return Speed._57600_BPS;
            }
            case 18: {
                return Speed._115200_BPS;
            }
            case 19: {
                return Speed._230400_BPS;
            }
            case 20: {
                return Speed._460800_BPS;
            }
            case 21: {
                return Speed._500000_BPS;
            }
            case 22: {
                return Speed._576000_BPS;
            }
            case 23: {
                return Speed._921600_BPS;
            }
            case 24: {
                return Speed._1000000_BPS;
            }
            case 25: {
                return Speed._1152000_BPS;
            }
            case 26: {
                return Speed._1500000_BPS;
            }
            case 27: {
                return Speed._2000000_BPS;
            }
            case 28: {
                return Speed._2500000_BPS;
            }
            case 29: {
                return Speed._3000000_BPS;
            }
            case 30: {
                return Speed._3500000_BPS;
            }
            case 31: {
                return Speed._4000000_BPS;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown speed in bitset: %8x", bitset));
    }

    static DataBits dataBitsFromBitSet(int bitset) {
        switch (bitset & 0xF000) {
            case 4096: {
                return DataBits.DB_5;
            }
            case 8192: {
                return DataBits.DB_6;
            }
            case 12288: {
                return DataBits.DB_7;
            }
            case 16384: {
                return DataBits.DB_8;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown dataBits in bitset: %8x", bitset));
    }

    static Set<FlowControl> flowControlFromBitSet(int bitset) {
        EnumSet<FlowControl> s = EnumSet.noneOf(FlowControl.class);
        if ((bitset & 0xFF0000) == 65536) {
            return s;
        }
        if ((bitset & 0x100000) == 0x100000) {
            s.add(FlowControl.RTS_CTS_IN);
        }
        if ((bitset & 0x200000) == 0x200000) {
            s.add(FlowControl.RTS_CTS_OUT);
        }
        if ((bitset & 0x400000) == 0x400000) {
            s.add(FlowControl.XON_XOFF_IN);
        }
        if ((bitset & 0x800000) == 0x800000) {
            s.add(FlowControl.XON_XOFF_OUT);
        }
        return s;
    }

    static Parity parityFromBitSet(int bitset) {
        switch (bitset & 0xF0000000) {
            case 0x10000000: {
                return Parity.NONE;
            }
            case 0x20000000: {
                return Parity.ODD;
            }
            case 0x30000000: {
                return Parity.EVEN;
            }
            case 0x40000000: {
                return Parity.MARK;
            }
            case 0x50000000: {
                return Parity.SPACE;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown stopBits in bitset: %8x", bitset));
    }

    static StopBits stopBitsFromBitSet(int bitset) {
        switch (bitset & 0xF000000) {
            case 0x1000000: {
                return StopBits.SB_1;
            }
            case 0x2000000: {
                return StopBits.SB_1_5;
            }
            case 0x3000000: {
                return StopBits.SB_2;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown stopBits in bitset: %8x", bitset));
    }

    static int toBitSet(Speed speed) {
        switch (speed) {
            case _0_BPS: {
                return 1;
            }
            case _50_BPS: {
                return 2;
            }
            case _75_BPS: {
                return 3;
            }
            case _110_BPS: {
                return 4;
            }
            case _134_BPS: {
                return 5;
            }
            case _150_BPS: {
                return 6;
            }
            case _200_BPS: {
                return 7;
            }
            case _300_BPS: {
                return 8;
            }
            case _600_BPS: {
                return 9;
            }
            case _1200_BPS: {
                return 10;
            }
            case _1800_BPS: {
                return 11;
            }
            case _2400_BPS: {
                return 12;
            }
            case _4800_BPS: {
                return 13;
            }
            case _9600_BPS: {
                return 14;
            }
            case _19200_BPS: {
                return 15;
            }
            case _38400_BPS: {
                return 16;
            }
            case _57600_BPS: {
                return 17;
            }
            case _115200_BPS: {
                return 18;
            }
            case _230400_BPS: {
                return 19;
            }
            case _460800_BPS: {
                return 20;
            }
            case _500000_BPS: {
                return 21;
            }
            case _576000_BPS: {
                return 22;
            }
            case _921600_BPS: {
                return 23;
            }
            case _1000000_BPS: {
                return 24;
            }
            case _1152000_BPS: {
                return 25;
            }
            case _1500000_BPS: {
                return 26;
            }
            case _2000000_BPS: {
                return 27;
            }
            case _2500000_BPS: {
                return 28;
            }
            case _3000000_BPS: {
                return 29;
            }
            case _3500000_BPS: {
                return 30;
            }
            case _4000000_BPS: {
                return 31;
            }
        }
        throw new IllegalArgumentException("Unknown speed: " + speed);
    }

    static int toBitSet(DataBits dataBits) {
        switch (dataBits) {
            case DB_5: {
                return 4096;
            }
            case DB_6: {
                return 8192;
            }
            case DB_7: {
                return 12288;
            }
            case DB_8: {
                return 16384;
            }
        }
        throw new IllegalArgumentException("Unknown dataBits: " + dataBits);
    }

    static int toBitSet(Parity parity) {
        switch (parity) {
            case EVEN: {
                return 0x30000000;
            }
            case MARK: {
                return 0x40000000;
            }
            case NONE: {
                return 0x10000000;
            }
            case ODD: {
                return 0x20000000;
            }
            case SPACE: {
                return 0x50000000;
            }
        }
        throw new IllegalArgumentException("Unknown parity: " + parity);
    }

    static int toBitSet(Set<FlowControl> flowControls) {
        if (flowControls.isEmpty()) {
            return 65536;
        }
        int bitSet = 0;
        block6: for (FlowControl fc : flowControls) {
            switch (fc) {
                case RTS_CTS_IN: {
                    bitSet |= 0x100000;
                    continue block6;
                }
                case RTS_CTS_OUT: {
                    bitSet |= 0x200000;
                    continue block6;
                }
                case XON_XOFF_IN: {
                    bitSet |= 0x400000;
                    continue block6;
                }
                case XON_XOFF_OUT: {
                    bitSet |= 0x800000;
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unknown flowcontrol:" + fc);
        }
        return bitSet;
    }

    static int toBitSet(StopBits stopBits) {
        switch (stopBits) {
            case SB_1: {
                return 0x1000000;
            }
            case SB_1_5: {
                return 0x2000000;
            }
            case SB_2: {
                return 0x3000000;
            }
        }
        throw new IllegalArgumentException("Unknown stopBits: " + stopBits);
    }

    public AbstractSerialPortSocket(String portName) {
        if (portName == null) {
            throw new IllegalArgumentException("portname must not null!");
        }
        this.portName = portName;
    }

    @Override
    protected void implCloseChannel() throws IOException {
        this.is = null;
        this.os = null;
    }

    public Speed getSpeed() throws IOException {
        return AbstractSerialPortSocket.speedFromBitSet(this.getParameters(255));
    }

    public DataBits getDatatBits() throws IOException {
        return AbstractSerialPortSocket.dataBitsFromBitSet(this.getParameters(61440));
    }

    public Set<FlowControl> getFlowControl() throws IOException {
        return AbstractSerialPortSocket.flowControlFromBitSet(this.getParameters(0xFF0000));
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.ensureOpen();
        if (this.is == null) {
            this.is = new SerialInputStream();
        }
        return this.is;
    }

    public synchronized OutputStream getOutputStream() throws IOException {
        this.ensureOpen();
        if (this.os == null) {
            this.os = new SerialOutputStream();
        }
        return this.os;
    }

    public Parity getParity() throws IOException {
        return AbstractSerialPortSocket.parityFromBitSet(this.getParameters(-268435456));
    }

    public String getPortName() {
        return this.portName;
    }

    public StopBits getStopBits() throws IOException {
        return AbstractSerialPortSocket.stopBitsFromBitSet(this.getParameters(0xF000000));
    }

    public void ensureOpen() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Port is closed");
        }
    }

    protected void open(Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        int bitset = AbstractSerialPortSocket.toBitSet(speed);
        bitset |= AbstractSerialPortSocket.toBitSet(dataBits);
        bitset |= AbstractSerialPortSocket.toBitSet(stopBits);
        bitset |= AbstractSerialPortSocket.toBitSet(parity);
        this.open(this.portName, bitset |= AbstractSerialPortSocket.toBitSet(flowControls));
    }

    protected abstract void open(String var1, int var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBreak(int duration) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            boolean completed = false;
            try {
                this.begin();
                this.sendBreak0(duration);
                completed = true;
            }
            catch (IOException e) {
                completed = true;
                throw e;
            }
            finally {
                this.end(completed);
            }
        }
    }

    public void setSpeed(Speed speed) throws IOException {
        try {
            this.setParameters(AbstractSerialPortSocket.toBitSet(speed));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can't set speed " + speed + " on port: " + this.getPortName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBreak(boolean value) throws IOException {
        Object object = this.writeLock;
        synchronized (object) {
            this.setBreak0(value);
        }
    }

    public void setDataBits(DataBits dataBits) throws IOException {
        try {
            this.setParameters(AbstractSerialPortSocket.toBitSet(dataBits));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can't set dataBits " + dataBits + " on port: " + this.getPortName() + " value is:" + this.getDatatBits(), ex);
        }
    }

    public void setFlowControl(Set<FlowControl> flowControls) throws IOException {
        this.setParameters(AbstractSerialPortSocket.toBitSet(flowControls));
    }

    public void setParity(Parity parity) throws IOException {
        this.setParameters(AbstractSerialPortSocket.toBitSet(parity));
    }

    public native void setRTS(boolean var1) throws IOException;

    public void setStopBits(StopBits stopBits) throws IOException {
        try {
            this.setParameters(AbstractSerialPortSocket.toBitSet(stopBits));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can't set stopBits " + stopBits + " on port: " + this.getPortName(), ex);
        }
    }

    public String toString() {
        try {
            return String.format("[portname=%s, speed= %s, dataBits= %s, stopBits= %s, parity= %s, flowControl= %s]", this.getPortName(), this.getSpeed(), this.getDatatBits(), this.getStopBits(), this.getParity(), this.getFlowControl());
        }
        catch (IOException e) {
            return "Internal Error " + e;
        }
    }

    protected class SerialOutputStream
    extends OutputStream {
        protected SerialOutputStream() {
        }

        @Override
        public void close() throws IOException {
            AbstractSerialPortSocket.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = AbstractSerialPortSocket.this.writeLock;
            synchronized (object) {
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    AbstractSerialPortSocket.this.drainOutputBuffer();
                    completed = true;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            Object object = AbstractSerialPortSocket.this.writeLock;
            synchronized (object) {
                if (b.length == 0) {
                    return;
                }
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    AbstractSerialPortSocket.this.writeBytes(b);
                    completed = true;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            Object object = AbstractSerialPortSocket.this.writeLock;
            synchronized (object) {
                if (len == 0) {
                    return;
                }
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    AbstractSerialPortSocket.this.writeBytes_ParamsOK(b, off, len);
                    completed = true;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            Object object = AbstractSerialPortSocket.this.writeLock;
            synchronized (object) {
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    AbstractSerialPortSocket.this.writeSingle(b);
                    completed = true;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }
    }

    protected class SerialInputStream
    extends InputStream {
        protected SerialInputStream() {
        }

        @Override
        public int available() throws IOException {
            return AbstractSerialPortSocket.this.getInBufferBytesCount();
        }

        @Override
        public void close() throws IOException {
            AbstractSerialPortSocket.this.close();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read() throws IOException {
            Object object = AbstractSerialPortSocket.this.readLock;
            synchronized (object) {
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    int result = AbstractSerialPortSocket.this.readSingle();
                    completed = true;
                    int n = result;
                    return n;
                }
                catch (AsynchronousCloseException ace) {
                    completed = true;
                    int n = -1;
                    return n;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            Object object = AbstractSerialPortSocket.this.readLock;
            synchronized (object) {
                if (b.length == 0) {
                    return 0;
                }
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    int result = AbstractSerialPortSocket.this.readBytes(b);
                    completed = true;
                    int n = result;
                    return n;
                }
                catch (AsynchronousCloseException ace) {
                    completed = true;
                    int n = -1;
                    return n;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0) throw new IndexOutOfBoundsException();
            if (len < 0) throw new IndexOutOfBoundsException();
            if (len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            Object object = AbstractSerialPortSocket.this.readLock;
            synchronized (object) {
                if (len == 0) {
                    return 0;
                }
                boolean completed = false;
                try {
                    AbstractSerialPortSocket.this.begin();
                    int result = AbstractSerialPortSocket.this.readBytes_ArgsOK(b, off, len);
                    completed = true;
                    int n = result;
                    return n;
                }
                catch (AsynchronousCloseException ace) {
                    completed = true;
                    int n = -1;
                    return n;
                }
                catch (IOException e) {
                    completed = true;
                    throw e;
                }
                finally {
                    AbstractSerialPortSocket.this.end(completed);
                }
            }
        }
    }
}

