/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jniprovider;

import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.InOutSpeedConfiguration;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.jniprovider.AbstractSerialPortSocket;
import java.io.IOException;
import java.lang.ref.Cleaner;
import java.util.Set;

public class GenericTermiosSerialPortSocket
extends AbstractSerialPortSocket<GenericTermiosSerialPortSocket>
implements InOutSpeedConfiguration {
    private static final int INVALID_FD = -1;
    public static final Cleaner CLEANER = Cleaner.create();
    private volatile int fd = -1;
    private volatile int closeEventReadFd = -1;
    private volatile int closeEventWriteFd = -1;
    private int interByteReadTimeout = 100;
    private int pollReadTimeout = -1;
    private int pollWriteTimeout = -1;
    private final FdCleaner fdCleaner = new FdCleaner();

    public GenericTermiosSerialPortSocket(String portName) throws IOException {
        super(portName);
        this.open(portName, 0);
    }

    public GenericTermiosSerialPortSocket(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException {
        super(portName);
        this.open(speed, dataBits, stopBits, parity, flowControls);
    }

    @Override
    protected final void open(String portName, int paramBitSet) throws IOException {
        this.open0(portName, paramBitSet);
        CLEANER.register(this, this.fdCleaner);
        this.fdCleaner.fd = this.fd;
        this.fdCleaner.close_event_read_fd = this.closeEventReadFd;
        this.fdCleaner.close_event_write_fd = this.closeEventWriteFd;
    }

    private native void open0(String var1, int var2) throws IOException;

    @Override
    protected void implCloseChannel() throws IOException {
        super.implCloseChannel();
        this.close0();
        this.fdCleaner.fd = -1;
    }

    private native void close0() throws IOException;

    public native void drainOutputBuffer() throws IOException;

    public int getInterByteReadTimeout() throws IOException {
        return this.interByteReadTimeout;
    }

    public int getOverallReadTimeout() throws IOException {
        return this.pollReadTimeout == -1 ? 0 : this.pollReadTimeout;
    }

    public int getOverallWriteTimeout() throws IOException {
        return this.pollWriteTimeout == -1 ? 0 : this.pollWriteTimeout;
    }

    private native int getInSpeed0() throws IOException;

    private native int getOutSpeed0() throws IOException;

    public Speed getInSpeed() throws IOException {
        return GenericTermiosSerialPortSocket.speedFromBitSet(this.getInSpeed0());
    }

    public Speed getOutSpeed() throws IOException {
        return GenericTermiosSerialPortSocket.speedFromBitSet(this.getOutSpeed0());
    }

    public native boolean isDTR() throws IOException;

    public native boolean isRTS() throws IOException;

    public native void sendXOFF() throws IOException;

    public native void sendXON() throws IOException;

    public void setTimeouts(int interByteReadTimeout, int overallReadTimeout, int overallWriteTimeout) throws IOException {
        if (overallWriteTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallWriteTimeout must >= 0");
        }
        if (overallReadTimeout < 0) {
            throw new IllegalArgumentException("setTimeouts: overallReadTimeout must >= 0");
        }
        if (interByteReadTimeout < 0) {
            throw new IllegalArgumentException("setReadTimeouts: interByteReadTimeout must >= 0");
        }
        this.interByteReadTimeout = interByteReadTimeout;
        this.pollReadTimeout = overallReadTimeout == 0 ? -1 : overallReadTimeout;
        this.pollWriteTimeout = overallWriteTimeout == 0 ? -1 : overallWriteTimeout;
    }

    protected native void setInSpeed0(int var1) throws IOException;

    protected native void setOutSpeed0(int var1) throws IOException;

    public void setInSpeed(Speed speed) throws IOException {
        try {
            this.setInSpeed0(GenericTermiosSerialPortSocket.toBitSet(speed));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can't set inSpeed " + speed + " on port: " + this.getPortName(), ex);
        }
    }

    public void setOutSpeed(Speed speed) throws IOException {
        try {
            this.setOutSpeed0(GenericTermiosSerialPortSocket.toBitSet(speed));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Can't set outSpeed " + speed + " on port: " + this.getPortName(), ex);
        }
    }

    static class FdCleaner
    implements Runnable {
        int fd = -1;
        int close_event_write_fd = -1;
        int close_event_read_fd = -1;

        FdCleaner() {
        }

        private static native void closeFds(int var0, int var1, int var2);

        @Override
        public void run() {
            FdCleaner.closeFds(this.fd, this.close_event_write_fd, this.close_event_read_fd);
        }
    }
}

