/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.spsw.jniprovider;

import de.ibapl.jnhw.libloader.LoadResult;
import de.ibapl.jnhw.libloader.NativeLibResolver;
import de.ibapl.jnhw.libloader.OS;
import de.ibapl.spsw.api.AsyncSerialPortSocket;
import de.ibapl.spsw.api.DataBits;
import de.ibapl.spsw.api.FlowControl;
import de.ibapl.spsw.api.Parity;
import de.ibapl.spsw.api.PortnamesComparator;
import de.ibapl.spsw.api.SerialPortSocket;
import de.ibapl.spsw.api.SerialPortSocketFactory;
import de.ibapl.spsw.api.Speed;
import de.ibapl.spsw.api.StopBits;
import de.ibapl.spsw.api.TimeoutIOException;
import de.ibapl.spsw.jniprovider.GenericTermiosSerialPortSocket;
import de.ibapl.spsw.jniprovider.GenericWinSerialPortSocket;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.ServiceScope;

@Component(name="de.ibapl.spsw.jniprovider", scope=ServiceScope.SINGLETON, immediate=true)
public class SerialPortSocketFactoryImpl
implements SerialPortSocketFactory {
    protected static final Logger LOG = Logger.getLogger("de.ibapl.spsw.jniprovider");
    private static final Class<TimeoutIOException> T_CLASS = TimeoutIOException.class;
    private static final String LIB_SPSW_NAME = "spsw";
    private static final int LIB_SPSW_VERSION = 3;
    private static LoadResult LIB_SPSW_LOAD_RESULT;

    protected static void doSystemLoad(String absoluteLibName) {
        System.load(absoluteLibName);
    }

    public static boolean touchNativeLib() {
        if (LIB_SPSW_LOAD_RESULT == null) {
            LIB_SPSW_LOAD_RESULT = NativeLibResolver.loadNativeLib((String)LIB_SPSW_NAME, (int)3, SerialPortSocketFactoryImpl::doSystemLoad);
        }
        if (LIB_SPSW_LOAD_RESULT.isLoaded()) {
            return true;
        }
        if (LIB_SPSW_LOAD_RESULT.isError()) {
            throw new RuntimeException(SerialPortSocketFactoryImpl.LIB_SPSW_LOAD_RESULT.loadError);
        }
        throw new RuntimeException("Should never happen: lib spsw not loaded for unknow reason.");
    }

    public static String getLibName() {
        return LIB_SPSW_NAME;
    }

    protected LinkedList<String> getWindowsBasedPortNames() {
        SerialPortSocketFactoryImpl.touchNativeLib();
        LinkedList<String> portNames = new LinkedList<String>();
        GenericWinSerialPortSocket.getWindowsBasedPortNames(portNames);
        return portNames;
    }

    public SerialPortSocket open(String portName) throws IOException {
        SerialPortSocketFactoryImpl.touchNativeLib();
        switch (NativeLibResolver.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case LINUX: 
            case OPEN_BSD: {
                return new GenericTermiosSerialPortSocket(portName);
            }
            case WINDOWS: {
                return new GenericWinSerialPortSocket(portName);
            }
        }
        throw new UnsupportedOperationException(NativeLibResolver.getOS() + " is currently not supported yet\nSystem.properties:\n");
    }

    protected String getPortnamesPath() {
        switch (NativeLibResolver.getOS()) {
            case DARWIN: {
                return "/dev/";
            }
            case FREE_BSD: {
                return "/dev/";
            }
            case LINUX: {
                return "/dev/";
            }
            case OPEN_BSD: {
                return "/dev/";
            }
            case SOLARIS: {
                return "/dev/term/";
            }
            case WINDOWS: {
                return "";
            }
        }
        LOG.log(Level.SEVERE, "Unknown OS, os.name: {0} mapped to: {1}", new Object[]{System.getProperty("os.name"), NativeLibResolver.getOS()});
        return null;
    }

    protected Pattern getPortnamesRegExp() {
        switch (NativeLibResolver.getOS()) {
            case DARWIN: {
                return Pattern.compile("tty.(serial|usbserial|usbmodem).*");
            }
            case FREE_BSD: {
                return Pattern.compile("(cua|cuaU)[0-9]{1,3}");
            }
            case LINUX: {
                return Pattern.compile("(ttyS|ttyUSB|ttyACM|ttyAMA|rfcomm|ttyO)[0-9]{1,3}");
            }
            case OPEN_BSD: {
                return Pattern.compile("(cua|cuaU)[0-9]{1,3}");
            }
            case SOLARIS: {
                return Pattern.compile("[0-9]*|[a-z]*");
            }
            case WINDOWS: {
                return Pattern.compile("(COM)[0-9]{1,3}");
            }
        }
        LOG.log(Level.SEVERE, "Unknown OS, os.name: {0} mapped to: {1}", new Object[]{System.getProperty("os.name"), NativeLibResolver.getOS()});
        return null;
    }

    public List<String> getPortNames(boolean hideBusyPorts) {
        if (OS.WINDOWS == NativeLibResolver.getOS()) {
            return this.getWindowsPortNames("", hideBusyPorts);
        }
        return this.getUnixBasedPortNames("", hideBusyPorts);
    }

    public List<String> getPortNames(String portToInclude, boolean hideBusyPorts) {
        if (portToInclude == null || portToInclude.isEmpty()) {
            throw new IllegalArgumentException("portToInclude is null or empty");
        }
        if (OS.WINDOWS == NativeLibResolver.getOS()) {
            return this.getWindowsPortNames(portToInclude, hideBusyPorts);
        }
        return this.getUnixBasedPortNames(portToInclude, hideBusyPorts);
    }

    protected List<String> getWindowsPortNames(String portToInclude, boolean hideBusyPorts) {
        LinkedList<String> result = this.getWindowsBasedPortNames();
        Pattern pattern = this.getPortnamesRegExp();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            String portName = (String)iter.next();
            if (!pattern.matcher(portName).find() || !hideBusyPorts) continue;
            try {
                SerialPortSocket sp = this.open(portName);
                if (sp == null) continue;
                sp.close();
            }
            catch (IOException ex) {
                if (portName.equals(portToInclude)) continue;
                iter.remove();
                LOG.log(Level.FINEST, "found busy port: " + portName, ex);
            }
        }
        result.sort((Comparator<String>)new PortnamesComparator());
        return result;
    }

    protected List<String> getUnixBasedPortNames(String portToInclude, boolean hideBusyPorts) {
        File dir = new File(this.getPortnamesPath());
        Pattern pattern = this.getPortnamesRegExp();
        LinkedList<String> result = new LinkedList<String>();
        dir.listFiles((parentDir, name) -> {
            block13: {
                if (pattern.matcher(name).find()) {
                    File deviceFile = new File(parentDir, name);
                    String deviceName = deviceFile.getAbsolutePath();
                    if (!deviceFile.isDirectory() && !deviceFile.isFile()) {
                        if (hideBusyPorts) {
                            try (SerialPortSocket sp = this.open(deviceName);){
                                result.add(deviceName);
                            }
                            catch (IOException ex) {
                                if (!portToInclude.isEmpty() && portToInclude.equals(deviceName)) {
                                    result.add(deviceName);
                                    break block13;
                                }
                                LOG.log(Level.FINEST, "found busy port: " + deviceName, ex);
                            }
                        } else {
                            result.add(deviceName);
                        }
                    }
                }
            }
            return false;
        });
        result.sort((Comparator<String>)new PortnamesComparator());
        return result;
    }

    @Activate
    public void activate() {
        SerialPortSocketFactoryImpl.touchNativeLib();
    }

    @Deactivate
    public void deActivate() {
    }

    public SerialPortSocket open(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls) throws IOException, IllegalStateException {
        SerialPortSocketFactoryImpl.touchNativeLib();
        switch (NativeLibResolver.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case LINUX: 
            case OPEN_BSD: {
                return new GenericTermiosSerialPortSocket(portName, speed, dataBits, stopBits, parity, flowControls);
            }
            case WINDOWS: {
                return new GenericWinSerialPortSocket(portName, speed, dataBits, stopBits, parity, flowControls);
            }
        }
        throw new UnsupportedOperationException(NativeLibResolver.getOS() + " is currently not supported yet\nSystem.properties:\n");
    }

    public void getPortNames(BiConsumer<String, Boolean> portNameConsumer) {
        Pattern pattern = this.getPortnamesRegExp();
        switch (NativeLibResolver.getOS()) {
            case WINDOWS: {
                LinkedList<String> portNames = this.getWindowsBasedPortNames();
                for (String portName : portNames) {
                    if (!pattern.matcher(portName).find()) continue;
                    boolean busy = true;
                    try (SerialPortSocket sp = this.open(portName);){
                        busy = false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    portNameConsumer.accept(portName, busy);
                }
                break;
            }
        }
        File dir = new File(this.getPortnamesPath());
        dir.listFiles((parentDir, name) -> {
            if (pattern.matcher(name).find()) {
                File deviceFile = new File(parentDir, name);
                String deviceName = deviceFile.getAbsolutePath();
                if (!deviceFile.isDirectory() && !deviceFile.isFile()) {
                    boolean busy = true;
                    try (SerialPortSocket sp = this.open(deviceName);){
                        busy = false;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    portNameConsumer.accept(deviceName, busy);
                }
            }
            return false;
        });
    }

    public AsyncSerialPortSocket openAsync(String portName, ExecutorService executor) throws IOException, IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AsyncSerialPortSocket openAsync(String portName, Speed speed, DataBits dataBits, StopBits stopBits, Parity parity, Set<FlowControl> flowControls, ExecutorService executor) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

