/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.SelectorUtils;

class CssAtRule
extends LessObject
implements Formattable {
    private final String css;
    private final boolean withPlaceHolder;

    public CssAtRule(LessObject reader, String css, boolean withPlaceHolder) {
        super(reader);
        this.css = css;
        this.withPlaceHolder = withPlaceHolder;
    }

    @Override
    public final int getType() {
        return 5;
    }

    @Override
    public void prepare(CssFormatter formatter) {
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        if (this.css.startsWith("@charset")) {
            if (formatter.isCharsetDirective()) {
                return;
            }
            formatter.setCharsetDirective();
            formatter = formatter.getHeader();
        } else if (this.css.startsWith("@import")) {
            formatter = formatter.getHeader();
        }
        formatter.getOutput();
        if (this.withPlaceHolder) {
            SelectorUtils.appendToWithPlaceHolder(formatter, this.css, 1, false, this);
        } else {
            formatter.append(this.css);
        }
        formatter.newline();
    }
}

