/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.CustomLessFunction;
import com.inet.lib.less.Expression;
import com.inet.lib.less.LessException;
import com.inet.lib.less.UrlUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;

class CustomFunctionColorizeImage
implements CustomLessFunction {
    CustomFunctionColorizeImage() {
    }

    @Override
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Caller of JLessC must check this")
    public void appendTo(CssFormatter formatter, List<Expression> parameters) throws IOException {
        if (parameters.size() < 4) {
            throw new LessException("error evaluating function colorize-image expects url, main_color, contrast_color ");
        }
        String relativeURL = parameters.get(0).stringValue(formatter);
        String urlString = parameters.get(1).stringValue(formatter);
        URL url = new URL(formatter.getBaseURL(), relativeURL);
        String urlStr = UrlUtils.removeQuote(urlString);
        url = new URL(url, urlStr);
        int mainColor = ColorUtils.argb(ColorUtils.getColor(parameters.get(2), formatter));
        int contrastColor = ColorUtils.argb(ColorUtils.getColor(parameters.get(3), formatter));
        BufferedImage loadedImage = ImageIO.read(url.openStream());
        int width = loadedImage.getWidth(null);
        int height = loadedImage.getHeight(null);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D bGr = image.createGraphics();
        bGr.drawImage((Image)loadedImage, 0, 0, null);
        bGr.dispose();
        float[] mainColorHsb = Color.RGBtoHSB(mainColor >> 16 & 0xFF, mainColor >> 8 & 0xFF, mainColor & 0xFF, null);
        float[] contrastColorHsb = Color.RGBtoHSB(contrastColor >> 16 & 0xFF, contrastColor >> 8 & 0xFF, contrastColor & 0xFF, null);
        WritableRaster raster = image.getRaster();
        DataBufferInt buffer = (DataBufferInt)raster.getDataBuffer();
        int[] data = buffer.getData();
        float[] hsb = new float[3];
        int hsbColor = 0;
        int lastRgb = data[0] + 1;
        for (int i = 0; i < data.length; ++i) {
            float[] hsbColorize;
            int rgb = data[i];
            if (rgb == lastRgb) {
                data[i] = hsbColor;
                continue;
            }
            int r = rgb >> 16 & 0xFF;
            int g = rgb >> 8 & 0xFF;
            int b = rgb & 0xFF;
            Color.RGBtoHSB(r, g, b, hsb);
            if (hsb[1] == 1.0f) {
                hsbColorize = hsb;
                hsb[0] = hsb[0] * 3.0f / 4.0f + mainColorHsb[0] / 4.0f;
                hsb[1] = hsb[1] * 3.0f / 4.0f + mainColorHsb[1] / 4.0f;
                hsb[2] = hsb[2] * 3.0f / 4.0f + mainColorHsb[2] / 4.0f;
            } else {
                hsbColorize = hsb[2] == 1.0f ? contrastColorHsb : mainColorHsb;
            }
            lastRgb = rgb;
            hsbColor = Color.HSBtoRGB(hsbColorize[0], hsbColorize[1], hsbColorize[2]);
            data[i] = hsbColor = rgb & 0xFF000000 | hsbColor & 0xFFFFFF;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", out);
        UrlUtils.dataUri(formatter, out.toByteArray(), urlString, "image/png;base64");
    }
}

