/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.json.BaseParser;
import com.inet.lib.json.ClassWrapper;
import com.inet.lib.json.JsonException;
import com.inet.lib.json.JsonTypeResolver;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Stack;

class JsonParser
extends BaseParser {
    private final Reader reader;
    private boolean usePrevious;
    private int previous;
    private final StringBuilder cachesBuilder = new StringBuilder();

    JsonParser(Reader reader, Map<Object, Map<String, String>> extraFields, JsonTypeResolver typeResolver) {
        super(extraFields, typeResolver);
        this.reader = reader;
    }

    Object[] parseValues(Type[] types) throws IOException, JsonException {
        Object[] result = new Object[types.length];
        int ch = this.readNonSpace();
        if (ch == 91) {
            block5: for (int i = 0; i < types.length; ++i) {
                result[i] = this.parseValue(types[i]);
                ch = this.readNonSpace();
                switch (ch) {
                    case 44: {
                        if (i < types.length - 1) continue block5;
                        throw new JsonException("Unexpected character: " + (char)ch);
                    }
                    case 93: {
                        if (i >= types.length - 1) continue block5;
                        throw new JsonException("Unexpected character: " + (char)ch);
                    }
                    case -1: {
                        throw new EOFException("Unexpected end of stream");
                    }
                    default: {
                        throw new JsonException("Unexpected character: " + (char)ch + " [" + ch + "]");
                    }
                }
            }
            return result;
        }
        if (ch == -1) {
            throw new EOFException("Unexpected end of stream, no data at all");
        }
        throw new JsonException("Unexpected character: " + (char)ch + " [" + ch + "]");
    }

    Object parseValue(Type type) throws IOException {
        int ch = this.readNonSpace();
        switch (ch) {
            case -1: {
                throw new EOFException("Unexpected end of JSON data");
            }
            case 34: 
            case 39: {
                return this.convertQuoteValue(this.readQuote((char)ch), type);
            }
            case 123: {
                return this.parseObject(type);
            }
            case 91: {
                return this.parseArray(type);
            }
        }
        this.back(ch);
        return this.convertNonquotedValue(this.readValue(), type);
    }

    Object parseObject(Type type) throws IOException {
        Object valueGenericType;
        Class<Object> keyGenericType;
        int objectType;
        Object obj;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type);
        if (wrapper.hasGetTypeFor()) {
            obj = new BaseParser.JsonObject(this, wrapper);
            objectType = 2;
            keyGenericType = String.class;
            valueGenericType = null;
        } else {
            obj = wrapper.create();
            if (obj instanceof Map) {
                objectType = 1;
                Type[] types = wrapper.getTypeArguments();
                if (types != null) {
                    keyGenericType = types[0];
                    valueGenericType = types[1];
                } else {
                    valueGenericType = Object.class;
                    keyGenericType = Object.class;
                }
            } else {
                objectType = 0;
                keyGenericType = String.class;
                valueGenericType = null;
            }
        }
        boolean isFirst = true;
        block11: while (true) {
            int ch = this.readNonSpace();
            switch (ch) {
                case -1: {
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 125: {
                    if (objectType == 2) {
                        return ((BaseParser.JsonObject)obj).create();
                    }
                    return obj;
                }
                case 44: {
                    if (!isFirst) {
                        isFirst = true;
                        continue block11;
                    }
                    throw new JsonException("Unexpected character: " + (char)ch);
                }
            }
            this.back(ch);
            Object key = this.parseValue((Type)((Object)keyGenericType));
            ch = this.readNonSpace();
            if (ch != 58) {
                throw new JsonException("Expected a character ':' after a key name.");
            }
            switch (objectType) {
                default: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        this.saveExtraField(obj, String.valueOf(key));
                        break;
                    }
                    Type fieldType = this.typeResolver.getGenericType(obj, field);
                    Object value = this.parseValue(fieldType);
                    try {
                        field.set(obj, value);
                    }
                    catch (IllegalAccessException ex) {
                        ex.printStackTrace(System.err);
                    }
                    break;
                }
                case 1: {
                    valueGenericType = this.typeResolver.getMapValueType(key, (Type)valueGenericType);
                    Object value = this.parseValue((Type)valueGenericType);
                    ((Map)obj).put(key, value);
                    break;
                }
                case 2: {
                    Field field = wrapper.findField(String.valueOf(key));
                    if (field == null) {
                        ((BaseParser.JsonObject)obj).extraFieldValues.put(String.valueOf(key), this.readJson());
                        break;
                    }
                    Type fieldType = field.getGenericType();
                    Object value = this.parseValue(fieldType);
                    ((BaseParser.JsonObject)obj).fieldValues.put(String.valueOf(key), value);
                }
            }
            isFirst = false;
        }
    }

    @Override
    Object parseExtraFieldValue() throws JsonException, IOException {
        return this.readJson();
    }

    private Object parseArray(Type type) throws IOException {
        Class elementType;
        Class<?> elementClass;
        Collection<Object> list;
        ClassWrapper wrapper = ClassWrapper.getWrapper(type);
        Class<?> clazz = wrapper.getClazz();
        Type[] types = wrapper.getTypeArguments();
        if (clazz.isArray()) {
            list = new ArrayList();
            elementClass = clazz.getComponentType();
            elementType = types != null ? types[0] : elementClass;
        } else {
            elementClass = null;
            elementType = types != null ? types[0] : Object.class;
            list = (Collection)ClassWrapper.getWrapper(type).create();
        }
        boolean isFirst = true;
        block5: while (true) {
            int ch = this.readNonSpace();
            switch (ch) {
                case -1: {
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 93: {
                    if (elementClass != null) {
                        int length = list.size();
                        Object result = Array.newInstance(elementClass, length);
                        int i = 0;
                        for (Object value : list) {
                            Array.set(result, i++, value);
                        }
                        return result;
                    }
                    return list;
                }
                case 44: {
                    if (!isFirst) {
                        isFirst = true;
                        continue block5;
                    }
                    throw new JsonException("Unexpected character: " + (char)ch);
                }
            }
            this.back(ch);
            list.add(this.parseValue(this.typeResolver.getCollectionValueType(list, (Type)((Object)elementType))));
            isFirst = false;
        }
    }

    private int readNonSpace() throws IOException {
        int ch;
        while ((ch = this.read()) <= 32 && ch >= 0) {
        }
        return ch;
    }

    private int read() throws IOException {
        if (this.usePrevious) {
            this.usePrevious = false;
            return this.previous;
        }
        return this.reader.read();
    }

    private void back(int ch) {
        this.previous = ch;
        this.usePrevious = true;
    }

    private String readQuote(char quote) throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        block13: while (true) {
            int ch = this.read();
            switch (ch) {
                case -1: 
                case 10: 
                case 13: {
                    throw new JsonException("Quotation mark not closed.");
                }
                case 92: {
                    ch = this.read();
                    switch (ch) {
                        case 98: {
                            builder.append('\b');
                            continue block13;
                        }
                        case 102: {
                            builder.append('\f');
                            continue block13;
                        }
                        case 110: {
                            builder.append('\n');
                            continue block13;
                        }
                        case 114: {
                            builder.append('\r');
                            continue block13;
                        }
                        case 116: {
                            builder.append('\t');
                            continue block13;
                        }
                        case 117: {
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < 4; ++i) {
                                sb.append((char)this.read());
                            }
                            builder.append((char)Integer.parseInt(sb.toString(), 16));
                            continue block13;
                        }
                        case 34: 
                        case 39: 
                        case 47: 
                        case 92: {
                            builder.append((char)ch);
                            continue block13;
                        }
                    }
                    throw new JsonException("Illegal escape character:" + (char)ch);
                }
            }
            if (ch == quote) {
                return this.pool(builder.toString());
            }
            builder.append((char)ch);
        }
    }

    private String readValue() throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        while (true) {
            int ch = this.read();
            switch (ch) {
                case 44: 
                case 93: 
                case 125: {
                    this.back(ch);
                }
                case -1: {
                    return builder.toString();
                }
            }
            builder.append((char)ch);
        }
    }

    private String readJson() throws IOException {
        StringBuilder builder = this.cachesBuilder;
        builder.setLength(0);
        Stack<Character> stack = new Stack<Character>();
        int end = -1;
        block8: while (true) {
            int ch = this.read();
            switch (ch) {
                case 123: {
                    stack.push(new Character((char)end));
                    end = 125;
                    builder.append((char)ch);
                    break;
                }
                case 91: {
                    stack.push(new Character((char)end));
                    end = 93;
                    builder.append((char)ch);
                    break;
                }
                case -1: {
                    if (stack.size() == 0) {
                        return builder.toString();
                    }
                    throw new EOFException("Unexpected end of JSON data");
                }
                case 44: {
                    if (stack.size() == 0) {
                        this.back(ch);
                        return builder.toString();
                    }
                    builder.append((char)ch);
                    break;
                }
                case 34: {
                    builder.append((char)ch);
                    boolean slash = false;
                    while (true) {
                        if ((ch = this.read()) == -1) continue block8;
                        builder.append((char)ch);
                        if (ch == 34 && !slash) continue block8;
                        slash = !slash && ch == 92;
                    }
                }
                case 93: 
                case 125: {
                    if (stack.size() == 0) {
                        this.back(ch);
                        return builder.toString();
                    }
                }
                default: {
                    if (ch == end) {
                        end = ((Character)stack.pop()).charValue();
                    }
                    builder.append((char)ch);
                }
            }
        }
    }

    private Object convertQuoteValue(String value, Type type) {
        return this.convertValue(value, type, true);
    }

    private Object convertNonquotedValue(String value, Type type) {
        if ((value = value.trim()).equalsIgnoreCase("null")) {
            return null;
        }
        return this.convertValue(value, type, false);
    }

    private Object convertValue(String value, Type type, boolean fallBackToString) {
        ClassWrapper wrapper = ClassWrapper.getWrapper(type);
        switch (wrapper.getJsonType()) {
            case 12: {
                return this.pool(Integer.valueOf(value));
            }
            case 13: {
                return this.pool(Long.valueOf(value));
            }
            case 15: {
                return this.pool(Double.valueOf(value));
            }
            case 14: {
                return this.pool(Float.valueOf(value));
            }
            case 11: {
                return this.pool(Short.valueOf(value));
            }
            case 10: {
                return this.pool(Byte.valueOf(value));
            }
            case 9: {
                return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("1");
            }
            case 8: {
                return new Date(Long.parseLong(value));
            }
        }
        return wrapper.valueOf(value, fallBackToString);
    }
}

