/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.json;

import com.inet.lib.io.UTF8StreamWriter;
import com.inet.lib.json.EncodedReader;
import com.inet.lib.json.EncodedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class LazyEncodedWriter
extends Writer {
    private Writer writer;
    private OutputStream out;
    private EncodedReader reader;

    public LazyEncodedWriter(EncodedReader reader, OutputStream out) {
        this.reader = reader;
        this.out = out;
    }

    private Writer getOut() {
        if (this.writer == null) {
            this.writer = this.reader.isOldDecoding() ? new UTF8StreamWriter(this.out) : new EncodedWriter(this.out);
        }
        return this.writer;
    }

    @Override
    public void write(int c) throws IOException {
        this.getOut().write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.getOut().write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.getOut().write(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.getOut().write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.getOut().write(str, off, len);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.getOut().append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.getOut().append(csq, start, end);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.getOut().append(c);
    }

    @Override
    public void flush() throws IOException {
        this.getOut().flush();
    }

    @Override
    public void close() throws IOException {
        this.getOut().close();
    }
}

