/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import com.inet.mdns.Message;
import com.inet.mdns.Question;
import com.inet.mdns.ServiceListener;
import com.inet.mdns.record.AAAARecord;
import com.inet.mdns.record.ARecord;
import com.inet.mdns.record.PtrRecord;
import com.inet.mdns.record.Record;
import com.inet.mdns.record.SrvRecord;
import com.inet.mdns.record.TxtRecord;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractMulticastDNS
implements AutoCloseable {
    private static final int PORT = 5353;
    private static final InetAddress GROUP4;
    private static final InetAddress GROUP6;
    private static final InetSocketAddress ADDRESS4;
    private static final InetSocketAddress ADDRESS6;
    private Selector selector;
    private List<DatagramChannel> channels = new ArrayList<DatagramChannel>();
    private Thread listeningThread;
    private boolean closing;
    private Inet4Address localIpv4Address;
    private Inet6Address localIp6vAddress;
    private ConcurrentHashMap<String, List<Record>> localServiceMap = new ConcurrentHashMap();
    private Map<String, Collection<ServiceListener>> serviceListenerMap = new HashMap<String, Collection<ServiceListener>>();
    private Map<String, String> pointerMap = new HashMap<String, String>();
    private String hostName = InetAddress.getLocalHost().getHostName();

    public AbstractMulticastDNS() throws IOException {
        this.selector = Selector.open();
        Enumeration<NetworkInterface> networks = NetworkInterface.getNetworkInterfaces();
        while (networks.hasMoreElements()) {
            NetworkInterface network = networks.nextElement();
            Enumeration<InetAddress> addresses = network.getInetAddresses();
            if (network.isLoopback() || !network.supportsMulticast() || network.isVirtual() || network.isVirtual() || !addresses.hasMoreElements()) continue;
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                try {
                    StandardProtocolFamily family;
                    InetAddress group;
                    if (address instanceof Inet4Address) {
                        group = GROUP4;
                        family = StandardProtocolFamily.INET;
                        if (this.localIpv4Address == null) {
                            this.localIpv4Address = (Inet4Address)address;
                        }
                    } else {
                        group = GROUP6;
                        family = StandardProtocolFamily.INET6;
                        if (this.localIp6vAddress == null) {
                            this.localIp6vAddress = (Inet6Address)address;
                        }
                    }
                    DatagramChannel channel = DatagramChannel.open(family);
                    channel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, Boolean.TRUE);
                    channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_IF, network);
                    channel.setOption((SocketOption)StandardSocketOptions.IP_MULTICAST_TTL, (Object)255);
                    channel.configureBlocking(false);
                    channel.join(group, network);
                    channel.bind(new InetSocketAddress(5353));
                    channel.register(this.selector, 1);
                    this.channels.add(channel);
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
        }
        this.listeningThread = new Thread("MulticastDNS listening"){

            @Override
            public void run() {
                AbstractMulticastDNS.this.runListening();
            }
        };
        this.listeningThread.setDaemon(true);
        this.listeningThread.start();
    }

    protected abstract void logError(Throwable var1);

    private void runListening() {
        block11: {
            try {
                byte[] buf = new byte[2048];
                ByteBuffer buffer = ByteBuffer.wrap(buf);
                ArrayList<Record> answers = new ArrayList<Record>();
                while (!this.closing) {
                    this.selector.select();
                    for (SelectionKey key : this.selector.selectedKeys()) {
                        buffer.clear();
                        ((DatagramChannel)key.channel()).receive(buffer);
                        Message receivedMsg = Message.fromByteArray(buf, buffer.position());
                        for (Question question : receivedMsg.getQuestions()) {
                            String serviceName = AbstractMulticastDNS.localName(question.getName().toLowerCase());
                            List<Record> records = this.localServiceMap.get(serviceName);
                            if (records == null) continue;
                            for (Record record : records) {
                                answers.add(record);
                            }
                        }
                        ArrayList<Record> allRecords = new ArrayList<Record>();
                        allRecords.addAll(receivedMsg.getAnswers());
                        allRecords.addAll(receivedMsg.getAuthoritativeAnswers());
                        for (Record record : allRecords) {
                            if (!(record instanceof PtrRecord)) continue;
                            this.pointerMap.put(((PtrRecord)record).getServiceName(), AbstractMulticastDNS.localName(record.getName()));
                        }
                        for (Record record : allRecords) {
                            Collection<ServiceListener> listeners;
                            String serviceName;
                            if (!(record instanceof SrvRecord) && !(record instanceof TxtRecord) || (serviceName = this.pointerMap.get(record.getName())) == null || (listeners = this.serviceListenerMap.get(serviceName)) == null) continue;
                            if (record instanceof SrvRecord) {
                                SrvRecord srvRecord = (SrvRecord)record;
                                for (ServiceListener listener : listeners) {
                                    listener.onServiceReceived(srvRecord.getName(), srvRecord.getTarget(), srvRecord.getPort());
                                }
                                continue;
                            }
                            TxtRecord txtRecord = (TxtRecord)record;
                            for (ServiceListener listener : listeners) {
                                listener.onTextReceived(txtRecord.getName(), txtRecord.getText());
                            }
                        }
                        if (answers.size() <= 0) continue;
                        Message message = new Message();
                        message.setFlags(33792);
                        message.addAnswers(answers);
                        this.send(message);
                        answers.clear();
                    }
                }
            }
            catch (Throwable e) {
                if (this.closing) break block11;
                this.logError(e);
            }
        }
    }

    private static String removeTrailing(String str, String textToRemove) {
        if (str.endsWith(textToRemove)) {
            return str.substring(0, str.length() - textToRemove.length());
        }
        return str;
    }

    private void send(Message msg) throws IOException {
        byte[] buf = msg.toByteArray();
        for (DatagramChannel channel : this.channels) {
            InetAddress local = ((InetSocketAddress)channel.getLocalAddress()).getAddress();
            InetSocketAddress address = local instanceof Inet4Address ? ADDRESS4 : ADDRESS6;
            try {
                channel.send(ByteBuffer.wrap(buf), address);
            }
            catch (IOException e) {
                this.logError(e);
            }
        }
    }

    public void publishService(String type, String name, int port, String txt) throws IOException {
        String fullType = AbstractMulticastDNS.globalName(type);
        name = AbstractMulticastDNS.globalName(name);
        ArrayList<Record> records = new ArrayList<Record>();
        records.add(new PtrRecord(fullType, name));
        records.add(new PtrRecord("_services._dns-sd._udp", fullType));
        records.add(new SrvRecord(name, 0, 0, port, this.hostName));
        records.add(new TxtRecord(name, txt));
        if (this.localIpv4Address != null) {
            records.add(new ARecord(this.hostName, this.localIpv4Address));
        }
        if (this.localIp6vAddress != null) {
            records.add(new AAAARecord(this.hostName, this.localIp6vAddress));
        }
        this.localServiceMap.put(type, records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryService(String serviceName, ServiceListener listener) throws IOException {
        Message msg = new Message();
        msg.getQuestions().add(new Question(AbstractMulticastDNS.globalName(serviceName), 255, 1));
        Map<String, Collection<ServiceListener>> map = this.serviceListenerMap;
        synchronized (map) {
            Collection<ServiceListener> listeners = this.serviceListenerMap.get(serviceName);
            if (listeners == null) {
                listeners = new LinkedList<ServiceListener>();
                this.serviceListenerMap.put(serviceName, listeners);
            }
            listeners.add(listener);
        }
        this.send(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceListener(String serviceName, ServiceListener listener) {
        Map<String, Collection<ServiceListener>> map = this.serviceListenerMap;
        synchronized (map) {
            Collection<ServiceListener> listeners = this.serviceListenerMap.get(serviceName);
            listeners.remove(listener);
        }
    }

    private static String globalName(String name) {
        if (!name.endsWith(".")) {
            name = name + ".";
        }
        if (!name.endsWith(".local.")) {
            name = name + "local.";
        }
        return name;
    }

    private static String localName(String name) {
        return AbstractMulticastDNS.removeTrailing(AbstractMulticastDNS.removeTrailing(name, "."), ".local");
    }

    @Override
    public void close() {
        this.closing = true;
        try {
            this.selector.close();
            for (DatagramChannel channel : this.channels) {
                channel.close();
            }
        }
        catch (IOException ex) {
            this.logError(ex);
        }
    }

    static {
        InetAddress temp4 = null;
        InetAddress temp6 = null;
        try {
            temp4 = InetAddress.getByName("224.0.0.251");
            temp6 = InetAddress.getByName("FF02::FB");
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
        }
        GROUP4 = temp4;
        GROUP6 = temp6;
        ADDRESS4 = new InetSocketAddress(GROUP4, 5353);
        ADDRESS6 = new InetSocketAddress(GROUP6, 5353);
    }
}

