/*
 * Decompiled with CFR 0.152.
 */
package com.inet.mdns;

import java.io.ByteArrayOutputStream;

public class MDNSOutputStream
extends ByteArrayOutputStream {
    public void writeShort(int value) {
        this.write(value >> 8);
        this.write(value);
    }

    public void writeInt(int value) {
        this.writeShort(value >> 16);
        this.writeShort(value);
    }

    public void writeLengthAndUTF(String str, int off, int len) {
        char ch;
        int i;
        int utflen = 0;
        for (i = 0; i < len; ++i) {
            ch = str.charAt(off + i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                ++utflen;
                continue;
            }
            if (ch > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        this.write(utflen);
        for (i = 0; i < len; ++i) {
            ch = str.charAt(off + i);
            if (ch >= '\u0001' && ch <= '\u007f') {
                this.write(ch);
                continue;
            }
            if (ch > '\u07ff') {
                this.write(0xE0 | ch >> 12 & 0xF);
                this.write(0x80 | ch >> 6 & 0x3F);
                this.write(0x80 | ch >> 0 & 0x3F);
                continue;
            }
            this.write(0xC0 | ch >> 6 & 0x1F);
            this.write(0x80 | ch >> 0 & 0x3F);
        }
    }

    public void writeName(String name) {
        String aName = name;
        while (true) {
            int n;
            if ((n = aName.indexOf(46)) < 0) {
                n = aName.length();
            }
            if (n <= 0) {
                this.write(0);
                return;
            }
            String label = aName.substring(0, n);
            this.writeLengthAndUTF(label, 0, label.length());
            if (!(aName = aName.substring(n)).startsWith(".")) continue;
            aName = aName.substring(1);
        }
    }
}

