/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.generator.model;

import com.inet.annotations.InternalApi;
import com.inet.annotations.JsonData;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.PagedElement;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

@JsonData
@InternalApi
public class MinifiedElement
implements PagedElement,
Serializable {
    private int pageIndex;
    private Rectangle2D.Float bounds;
    private ElementType type;
    private String label;

    private MinifiedElement() {
    }

    private MinifiedElement(PagedElement diff) {
        this.type = diff.getType();
        this.label = diff.getLabel();
        this.bounds = MinifiedElement.getBoundsFloat(diff.getBounds());
        this.pageIndex = diff.getPageIndex();
    }

    public static MinifiedElement minify(PagedElement e) {
        if (e == null) {
            return null;
        }
        if (e instanceof MinifiedElement) {
            return (MinifiedElement)e;
        }
        return new MinifiedElement(e);
    }

    public static Rectangle2D.Float getBoundsFloat(Rectangle2D rect) {
        if (rect instanceof Rectangle2D.Float) {
            return (Rectangle2D.Float)rect;
        }
        return new Rectangle2D.Float((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight());
    }

    @Override
    public int getPageIndex() {
        return this.pageIndex;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }

    @Override
    public ElementType getType() {
        return this.type;
    }

    public String toString() {
        return "Minified " + this.label;
    }
}

