/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.AnnotationElement;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ImageElement;
import com.inet.pdfc.model.PaintComparator;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import com.inet.pdfc.model.controls.ControlCheckBox;
import com.inet.pdfc.model.controls.ControlElement;
import com.inet.pdfc.model.controls.ControlList;
import com.inet.pdfc.model.controls.ControlText;
import java.awt.BasicStroke;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Line2D;
import java.awt.geom.QuadCurve2D;
import java.util.List;

@InternalApi
public class ElementComparator {
    public static final ElementComparator NOLOG_COMPARATOR = new ElementComparator(null);
    static final double ACCURACY = 0.8;
    private ResultPrinter logger;
    private static final char[][] REPLACEMENTS = new char[][]{{'\u00a0', ' '}, {'\u00b4', ' '}, {'\u2010', '-'}, {'\u2022', ' '}, {'\u2212', ' '}, {'\u00d7', ' '}, {'\u2019', '\''}, {',', ';'}, {'\ufb01', ' '}, {'\ufb02', ' '}, {'\u201c', '\u0093'}, {'\u201d', '\u0094'}, {'\u2013', '\u0096'}, {'\u2014', '\u0091'}, {'\u2018', '\u0091'}, {'\'', '\u0092'}, {'\u0091', '\u0097'}, {'\u03b5', '\"'}, {'\u02c6', '^'}, {'\u2192', '!'}, {'\u0097', '`'}, {'\u00b5', '\u03bc'}, {'|', 'j'}};

    public ElementComparator(ResultPrinter logger) {
        this.logger = logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSame(DrawableElement e0, DrawableElement e1) {
        Class<?> c2;
        if (e0 == null || e1 == null) {
            if (e0 != e1) return false;
            return true;
        }
        Class<?> c1 = e0.getClass();
        if (c1 != (c2 = e1.getClass()) && !c1.isAssignableFrom(c2) && !c2.isAssignableFrom(c1)) {
            if (this.logger == null) return false;
            this.logger.print("Different type of compared elements: " + c1 + " <-> " + c2);
            return false;
        }
        boolean res = true;
        if (res && Math.abs(e0.getX() - e1.getX()) > 0.8) {
            if (this.logger == null) return false;
            this.logger.print("Different X-Positions: " + e0.getX() + " and " + e1.getX());
            res = false;
        }
        if (res && Math.abs(e0.getY() - e1.getY()) > 0.8) {
            if (this.logger == null) return false;
            this.logger.print("Different Y-Positions: " + e0.getY() + " and " + e1.getY());
            return false;
        }
        if (e0 instanceof AnnotationElement) {
            AnnotationElement current = (AnnotationElement)e0;
            AnnotationElement other = (AnnotationElement)e1;
            String s1 = current.getSubtype();
            String s2 = other.getSubtype();
            if (s1 == null) {
                if (s2 != null) return false;
                return true;
            }
            boolean bl = s1.equals(s2);
            return bl;
        }
        if (e0 instanceof ImageElement) {
            ImageElement i0 = (ImageElement)e0;
            ImageElement i1 = (ImageElement)e1;
            if (Math.abs(i0.getWidth() - i1.getWidth()) > 0.8) {
                if (this.logger == null) return false;
                this.logger.print("Different Widths: " + i0.getWidth() + " and " + i1.getWidth());
                res = false;
            }
            if (!(Math.abs(i0.getHeight() - i1.getHeight()) > 0.8)) return res;
            if (this.logger == null) return false;
            this.logger.print("Different Heights: " + i0.getHeight() + " and " + i1.getHeight());
            return false;
        }
        if (e0 instanceof ShapeElement) {
            if (!this.compareShape((ShapeElement)e0, (ShapeElement)e1)) return false;
            if (!res) return false;
            return true;
        }
        if (e0 instanceof TextElement) {
            if (!this.compareText((TextElement)e0, (TextElement)e1)) return false;
            if (!res) return false;
            return true;
        }
        if (!(e0 instanceof ControlElement)) return res;
        if (!this.compareControl((ControlElement)e0, (ControlElement)e1)) return false;
        if (!res) return false;
        return true;
    }

    private boolean compareControl(ControlElement c0, ControlElement c1) {
        if (c0.getFieldName() != null && !c0.getFieldName().equalsIgnoreCase(c1.getFieldName())) {
            return false;
        }
        if (c0 instanceof ControlCheckBox) {
            ControlCheckBox cb0 = (ControlCheckBox)c0;
            ControlCheckBox cb1 = (ControlCheckBox)c1;
            if (cb0.isChecked() != cb1.isChecked()) {
                return false;
            }
        }
        if (c0 instanceof ControlList) {
            ControlList l0 = (ControlList)c0;
            ControlList l1 = (ControlList)c1;
            String selectedEntry = l0.getFieldValue();
            String selectedEntryInOtherControl = l1.getFieldValue();
            if (selectedEntry != null) {
                if (selectedEntryInOtherControl == null) {
                    return false;
                }
                if (selectedEntry.equals(selectedEntryInOtherControl)) {
                    return false;
                }
            } else if (selectedEntryInOtherControl != null) {
                return false;
            }
        }
        if (c0 instanceof ControlText) {
            ControlText t0 = (ControlText)c0;
            ControlText t1 = (ControlText)c1;
            String str = t0.getFieldValue();
            String otherStr = t1.getFieldValue();
            if (str == null) {
                return otherStr == null;
            }
            return str.equals(otherStr);
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareShape(ShapeElement s0, ShapeElement s1) {
        boolean res = true;
        List<Shape> elemSegments = s1.getShapeSegments();
        List<Shape> ownSegments = s0.getShapeSegments();
        if (ownSegments == null) {
            return elemSegments == null || elemSegments.size() == 0;
        }
        if (elemSegments == null) {
            return false;
        }
        Paint thisStrokePaint = s0.getStrokePaint();
        Paint thisFillPaint = s0.getFillPaint();
        BasicStroke thisBasicStroke = s0.getStrokePaint() != null ? s0.getStroke() : null;
        Paint elemStrokePaint = s1.getStrokePaint();
        Paint elemFillPaint = s1.getFillPaint();
        BasicStroke elemBasicStroke = s1.getStrokePaint() != null ? s1.getStroke() : null;
        PaintComparator comp = new PaintComparator(0.01);
        if (!comp.isEqual(thisStrokePaint, elemStrokePaint)) {
            if (this.logger == null) return false;
            this.logger.print("difference in shape stroke paint");
            res = false;
        }
        if (thisBasicStroke == null && elemBasicStroke != null || thisBasicStroke != null && !thisBasicStroke.equals(elemBasicStroke)) {
            if (this.logger == null) return false;
            this.logger.print("difference in shape basic stroke");
            res = false;
        }
        if (elemFillPaint == null || thisFillPaint == null || !elemFillPaint.equals(thisFillPaint) && !thisFillPaint.equals(elemFillPaint)) {
            if (!comp.canCompare(elemFillPaint)) {
                elemFillPaint = null;
            }
            if (!comp.canCompare(thisFillPaint)) {
                thisFillPaint = null;
            }
            if (!comp.isEqual(thisFillPaint, elemFillPaint)) {
                if (this.logger == null) return false;
                this.logger.print("difference in shape fill paint: REF=" + elemFillPaint + " CUR=" + thisFillPaint);
                res = false;
            }
        }
        int oldSeg = 0;
        int newSeg = 0;
        while (oldSeg < elemSegments.size() && newSeg < ownSegments.size()) {
            Shape elemCurve;
            Shape thisCurve;
            Shape thisShape = ownSegments.get(newSeg);
            Shape elemShape = elemSegments.get(oldSeg);
            if (thisShape.getBounds2D().getWidth() == 0.0 && thisShape.getBounds2D().getHeight() == 0.0) {
                ++newSeg;
                continue;
            }
            if (elemShape.getBounds2D().getWidth() == 0.0 && elemShape.getBounds2D().getHeight() == 0.0) {
                ++oldSeg;
                continue;
            }
            if (!thisShape.getClass().equals(elemShape.getClass())) {
                if (this.logger == null) return false;
                this.logger.print("different element types[" + oldSeg + "/" + newSeg + "] in shape: " + thisShape.getClass() + " and " + elemShape.getClass());
                return false;
            }
            if (thisShape instanceof Line2D) {
                Line2D.Float thisLine = (Line2D.Float)thisShape;
                Line2D.Float elemLine = (Line2D.Float)elemShape;
                if (!ElementComparator.isLinesEqual(thisLine, elemLine)) {
                    if (this.logger == null) return false;
                    this.logger.print("different Line2D elements");
                    res = false;
                }
            } else if (thisShape instanceof CubicCurve2D) {
                thisCurve = (CubicCurve2D.Float)thisShape;
                elemCurve = (CubicCurve2D.Float)elemShape;
                if (!ElementComparator.isCubicCurvesEqual(thisCurve, elemCurve)) {
                    if (this.logger == null) return false;
                    this.logger.print("different in CubicCurve2D elements");
                    res = false;
                }
            } else if (thisShape instanceof QuadCurve2D && !ElementComparator.isQuadCurvesEqual((QuadCurve2D.Float)(thisCurve = (QuadCurve2D.Float)thisShape), (QuadCurve2D.Float)(elemCurve = (QuadCurve2D.Float)elemShape))) {
                if (this.logger == null) return false;
                this.logger.print("different in QuadCurve2D elements");
                res = false;
            }
            ++oldSeg;
            ++newSeg;
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareText(TextElement cur, TextElement ref) {
        PaintComparator comp;
        String refTextCompare;
        boolean res = true;
        double[] cM = cur.getTransformMatrix();
        double[] rM = ref.getTransformMatrix();
        double curX = cM[4];
        double refX = rM[4];
        if (res && Math.abs(curX - refX) > 0.8) {
            if (this.logger == null) return false;
            this.logger.print("Different X-Positions: " + curX + " and " + refX);
            res = false;
        }
        double curY = cM[5];
        double refY = rM[5];
        if (res && Math.abs(curY - refY) > 0.8) {
            if (this.logger == null) return false;
            this.logger.print("Different Y-Positions: " + curY + " and " + refY);
            res = false;
        }
        double curHeight = cur.getTextHeight();
        double refHeight = ref.getTextHeight();
        if (res && Math.abs(curHeight - refHeight) > 100000.0) {
            if (cur.getFontSize() != ref.getFontSize()) {
                refHeight *= (double)cur.getFontSize();
                if (Math.abs((curHeight *= (double)ref.getFontSize()) - refHeight) > 1.3) {
                    if (this.logger == null) return false;
                    this.logger.print("Different text height: " + curHeight + " and " + refHeight);
                    this.logger.print("Fonts are " + cur.getFontInfo().getFontName() + " and " + ref.getFontInfo().getFontName());
                    res = false;
                }
            } else {
                if (this.logger == null) return false;
                this.logger.print("Different text height: " + curHeight + " and " + refHeight);
                this.logger.print("Fonts are " + cur.getFontInfo().getFontName() + " and " + ref.getFontInfo().getFontName());
                res = false;
            }
        }
        double curWidth = cur.getTextWidth();
        double refWidth = ref.getTextWidth();
        double[] curCW = cur.getCharacterWidths();
        if (res && Math.abs(curWidth - refWidth) > 0.8 && cur.getKerningArray() != null) {
            double[] refCW = ref.getCharacterWidths();
            double k0 = curCW.length > 0 ? curCW[curCW.length - 1] : 0.0;
            double k1 = refCW.length > 0 ? refCW[refCW.length - 1] : 0.0;
            curWidth -= k0 - k1;
            refWidth -= curCW.length > 0 && refCW.length > 0 ? refCW[0] - curCW[0] : 0.0;
        }
        if (res && Math.abs(curWidth - refWidth) > 0.8 && (curCW.length == 0 || refWidth < curWidth - curCW[curCW.length - 1] || refWidth > curWidth)) {
            if (this.logger == null) return false;
            this.logger.print("Different text width: " + curWidth + " and " + refWidth);
            res = false;
        }
        String thisText = cur.getText();
        String refText = ref.getText();
        String thisTextCompare = this.applyReplacements(thisText);
        if (!thisTextCompare.equals((refTextCompare = this.applyReplacements(refText)).replace('\u00a0', ' '))) {
            if (this.logger == null) return false;
            this.logger.print("texts differ: '" + ElementComparator.toHex(thisText) + "' and '" + ElementComparator.toHex(refText) + "'" + cur.getFontInfo().getFontName());
            res = false;
        }
        if (!cur.getFontInfo().getFamilyName().equals(ref.getFontInfo().getFamilyName())) {
            if (this.logger == null) return false;
            res = false;
            this.logger.print("fonts differ: '" + cur.getFontInfo().getFamilyName() + "' and '" + ref.getFontInfo().getFamilyName() + "'");
        }
        if (cur.getFontSize() != ref.getFontSize()) {
            double scale = Math.sqrt(cM[0] * cM[0] + cM[1] * cM[1]);
            if (Math.abs((double)cur.getFontSize() * scale - (double)ref.getFontSize()) > 0.8 && Math.abs((double)cur.getFontSize() - (double)ref.getFontSize() * scale) > 0.8) {
                if (this.logger == null) return false;
                res = false;
                this.logger.print("font sizes differ: '" + cur.getFontSize() + "' and '" + ref.getFontSize() + "'");
            }
        }
        if (!(comp = new PaintComparator(0.01)).isEqual(cur.getFillPaint(), ref.getFillPaint())) {
            res = false;
            if (this.logger == null) return false;
            this.logger.print("fill paint values differ: '" + cur.getFillPaint() + "' and '" + ref.getFillPaint() + "'");
        }
        if (comp.isEqual(cur.getStrokePaint(), ref.getStrokePaint())) return res;
        if (this.logger == null) return false;
        res = false;
        this.logger.print("stroke paint values differ: '" + cur.getStrokePaint() + "' and '" + ref.getStrokePaint() + "'");
        return res;
    }

    private String applyReplacements(String s) {
        for (char[] pair : REPLACEMENTS) {
            s = s.replace(pair[0], pair[1]);
        }
        return s;
    }

    public static boolean isQuadCurvesEqual(QuadCurve2D.Float curve1, QuadCurve2D.Float curve2) {
        if ((double)Math.abs(curve1.x1 - curve2.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.y1 - curve2.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx - curve2.ctrlx) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly - curve2.ctrly) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.x2 - curve2.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(curve1.y2 - curve2.y2) > 0.8);
    }

    public static boolean isLinesEqual(Line2D.Float firstLine, Line2D.Float secondLine) {
        if ((double)Math.abs(firstLine.x1 - secondLine.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(firstLine.y1 - secondLine.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(firstLine.x2 - secondLine.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(firstLine.y2 - secondLine.y2) > 0.8);
    }

    public static boolean isCubicCurvesEqual(CubicCurve2D.Float curve1, CubicCurve2D.Float curve2) {
        if ((double)Math.abs(curve1.x1 - curve2.x1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.y1 - curve2.y1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx1 - curve2.ctrlx1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly1 - curve2.ctrly1) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrlx2 - curve2.ctrlx2) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.ctrly2 - curve2.ctrly2) > 0.8) {
            return false;
        }
        if ((double)Math.abs(curve1.x2 - curve2.x2) > 0.8) {
            return false;
        }
        return !((double)Math.abs(curve1.y2 - curve2.y2) > 0.8);
    }

    private static String toHex(String text) {
        StringBuilder sb = new StringBuilder();
        sb.append('<');
        for (int i = 0; i < text.length(); ++i) {
            sb.append(String.format("%02x", text.charAt(i)));
        }
        sb.append('>');
        return sb.toString();
    }

    @FunctionalInterface
    @InternalApi
    public static interface ResultPrinter {
        public void print(String var1);
    }
}

