/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.remote.client.impl;

import com.inet.pdfc.generator.message.PageData;
import com.inet.pdfc.generator.rendercache.PageImageCache;
import com.inet.pdfc.remote.client.RPCClient;
import com.inet.pdfc.rpc.model.PageKey;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;

public class RPCImageStore
implements PageImageCache {
    private Path root;
    private Map<PageKey, PageData> pageData = new HashMap<PageKey, PageData>();

    public RPCImageStore() {
        try {
            this.root = Files.createTempDirectory("PDFCRPC", new FileAttribute[0]);
        }
        catch (IOException e) {
            try {
                this.root = Files.createDirectory(new File("PDFCRPC" + UUID.randomUUID()).toPath(), new FileAttribute[0]);
                RPCClient.getLogger().warn("Unable to use a temp folder, using local folder " + this.root + " instead.");
            }
            catch (IOException e1) {
                RPCClient.getLogger().error(e);
            }
        }
    }

    @Override
    public void clear() {
        try {
            Files.list(this.root).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (Exception e) {
                    RPCClient.getLogger().error(e);
                }
            });
            Files.delete(this.root);
        }
        catch (IOException e) {
            RPCClient.getLogger().error(e);
        }
    }

    public void storePageData(@Nonnull PageData data) {
        boolean first = data.isFirst();
        PageKey key = new PageKey(data.getPageIndex(), first);
        this.pageData.put(key, data);
    }

    public void storeImage(@Nonnull String key, @Nonnull ByteBuffer data) {
        Path child = this.root.resolve(key);
        try (OutputStream out = Files.newOutputStream(child, new OpenOption[0]);){
            out.write(data.array());
        }
        catch (IOException e) {
            RPCClient.getLogger().error(e);
        }
    }

    @Override
    public boolean hasPage(boolean first, int pageIndex) {
        PageData data = this.pageData.get(new PageKey(pageIndex, first));
        return data != null;
    }

    @Override
    public BufferedImage getPageImage(boolean first, int pageIndex, double scaleX, double scaleY) {
        String key = new PageKey(pageIndex, first).getStringKey();
        BufferedImage image = this.getImageForKey(key, scaleX, scaleY);
        if (image == null) {
            // empty if block
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getImageForKey(String key, double scaleX, double scaleY) {
        try (InputStream in = Files.newInputStream(this.root.resolve(key), new OpenOption[0]);){
            BufferedImage img = ImageIO.read(in);
            if (scaleX != 2.0 || scaleY != 2.0) {
                int width = (int)Math.ceil((double)img.getWidth() * (scaleX / 2.0));
                int height = (int)Math.ceil((double)img.getHeight() * (scaleX / 2.0));
                int type = img.getType();
                BufferedImage output = new BufferedImage(width, height, type == 0 ? 2 : type);
                output.getGraphics().drawImage(img, 0, 0, width, height, null);
                BufferedImage bufferedImage2 = output;
                return bufferedImage2;
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        catch (IOException e) {
            RPCClient.getLogger().error(e);
            return null;
        }
    }

    @Override
    public void renderPage(boolean first, int pageIndex, double scale, Graphics2D g) {
        g.drawImage((Image)this.getPageImage(first, pageIndex, scale, scale), 0, 0, null);
    }

    @Override
    public void renderPage(Object key, Graphics2D g2) {
    }
}

