/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model;

import com.inet.annotations.InternalApi;
import com.inet.pdfc.model.Clip;
import com.inet.pdfc.model.DrawableElement;
import com.inet.pdfc.model.ElementComparator;
import com.inet.pdfc.model.ElementType;
import com.inet.pdfc.model.ShapeElement;
import com.inet.pdfc.model.TextElement;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class ElementList
implements Serializable {
    static final long serialVersionUID = 662323490023L;
    private int pageNumber;
    private ArrayList<DrawableElement> list = new ArrayList();
    private List<Clip> clips;

    public ElementList(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public List<DrawableElement> getList() {
        return this.list;
    }

    public void setElements(List<DrawableElement> newElements) {
        if (newElements == this.list) {
            return;
        }
        if (newElements instanceof ArrayList) {
            this.list = (ArrayList)newElements;
        } else {
            this.list = new ArrayList(newElements.size());
            this.list.addAll(newElements);
        }
        this.clips = null;
    }

    public ArrayList<DrawableElement> getListOfVisibleElements() {
        ArrayList<DrawableElement> result = new ArrayList<DrawableElement>();
        List<Clip> clips = this.getClips();
        for (Clip clip : clips) {
            result.addAll(clip.getElements());
        }
        return result;
    }

    public void addDrawableElement(DrawableElement elem) {
        if (elem != null) {
            elem.setPageIndex(this.pageNumber);
            this.list.add(elem);
            this.clips = null;
        }
    }

    public List<Clip> getClips() {
        if (this.clips == null) {
            this.clips = this.generateList();
        }
        return this.clips;
    }

    private synchronized List<Clip> generateList() {
        if (this.clips != null) {
            return this.clips;
        }
        LinkedHashMap<Rectangle, ClipWrapper> clipList = new LinkedHashMap<Rectangle, ClipWrapper>();
        ClipWrapper currentClip = new ClipWrapper(null);
        clipList.put(null, currentClip);
        for (DrawableElement el : this.list) {
            if (el instanceof ShapeElement && ((ShapeElement)el).getIsClip()) {
                Rectangle outline = el.getBounds() != null ? el.getBounds().getBounds() : null;
                currentClip = (ClipWrapper)clipList.get(outline);
                if (currentClip == null) {
                    currentClip = new ClipWrapper(el.getBounds());
                    clipList.put(outline, currentClip);
                    continue;
                }
                if (currentClip.content.size() != 0) continue;
                Rectangle clipBounds = currentClip.outline != null ? currentClip.outline.getBounds() : null;
                clipList.remove(clipBounds);
                clipList.put(clipBounds, currentClip);
                continue;
            }
            currentClip.add(el);
        }
        ArrayList<Clip> clips = new ArrayList<Clip>(clipList.size());
        for (ClipWrapper clip : clipList.values()) {
            Clip pdfClip = clip.getClip();
            if (pdfClip == null) continue;
            clips.add(pdfClip);
        }
        return clips;
    }

    private class ClipWrapper {
        private Rectangle2D outline;
        private List<DrawableElement> content = new ArrayList<DrawableElement>();
        private Map<Rectangle, DrawableElement> checkMap = new HashMap<Rectangle, DrawableElement>();

        public ClipWrapper(Rectangle2D outline) {
            this.outline = outline;
        }

        public void add(DrawableElement e) {
            boolean isNewElement;
            Rectangle2D eBounds = e.getBounds();
            Rectangle eOutline = eBounds.getBounds();
            DrawableElement refElement = this.checkMap.get(eOutline);
            boolean bl = isNewElement = e.getType() == ElementType.Annotation || refElement == null || !ElementComparator.NOLOG_COMPARATOR.isSame(refElement, e) || !eBounds.equals(refElement.getBounds()) && e.getType() != ElementType.Text;
            if (isNewElement) {
                this.content.add(e);
                this.checkMap.put(eOutline, e);
                if (e instanceof TextElement) {
                    ((TextElement)e).setClip(this.outline);
                }
            }
        }

        public Clip getClip() {
            if (this.content.size() > 0) {
                return new Clip(this.outline, this.content);
            }
            return null;
        }
    }
}

