/*
 * Decompiled with CFR 0.152.
 */
package com.inet.pdfc.model.i18n;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Msg {
    private static ResourceBundle getResourceBundle() {
        ResourceBundle languageResourcesTmp;
        try {
            languageResourcesTmp = ResourceBundle.getBundle(Msg.class.getPackage().getName() + ".LanguageResources");
        }
        catch (MissingResourceException e) {
            languageResourcesTmp = null;
        }
        return languageResourcesTmp;
    }

    public static String getMsg(String msgID) {
        String msg;
        try {
            msg = Msg.getResourceBundle().getString(msgID);
        }
        catch (Throwable e) {
            msg = "$" + msgID + "$";
        }
        return msg;
    }

    public static String getMsg(String msgID, Object ... msgParameter) {
        int i;
        StringBuffer msgBuf;
        String msg;
        try {
            msg = Msg.getResourceBundle().getString(msgID);
        }
        catch (Throwable e) {
            msgBuf = new StringBuffer();
            msgBuf.append(msgID);
            msgBuf.append('(');
            for (i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append('{');
                msgBuf.append(i);
                msgBuf.append('}');
            }
            msgBuf.append(')');
            msg = "$" + MessageFormat.format(msgBuf.toString(), msgParameter) + "$";
        }
        try {
            msg = MessageFormat.format(msg, msgParameter);
        }
        catch (Throwable t) {
            msgBuf = new StringBuffer();
            msgBuf.append('$').append(t.toString()).append('_').append(msgID).append('(');
            for (i = 0; i < msgParameter.length; ++i) {
                if (i > 0) {
                    msgBuf.append(',');
                }
                msgBuf.append(msgParameter[i]);
            }
            msgBuf.append(')').append('$');
            msg = msgBuf.toString();
        }
        return msg;
    }

    public static String getMsg(String msgID, Object param0) {
        return Msg.getMsg(msgID, new Object[]{param0});
    }
}

