/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import org.mailster.smtp.api.MessageListener;
import org.mailster.smtp.api.handler.AbstractDeliveryHandler;
import org.mailster.smtp.api.handler.Delivery;
import org.mailster.smtp.api.handler.DeliveryContext;
import org.mailster.smtp.api.handler.RejectException;
import org.mailster.smtp.core.TooMuchDataException;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.util.SharedStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDeliveryHandler
extends AbstractDeliveryHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDeliveryHandler.class);
    private List<Delivery> deliveries = new ArrayList<Delivery>();
    private String from;

    public DefaultDeliveryHandler(DeliveryContext ctx, AuthenticationHandler authHandler) {
        super(ctx, authHandler);
    }

    @Override
    public void from(String from) {
        this.from = from;
    }

    @Override
    public void recipient(String recipient) throws RejectException {
        boolean addedListener = false;
        for (MessageListener listener : this.getListeners()) {
            if (!listener.accept(this.getSessionContext(), this.from, recipient)) continue;
            this.deliveries.add(new Delivery(listener, recipient));
            addedListener = true;
        }
        if (!addedListener) {
            throw new RejectException(553, "<" + recipient + "> address unknown.");
        }
    }

    @Override
    public void resetMessageState() {
        this.deliveries.clear();
    }

    @Override
    public void data(InputStream data) throws TooMuchDataException, IOException {
        boolean useCopy = false;
        if (LOG.isTraceEnabled()) {
            Charset charset = this.getDeliveryContext().getSMTPServerConfig().getCharset();
            InputStream in = SharedStreamUtils.getPrivateInputStream(useCopy, data);
            byte[] buf = new byte[16384];
            try {
                int len;
                CharsetDecoder decoder = charset.newDecoder();
                while ((len = in.read(buf)) >= 0) {
                    LOG.trace(decoder.decode(ByteBuffer.wrap(buf, 0, len)).toString());
                }
            }
            catch (IOException ioex) {
                LOG.trace("Mail data logging failed", (Throwable)ioex);
            }
            useCopy = true;
        }
        ArrayList<Delivery> list = new ArrayList<Delivery>(this.deliveries);
        for (Delivery delivery : list) {
            delivery.getListener().deliver(this.getSessionContext(), this.from, delivery.getRecipient(), SharedStreamUtils.getPrivateInputStream(useCopy, data));
            useCopy = true;
        }
    }
}

