/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.DefaultIoFilterChainBuilder;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.executor.ExecutorFilter;
import org.apache.mina.filter.logging.LoggingFilter;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.mailster.smtp.SMTPServerConfig;
import org.mailster.smtp.api.MessageListener;
import org.mailster.smtp.api.handler.DeliveryHandlerFactory;
import org.mailster.smtp.core.SMTPCodecFactory;
import org.mailster.smtp.core.SMTPConnectionHandler;
import org.mailster.smtp.core.SMTPDecoder;
import org.mailster.smtp.core.auth.AuthenticationHandlerFactory;
import org.mailster.smtp.core.commands.CommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPServer {
    private static final Logger LOG = LoggerFactory.getLogger(SMTPServer.class);
    private InetAddress bindAddress = null;
    private int port = 25;
    private DeliveryHandlerFactory deliveryHandlerFactory;
    private CommandHandler commandHandler;
    private SMTPConnectionHandler handler;
    private SocketAcceptor acceptor;
    private ExecutorService executor;
    private SMTPCodecFactory codecFactory;
    private boolean running = false;
    private boolean shutdowned = false;
    private SMTPServerConfig config = new SMTPServerConfig();

    public SMTPServer() {
        List<MessageListener> listeners = Collections.emptyList();
        this.initInstance(listeners);
    }

    public SMTPServer(MessageListener listener) {
        ArrayList<MessageListener> listeners = new ArrayList<MessageListener>(1);
        listeners.add(listener);
        this.initInstance(listeners);
    }

    public SMTPServer(Collection<MessageListener> listeners) {
        this.initInstance(listeners);
    }

    private void initInstance(Collection<MessageListener> listeners) {
        this.deliveryHandlerFactory = new DeliveryHandlerFactory(listeners);
        this.commandHandler = new CommandHandler();
        this.initService();
    }

    private void initService() {
        try {
            IoBuffer.setUseDirectBuffer((boolean)false);
            this.acceptor = new NioSocketAcceptor(Runtime.getRuntime().availableProcessors() + 1);
            this.acceptor.getSessionConfig().setReuseAddress(true);
            DefaultIoFilterChainBuilder chain = this.acceptor.getFilterChain();
            if (LOG.isTraceEnabled()) {
                chain.addLast("logger", (IoFilter)new LoggingFilter());
            }
            this.codecFactory = new SMTPCodecFactory(this.config);
            chain.addLast("codec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)this.codecFactory));
            this.executor = Executors.newCachedThreadPool(new ThreadFactory(){
                int sequence;

                @Override
                public Thread newThread(Runnable r) {
                    ++this.sequence;
                    return new Thread(r, "MailsterSMTP Thread " + this.sequence);
                }
            });
            chain.addLast("threadPool", (IoFilter)new ExecutorFilter((Executor)this.executor));
            this.handler = new SMTPConnectionHandler(this.getConfig(), this.getCommandHandler(), this.getDeliveryHandlerFactory());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void start() {
        if (this.running) {
            LOG.info("SMTP server is already started.");
            return;
        }
        if (this.shutdowned) {
            throw new RuntimeException("Error: server has been shutdown previously");
        }
        ((SMTPDecoder)this.codecFactory.getDecoder(null)).setup(this.getConfig().getCharset(), this.getConfig().getDataDeferredSize());
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        this.acceptor.setBacklog(this.config.getBacklog());
        this.acceptor.setHandler((IoHandler)this.handler);
        try {
            this.acceptor.bind((SocketAddress)isa);
            this.running = true;
            LOG.info("SMTP server started ...");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void stop() {
        try {
            try {
                this.acceptor.unbind();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            LOG.info("SMTP server stopped.");
        }
        finally {
            this.running = false;
        }
    }

    public synchronized void shutdown() {
        try {
            LOG.info("SMTP server shutting down...");
            if (this.isRunning()) {
                this.stop();
            }
            try {
                this.executor.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.shutdowned = true;
            LOG.info("SMTP server shutdown complete.");
        }
        finally {
            this.running = false;
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuthenticationHandlerFactory(AuthenticationHandlerFactory factory) {
        this.deliveryHandlerFactory.setAuthenticationHandlerFactory(factory);
    }

    public DeliveryHandlerFactory getDeliveryHandlerFactory() {
        return this.deliveryHandlerFactory;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public SMTPServerConfig getConfig() {
        return this.config;
    }
}

