/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class SMTPServerConfig {
    public static final String NAME = "MailsterSMTP";
    public static final String VERSION = "1.0.6";
    public static final int DEFAULT_DATA_DEFERRED_SIZE = 0x400000;
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private Charset charset = DEFAULT_CHARSET;
    private String hostName;
    private int maxRecipients = 1000;
    private boolean tLSSupported = true;
    private int backlog = 5000;
    private int receiveBufferSize = 128;
    private int dataDeferredSize = 0x400000;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;

    protected SMTPServerConfig() {
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "localhost";
        }
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getDataDeferredSize() {
        return this.dataDeferredSize;
    }

    public void setDataDeferredSize(int dataDeferredSize) {
        if (!this.isPowerOfTwo(dataDeferredSize)) {
            throw new IllegalArgumentException("Argument dataDeferredSize must be a positive power of two");
        }
        this.dataDeferredSize = dataDeferredSize;
    }

    private boolean isPowerOfTwo(int x) {
        return x > 1 && (x & x - 1) == 0;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    public String getNameVersion() {
        return "MailsterSMTP 1.0.6";
    }

    public String getHostName() {
        if (this.hostName == null) {
            return "localhost";
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public boolean isTLSSupported() {
        return this.tLSSupported;
    }

    public void setTLSSupported(boolean supported) {
        this.tLSSupported = supported;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

