/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.api.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.mailster.smtp.api.MessageListener;
import org.mailster.smtp.api.handler.DeliveryContext;
import org.mailster.smtp.api.handler.RejectException;
import org.mailster.smtp.api.handler.SessionContext;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.TooMuchDataException;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.core.auth.Credential;
import org.mailster.smtp.core.auth.LoginFailedException;

public abstract class AbstractDeliveryHandler
implements AuthenticationHandler {
    private AuthenticationHandler authHandler;
    private Collection<MessageListener> listeners;
    private DeliveryContext ctx;
    private SessionContextImpl sessionCtx;

    protected AbstractDeliveryHandler(DeliveryContext ctx, AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
        this.ctx = ctx;
        this.sessionCtx = new SessionContextImpl();
    }

    public DeliveryContext getDeliveryContext() {
        return this.ctx;
    }

    public SessionContext getSessionContext() {
        return this.sessionCtx;
    }

    public Collection<MessageListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Collection<MessageListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public boolean auth(String clientInput, StringBuilder response, SMTPContext ctx) throws LoginFailedException {
        return this.authHandler.auth(clientInput, response, ctx);
    }

    @Override
    public void resetState() {
        this.authHandler.resetState();
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return this.authHandler.getAuthenticationMechanisms();
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authHandler;
    }

    public abstract void from(String var1) throws RejectException;

    public abstract void recipient(String var1) throws RejectException;

    public abstract void data(InputStream var1) throws TooMuchDataException, IOException;

    public abstract void resetMessageState();

    private class SessionContextImpl
    implements SessionContext {
        private HashMap<String, Object> attrs = new HashMap();

        @Override
        public void addAttribute(String key, Object attr) {
            this.attrs.put(key, attr);
        }

        @Override
        public Object getAttribute(String key) {
            return this.attrs.get(key);
        }

        @Override
        public Credential getCredential() {
            return AbstractDeliveryHandler.this.ctx.getCredential();
        }

        @Override
        public SocketAddress getRemoteAddress() {
            return AbstractDeliveryHandler.this.ctx.getRemoteAddress();
        }

        @Override
        public void removeAttribute(String key) {
            this.attrs.remove(key);
        }

        @Override
        public void setAttribute(String key, Object attr) {
            this.attrs.put(key, attr);
        }
    }
}

