/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.api.handler;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import org.mailster.smtp.DefaultDeliveryHandler;
import org.mailster.smtp.api.MessageListener;
import org.mailster.smtp.api.handler.AbstractDeliveryHandler;
import org.mailster.smtp.api.handler.DeliveryContext;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.core.auth.AuthenticationHandlerFactory;
import org.mailster.smtp.core.auth.impl.DummyAuthenticationHandler;

public class DeliveryHandlerFactory {
    private Collection<MessageListener> listeners;
    private AuthenticationHandlerFactory authenticationHandlerFactory;
    private AuthenticationHandler authHandler;
    private Class<? extends AbstractDeliveryHandler> deliveryHandlerImplClass = DefaultDeliveryHandler.class;

    public DeliveryHandlerFactory(Collection<MessageListener> listeners) {
        this.listeners = listeners == null ? new ArrayList() : listeners;
    }

    public synchronized void addAllListeners(Collection<MessageListener> listeners) {
        this.listeners.addAll(listeners);
    }

    public synchronized void addListener(MessageListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(MessageListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized ArrayList<MessageListener> copyListeners() {
        return new ArrayList<MessageListener>(this.listeners);
    }

    public AbstractDeliveryHandler create(DeliveryContext ctx) {
        return this.create(ctx, this.deliveryHandlerImplClass);
    }

    public void setDeliveryHandlerImplClass(Class<? extends AbstractDeliveryHandler> c) {
        this.deliveryHandlerImplClass = c;
    }

    private AbstractDeliveryHandler create(DeliveryContext ctx, Class<? extends AbstractDeliveryHandler> c) {
        try {
            Constructor<? extends AbstractDeliveryHandler> cstr = c.getConstructor(DeliveryContext.class, AuthenticationHandler.class);
            AbstractDeliveryHandler handler = cstr.newInstance(ctx, this.getAuthenticationHandler());
            handler.setListeners(this.copyListeners());
            return handler;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed instantiating DeliveryHandler - " + c.getName(), e);
        }
    }

    public synchronized AuthenticationHandlerFactory getAuthenticationHandlerFactory() {
        return this.authenticationHandlerFactory;
    }

    public synchronized void setAuthenticationHandlerFactory(AuthenticationHandlerFactory authenticationHandlerFactory) {
        this.authHandler = null;
        this.authenticationHandlerFactory = authenticationHandlerFactory;
    }

    public synchronized AuthenticationHandler getAuthenticationHandler() {
        if (this.authHandler != null) {
            return this.authHandler;
        }
        if (this.getAuthenticationHandlerFactory() != null) {
            this.authHandler = this.getAuthenticationHandlerFactory().create();
            if (this.authHandler == null) {
                throw new NullPointerException("AuthenticationHandlerFactory returned a null handler");
            }
        } else {
            this.authHandler = new DummyAuthenticationHandler();
        }
        return this.authHandler;
    }
}

