/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core;

import java.nio.charset.Charset;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.filter.codec.textline.LineDelimiter;
import org.apache.mina.filter.codec.textline.TextLineEncoder;
import org.mailster.smtp.SMTPServerConfig;
import org.mailster.smtp.core.SMTPDecoder;

public class SMTPCodecFactory
implements ProtocolCodecFactory {
    private final TextLineEncoder encoder;
    private final SMTPDecoder decoder;

    public SMTPCodecFactory(SMTPServerConfig config) {
        this(config.getCharset(), config.getDataDeferredSize());
    }

    protected SMTPCodecFactory(Charset charset, int dataDeferredSize) {
        this.encoder = new TextLineEncoder(charset, LineDelimiter.CRLF);
        this.decoder = new SMTPDecoder(charset, dataDeferredSize);
    }

    public ProtocolEncoder getEncoder(IoSession session) {
        return this.encoder;
    }

    public ProtocolDecoder getDecoder(IoSession session) {
        return this.decoder;
    }

    public int getEncoderMaxLineLength() {
        return this.encoder.getMaxLineLength();
    }

    public void setEncoderMaxLineLength(int maxLineLength) {
        this.encoder.setMaxLineLength(maxLineLength);
    }

    public int getDecoderMaxLineLength() {
        return this.decoder.getMaxLineLength();
    }

    public void setDecoderMaxLineLength(int maxLineLength) {
        this.decoder.setMaxLineLength(maxLineLength);
    }
}

