/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mina.core.buffer.BufferDataException;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.mina.transport.socket.SocketSessionConfig;
import org.mailster.smtp.SMTPServerConfig;
import org.mailster.smtp.api.handler.DeliveryHandlerFactory;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.TooMuchDataException;
import org.mailster.smtp.core.commands.Command;
import org.mailster.smtp.core.commands.CommandException;
import org.mailster.smtp.core.commands.CommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPConnectionHandler
extends IoHandlerAdapter {
    public static final String CONTEXT_ATTRIBUTE = SMTPConnectionHandler.class.getName() + ".ctx";
    private static final Logger LOG = LoggerFactory.getLogger(SMTPConnectionHandler.class);
    private SMTPServerConfig config;
    private CommandHandler commandHandler;
    private DeliveryHandlerFactory factory;
    private AtomicInteger numberOfConnections = new AtomicInteger(0);

    public SMTPConnectionHandler(SMTPServerConfig cfg, CommandHandler handler, DeliveryHandlerFactory factory) {
        this.config = cfg;
        this.commandHandler = handler;
        this.factory = factory;
    }

    public static void sendResponse(IoSession session, String response) {
        SMTPContext minaCtx;
        if (LOG.isDebugEnabled()) {
            LOG.debug("S: " + response);
        }
        if (response != null) {
            session.write((Object)response);
        }
        if (!(minaCtx = (SMTPContext)session.getAttribute((Object)CONTEXT_ATTRIBUTE)).getSMTPState().isActive()) {
            session.closeOnFlush();
        }
    }

    private boolean hasTooManyConnections() {
        return this.config.getMaxConnections() > -1 && this.getNumberOfConnections() >= this.config.getMaxConnections();
    }

    private void updateNumberOfConnections(int delta) {
        int count = this.numberOfConnections.addAndGet(delta);
        LOG.debug("Active connections count = {}", (Object)count);
    }

    public int getNumberOfConnections() {
        return this.numberOfConnections.get();
    }

    public void sessionCreated(IoSession session) {
        this.updateNumberOfConnections(1);
        if (session.getTransportMetadata().getSessionConfigType() == SocketSessionConfig.class) {
            ((SocketSessionConfig)session.getConfig()).setReceiveBufferSize(this.config.getReceiveBufferSize());
            ((SocketSessionConfig)session.getConfig()).setSendBufferSize(64);
        }
        session.getConfig().setIdleTime(IdleStatus.READER_IDLE, this.config.getConnectionTimeout() / 1000);
        session.setAttribute((Object)SslFilter.USE_NOTIFICATION);
        LOG.debug("SMTP connection count: {}", (Object)this.getNumberOfConnections());
        SMTPContext minaCtx = new SMTPContext(this.config, this.factory, session);
        session.setAttribute((Object)CONTEXT_ATTRIBUTE, (Object)minaCtx);
        if (this.hasTooManyConnections()) {
            LOG.debug("Too many connections to the SMTP server !");
            SMTPConnectionHandler.sendResponse(session, "554 Transaction failed. Too many connections.");
        } else {
            SMTPConnectionHandler.sendResponse(session, "220 " + this.config.getHostName() + " ESMTP MailsterSMTP");
        }
    }

    public void sessionClosed(IoSession session) {
        this.updateNumberOfConnections(-1);
    }

    public void sessionIdle(IoSession session, IdleStatus status) {
        try {
            SMTPConnectionHandler.sendResponse(session, "421 Timeout waiting for data from client.");
        }
        finally {
            session.closeOnFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(IoSession session, Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exception occured :", cause);
        }
        boolean fatal = true;
        try {
            if (cause instanceof BufferDataException) {
                SMTPConnectionHandler.sendResponse(session, "501 " + cause.getMessage());
            } else if (cause instanceof CommandException) {
                fatal = false;
                SMTPConnectionHandler.sendResponse(session, "500 Syntax error");
            } else {
                SMTPConnectionHandler.sendResponse(session, "450 Problem attempting to execute commands. Please try again later.");
            }
        }
        finally {
            if (fatal) {
                session.closeOnFlush();
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        if (message == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("no more lines from client");
            }
            return;
        }
        if (message instanceof SslFilter.SslFilterMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SSL FILTER message -> " + message);
            }
            return;
        }
        SMTPContext minaCtx = (SMTPContext)session.getAttribute((Object)CONTEXT_ATTRIBUTE);
        if (message instanceof InputStream) {
            minaCtx.setInputStream((InputStream)message);
            try {
                minaCtx.getDeliveryHandler().data(minaCtx.getInputStream());
                minaCtx.reset();
                SMTPConnectionHandler.sendResponse(session, "250 Ok");
            }
            catch (TooMuchDataException tmdEx) {
                SMTPConnectionHandler.sendResponse(session, "552 Too much mail data");
            }
        } else {
            String line = (String)message;
            if (LOG.isDebugEnabled()) {
                LOG.debug("C: " + line);
            }
            if (minaCtx.getSMTPState().isAuthenticating()) {
                this.commandHandler.handleAuthChallenge(line, session, minaCtx);
            } else if (!minaCtx.getSMTPState().isAuthenticated() && !minaCtx.getAuthenticationHandler().getAuthenticationMechanisms().isEmpty()) {
                Command cmd = this.commandHandler.getCommandFromString(line);
                if (cmd.isAuthRequired()) {
                    SMTPConnectionHandler.sendResponse(session, "530 Authentication required");
                } else {
                    this.commandHandler.handleCommand(line, session, minaCtx);
                }
            } else {
                this.commandHandler.handleCommand(line, session, minaCtx);
            }
        }
    }
}

