/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core;

import java.io.InputStream;
import java.net.SocketAddress;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.SMTPServerConfig;
import org.mailster.smtp.api.handler.AbstractDeliveryHandler;
import org.mailster.smtp.api.handler.DeliveryContext;
import org.mailster.smtp.api.handler.DeliveryHandlerFactory;
import org.mailster.smtp.core.SMTPState;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.core.auth.Credential;

public class SMTPContext
implements DeliveryContext {
    private SMTPServerConfig cfg;
    private SMTPState smtpState;
    private SocketAddress remoteAddress;
    private Credential credential;
    private InputStream inputStream;
    private AbstractDeliveryHandler deliveryHandler;
    private AuthenticationHandler authenticationHandler;

    public SMTPContext(SMTPServerConfig cfg, DeliveryHandlerFactory factory, IoSession ioSession) {
        this.cfg = cfg;
        this.remoteAddress = ioSession.getRemoteAddress();
        this.smtpState = new SMTPState();
        this.deliveryHandler = factory.create(this);
        this.authenticationHandler = this.deliveryHandler.getAuthenticationHandler();
    }

    public AbstractDeliveryHandler getDeliveryHandler() {
        return this.deliveryHandler;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public SMTPState getSMTPState() {
        return this.smtpState;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SMTPServerConfig getSMTPServerConfig() {
        return this.cfg;
    }

    @Override
    public Credential getCredential() {
        return this.credential;
    }

    public void setCredential(Credential credential) {
        this.credential = credential;
    }

    public void reset() {
        this.smtpState.reset();
        this.deliveryHandler.resetMessageState();
    }
}

