/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core;

import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.apache.mina.core.buffer.BufferDataException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.mailster.smtp.core.SMTPConnectionHandler;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.SMTPDecoderContext;

public class SMTPDecoder
implements ProtocolDecoder {
    protected static final String TMPFILE_PREFIX = "mailsterSmtp";
    protected static final String TMPFILE_SUFFIX = ".eml";
    private static final String CONTEXT = SMTPDecoder.class.getName() + ".context";
    private static final byte[] SMTP_CMD_DELIMITER = new byte[]{13, 10};
    private static final byte[] SMTP_DATA_DELIMITER = new byte[]{13, 10, 46, 13, 10};
    private Charset charset;
    private int maxLineLength = 998;
    private int threshold;

    public SMTPDecoder(Charset charset, int thresholdBytes) {
        this.setup(charset, thresholdBytes);
    }

    public void setup(Charset charset, int thresholdBytes) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
        this.threshold = thresholdBytes;
    }

    public void setDataDeferredSize(int dataDeferredSize) {
        this.threshold = dataDeferredSize;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        if (maxLineLength <= 0) {
            throw new IllegalArgumentException("maxLineLength: " + maxLineLength);
        }
        this.maxLineLength = maxLineLength;
    }

    private SMTPDecoderContext getContext(IoSession session) {
        SMTPDecoderContext ctx = (SMTPDecoderContext)session.getAttribute((Object)CONTEXT);
        if (ctx == null) {
            ctx = new SMTPDecoderContext(this);
            session.setAttribute((Object)CONTEXT, (Object)ctx);
        }
        return ctx;
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) {
    }

    public void dispose(IoSession session) throws Exception {
        SMTPDecoderContext ctx = (SMTPDecoderContext)session.getAttribute((Object)CONTEXT);
        if (ctx != null) {
            ctx.getBuffer().free();
            ctx.closeOutputStream();
            session.removeAttribute((Object)CONTEXT);
        }
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        SMTPDecoderContext ctx = this.getContext(session);
        int matchCount = ctx.getMatchCount();
        SMTPContext minaCtx = (SMTPContext)session.getAttribute((Object)SMTPConnectionHandler.CONTEXT_ATTRIBUTE);
        boolean dataMode = minaCtx.getSMTPState().isDataMode();
        ctx.setDataMode(dataMode);
        byte[] delimBuf = dataMode ? SMTP_DATA_DELIMITER : SMTP_CMD_DELIMITER;
        int oldPos = in.position();
        int oldLimit = in.limit();
        if (matchCount == delimBuf.length) {
            matchCount = 0;
        }
        while (in.remaining() > 0) {
            byte b = in.get();
            if (delimBuf[matchCount] == b) {
                if (++matchCount != delimBuf.length) continue;
                int pos = in.position();
                in.limit(pos);
                in.position(oldPos);
                ctx.write(in);
                in.limit(oldLimit);
                in.position(pos);
                if (ctx.getOverflowPosition() == 0) {
                    IoBuffer buf = ctx.getBuffer();
                    buf.flip();
                    try {
                        if (dataMode) {
                            delimBuf = SMTP_CMD_DELIMITER;
                            out.write((Object)ctx.getNewInputStream());
                        }
                        buf.limit(buf.limit() - matchCount);
                        out.write((Object)buf.getString(ctx.getDecoder()));
                    }
                    catch (IOException ioex) {
                        throw new CharacterCodingException();
                    }
                    finally {
                        ctx.reset();
                        buf.clear();
                    }
                } else {
                    String msg = "Line is too long: " + ctx.getOverflowPosition();
                    ctx.reset();
                    throw new BufferDataException(msg);
                }
                oldPos = pos;
                matchCount = 0;
                continue;
            }
            in.position(Math.max(0, in.position() - matchCount));
            matchCount = 0;
        }
        in.position(oldPos);
        ctx.write(in);
        ctx.setMatchCount(matchCount);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getThreshold() {
        return this.threshold;
    }
}

