/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core;

import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharsetDecoder;
import org.apache.mina.core.buffer.IoBuffer;
import org.mailster.smtp.core.SMTPDecoder;
import org.mailster.smtp.util.SharedTmpFileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMTPDecoderContext {
    private static final Logger LOG = LoggerFactory.getLogger(SMTPDecoderContext.class);
    private final CharsetDecoder charsetDecoder;
    private IoBuffer buf;
    private int matchCount = 0;
    private int overflowPosition = 0;
    private boolean thresholdReached = false;
    private boolean dataMode = false;
    private File outFile;
    private FileOutputStream stream;
    private SMTPDecoder decoder;

    protected SMTPDecoderContext(SMTPDecoder decoder) {
        this.decoder = decoder;
        this.charsetDecoder = decoder.getCharset().newDecoder();
        this.buf = IoBuffer.allocate((int)decoder.getMaxLineLength()).setAutoExpand(true);
    }

    private static byte[] asArray(IoBuffer b) {
        int len = b.remaining();
        byte[] array = new byte[len];
        b.get(array, 0, len);
        return array;
    }

    protected CharsetDecoder getDecoder() {
        return this.charsetDecoder;
    }

    protected IoBuffer getBuffer() {
        return this.buf;
    }

    private void compactBuffer() {
        if (this.dataMode && this.buf.capacity() > this.decoder.getMaxLineLength()) {
            this.buf = IoBuffer.allocate((int)this.decoder.getMaxLineLength()).setAutoExpand(true);
        } else {
            this.buf.clear();
        }
    }

    protected int getOverflowPosition() {
        return this.overflowPosition;
    }

    protected int getMatchCount() {
        return this.matchCount;
    }

    protected void setMatchCount(int matchCount) {
        this.matchCount = matchCount;
    }

    protected void reset() throws IOException {
        this.overflowPosition = 0;
        this.matchCount = 0;
        this.charsetDecoder.reset();
        if (this.thresholdReached) {
            this.thresholdReached = false;
            this.compactBuffer();
            this.closeOutputStream();
        }
    }

    protected void write(IoBuffer b) throws IOException {
        if (this.dataMode) {
            this.write(SMTPDecoderContext.asArray(b));
        } else {
            this.append(b);
        }
    }

    private void write(byte[] src) throws IOException {
        int predicted;
        int n = predicted = this.thresholdReached ? 0 : this.buf.position() + src.length;
        if (this.thresholdReached || predicted > this.decoder.getThreshold()) {
            if (!this.thresholdReached) {
                this.thresholdReached();
            }
            this.stream.write(src);
        } else {
            this.buf.put(src);
        }
    }

    private void thresholdReached() throws IOException {
        this.outFile = File.createTempFile("mailsterSmtp", ".eml");
        LOG.debug("Writing message to file : {}", (Object)this.outFile.getAbsolutePath());
        this.stream = new FileOutputStream(this.outFile);
        this.buf.flip();
        this.stream.write(SMTPDecoderContext.asArray(this.buf));
        this.thresholdReached = true;
        this.buf.clear();
        LOG.debug("ByteBuffer written to stream");
    }

    protected void closeOutputStream() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
            this.stream.close();
            LOG.debug("Temp file writing achieved - closing stream");
        }
    }

    protected InputStream getNewInputStream() throws IOException {
        if (this.thresholdReached) {
            return new SharedTmpFileInputStream(this.outFile);
        }
        return new SharedByteArrayInputStream(SMTPDecoderContext.asArray(this.buf));
    }

    private void append(IoBuffer in) {
        if (this.overflowPosition != 0) {
            this.discard(in);
        } else {
            int pos = this.buf.position();
            if (pos + in.remaining() > this.decoder.getMaxLineLength()) {
                this.overflowPosition = pos;
                this.buf.clear();
                this.discard(in);
            } else {
                this.buf.put(in);
            }
        }
    }

    private void discard(IoBuffer in) {
        this.overflowPosition = Integer.MAX_VALUE < this.overflowPosition + in.remaining() ? Integer.MAX_VALUE : (this.overflowPosition += in.remaining());
        in.position(in.limit());
    }

    public void setDataMode(boolean dataMode) {
        this.dataMode = dataMode;
    }
}

