/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.auth.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.core.auth.Credential;
import org.mailster.smtp.core.auth.LoginFailedException;
import org.mailster.smtp.core.auth.LoginValidator;
import org.mailster.smtp.util.Base64;

public class LoginAuthenticationHandler
implements AuthenticationHandler {
    private String username;
    private String password;
    private LoginValidator helper;
    private List<String> authentificationMechanisms;

    public LoginAuthenticationHandler(LoginValidator helper) {
        this.helper = helper;
        this.authentificationMechanisms = new ArrayList<String>(1);
        this.authentificationMechanisms.add("LOGIN");
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authentificationMechanisms);
    }

    @Override
    public boolean auth(String clientInput, StringBuilder response, SMTPContext ctx) throws LoginFailedException {
        StringTokenizer stk = new StringTokenizer(clientInput);
        String token = stk.nextToken();
        if (token.trim().equalsIgnoreCase("AUTH")) {
            if (!stk.nextToken().trim().equalsIgnoreCase("LOGIN")) {
                response.append("504 AUTH mechanism mismatch");
                return true;
            }
            if (stk.hasMoreTokens()) {
                response.append("535 Initial response not allowed in AUTH LOGIN");
                return true;
            }
            response.append("334 ").append(Base64.encodeToString("Username:".getBytes(), false));
            return false;
        }
        if (this.username == null) {
            byte[] decoded = Base64.decode(clientInput);
            if (decoded == null) {
                throw new LoginFailedException();
            }
            this.username = new String(decoded);
            response.append("334 ").append(Base64.encodeToString("Password:".getBytes(), false));
            return false;
        }
        byte[] decoded = Base64.decode(clientInput);
        if (decoded == null) {
            throw new LoginFailedException();
        }
        this.password = new String(decoded);
        try {
            this.helper.login(this.username, this.password);
            this.resetState();
        }
        catch (LoginFailedException lfe) {
            this.resetState();
            throw lfe;
        }
        ctx.setCredential(new Credential(this.username));
        return true;
    }

    @Override
    public void resetState() {
        this.username = null;
        this.password = null;
    }
}

