/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.auth.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.auth.AuthenticationHandler;
import org.mailster.smtp.core.auth.Credential;
import org.mailster.smtp.core.auth.LoginFailedException;
import org.mailster.smtp.core.auth.LoginValidator;
import org.mailster.smtp.util.Base64;

public class PlainAuthenticationHandler
implements AuthenticationHandler {
    private LoginValidator helper;
    private List<String> authentificationMechanisms;

    public PlainAuthenticationHandler(LoginValidator helper) {
        this.helper = helper;
        this.authentificationMechanisms = new ArrayList<String>(1);
        this.authentificationMechanisms.add("PLAIN");
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return Collections.unmodifiableList(this.authentificationMechanisms);
    }

    @Override
    public boolean auth(String clientInput, StringBuilder response, SMTPContext ctx) throws LoginFailedException {
        byte[] decodedSecret;
        StringTokenizer stk = new StringTokenizer(clientInput);
        String secret = stk.nextToken();
        if (secret.trim().equalsIgnoreCase("AUTH")) {
            if (!stk.nextToken().trim().equalsIgnoreCase("PLAIN")) {
                response.append("504 AUTH mechanism mismatch");
                return true;
            }
            if (stk.hasMoreTokens()) {
                secret = stk.nextToken();
            } else {
                response.append("334 Ok");
                return false;
            }
        }
        if ((decodedSecret = Base64.decode(secret)) == null) {
            throw new LoginFailedException();
        }
        int usernameStop = -1;
        for (int i = 1; i < decodedSecret.length && usernameStop < 0; ++i) {
            if (decodedSecret[i] != 0) continue;
            usernameStop = i;
        }
        String username = new String(decodedSecret, 1, usernameStop - 1);
        String password = new String(decodedSecret, usernameStop + 1, decodedSecret.length - usernameStop - 1);
        try {
            this.helper.login(username, password);
            this.resetState();
        }
        catch (LoginFailedException lfe) {
            this.resetState();
            throw lfe;
        }
        ctx.setCredential(new Credential(username));
        return true;
    }

    @Override
    public void resetState() {
    }
}

