/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands;

import java.lang.reflect.InvocationTargetException;
import org.mailster.smtp.core.commands.Command;
import org.mailster.smtp.core.commands.impl.AuthCommand;
import org.mailster.smtp.core.commands.impl.DataCommand;
import org.mailster.smtp.core.commands.impl.EhloCommand;
import org.mailster.smtp.core.commands.impl.HeloCommand;
import org.mailster.smtp.core.commands.impl.HelpCommand;
import org.mailster.smtp.core.commands.impl.MailCommand;
import org.mailster.smtp.core.commands.impl.NoopCommand;
import org.mailster.smtp.core.commands.impl.QuitCommand;
import org.mailster.smtp.core.commands.impl.ReceiptCommand;
import org.mailster.smtp.core.commands.impl.ResetCommand;
import org.mailster.smtp.core.commands.impl.StartTLSCommand;

public enum BuiltinCommandRegistry {
    AUTH(AuthCommand.class),
    DATA(DataCommand.class),
    EHLO(EhloCommand.class),
    HELO(HeloCommand.class),
    HELP(HelpCommand.class),
    MAIL(MailCommand.class),
    NOOP(NoopCommand.class),
    QUIT(QuitCommand.class),
    RCPT(ReceiptCommand.class),
    RSET(ResetCommand.class),
    STARTTLS(StartTLSCommand.class);

    private Command instance;

    private BuiltinCommandRegistry(Class<? extends Command> c) {
        try {
            this.instance = c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public Command getCommand() {
        return this.instance;
    }
}

