/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.core.SMTPConnectionHandler;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.commands.AbstractCommand;
import org.mailster.smtp.core.commands.BuiltinCommandRegistry;
import org.mailster.smtp.core.commands.Command;
import org.mailster.smtp.core.commands.CommandException;
import org.mailster.smtp.core.commands.InvalidCommandNameException;
import org.mailster.smtp.core.commands.UnknownCommandException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CommandHandler.class);
    private Map<String, Command> commandMap = new HashMap<String, Command>();

    public CommandHandler() {
        for (BuiltinCommandRegistry entry : BuiltinCommandRegistry.values()) {
            this.addCommand(entry.getCommand());
        }
    }

    public void addCommand(Command cmd) {
        LOG.debug("Added command {}", (Object)cmd.getName());
        if (cmd instanceof AbstractCommand) {
            ((AbstractCommand)cmd).setCommandHandler(this);
        }
        this.commandMap.put(cmd.getName(), cmd);
    }

    public boolean containsCommand(String cmd) {
        return this.commandMap.containsKey(cmd);
    }

    public void handleCommand(String cmdString, IoSession session, SMTPContext ctx) throws IOException {
        try {
            Command cmd = this.getCommandFromString(cmdString);
            cmd.execute(cmdString, session, ctx);
        }
        catch (CommandException e) {
            SMTPConnectionHandler.sendResponse(session, "500 " + e.getMessage());
        }
    }

    public void handleAuthChallenge(String commandString, IoSession session, SMTPContext ctx) throws SocketTimeoutException, IOException {
        Command cmd = this.commandMap.get("AUTH");
        cmd.execute(commandString, session, ctx);
    }

    public Command getCommandFromString(String cmdString) throws UnknownCommandException, InvalidCommandNameException {
        String verb = this.toVerb(cmdString);
        Command cmd = this.commandMap.get(verb);
        if (cmd == null) {
            throw new UnknownCommandException("Command not implemented");
        }
        return cmd;
    }

    private String toVerb(String cmd) throws InvalidCommandNameException {
        if (cmd == null || cmd.length() < 4) {
            throw new InvalidCommandNameException("Syntax error");
        }
        StringTokenizer st = new StringTokenizer(cmd);
        if (!st.hasMoreTokens()) {
            throw new InvalidCommandNameException("Syntax error");
        }
        return st.nextToken().toUpperCase();
    }
}

