/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands;

import java.util.StringTokenizer;

public class HelpMessage {
    private String commandName;
    private String argumentsDescription;
    private String helpMessage;
    private String outputString;

    public HelpMessage(String commandName, String helpMessage) {
        this(commandName, helpMessage, null);
    }

    public HelpMessage(String commandName, String helpMessage, String argumentsDescription) {
        this.commandName = commandName;
        this.argumentsDescription = argumentsDescription;
        this.helpMessage = helpMessage;
        this.buildOutputString();
    }

    public String getName() {
        return this.commandName;
    }

    public String toString() {
        return this.outputString;
    }

    private void buildOutputString() {
        StringBuilder sb = new StringBuilder();
        StringTokenizer tk = new StringTokenizer(this.helpMessage, "\n");
        while (tk.hasMoreTokens()) {
            sb.append("214-");
            sb.append(tk.nextToken()).append("\r\n");
        }
        if (this.argumentsDescription != null) {
            sb.append("214-").append(this.commandName).append(' ');
            tk = new StringTokenizer(this.argumentsDescription, "\n");
            while (tk.hasMoreTokens()) {
                sb.append(tk.nextToken());
                if (!tk.hasMoreTokens()) continue;
                sb.append("\r\n214-    ");
            }
            sb.append("\r\n");
        }
        sb.append("214 End of ").append(this.commandName).append(" info");
        this.outputString = sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelpMessage that = (HelpMessage)o;
        if (this.argumentsDescription != null ? !this.argumentsDescription.equals(that.argumentsDescription) : that.argumentsDescription != null) {
            return false;
        }
        if (this.commandName != null ? !this.commandName.equals(that.commandName) : that.commandName != null) {
            return false;
        }
        return !(this.helpMessage == null ? that.helpMessage != null : !this.helpMessage.equals(that.helpMessage));
    }

    public int hashCode() {
        int result = this.commandName != null ? this.commandName.hashCode() : 0;
        result = 29 * result + (this.argumentsDescription != null ? this.argumentsDescription.hashCode() : 0);
        result = 29 * result + (this.helpMessage != null ? this.helpMessage.hashCode() : 0);
        return result;
    }
}

