/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands.impl;

import java.io.IOException;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.SMTPState;
import org.mailster.smtp.core.auth.LoginFailedException;
import org.mailster.smtp.core.commands.AbstractCommand;

public class AuthCommand
extends AbstractCommand {
    public static final String VERB = "AUTH";
    public static final String AUTH_CANCEL_COMMAND = "*";

    public AuthCommand() {
        super(VERB, "The AUTH command allow to select the authentication mechanism to use\nwhen authenticating with the server", "<mechanism> [<initial-response>]\n mechanism = a string identifying a SASL authentication mechanism,\n initial-response = an optional base64-encoded response");
    }

    @Override
    public boolean isAuthRequired() {
        return false;
    }

    @Override
    public void execute(String commandString, IoSession ioSession, SMTPContext ctx) throws IOException {
        SMTPState smtpState = ctx.getSMTPState();
        if (smtpState.isAuthenticated()) {
            this.sendResponse(ioSession, "503 Refusing any other AUTH command");
            return;
        }
        boolean authenticating = smtpState.isAuthenticating();
        if (!authenticating) {
            String[] args = this.getArgs(commandString);
            if (args.length < 2) {
                this.sendResponse(ioSession, "501 Syntax: AUTH mechanism [initial-response]");
                return;
            }
            String mechanism = args[1];
            if (!ctx.getAuthenticationHandler().getAuthenticationMechanisms().contains(mechanism.toUpperCase())) {
                this.sendResponse(ioSession, "504 Unrecognized authentication type");
                return;
            }
        }
        try {
            if (authenticating && commandString.trim().equals(AUTH_CANCEL_COMMAND)) {
                this.sendResponse(ioSession, "501 Authentication canceled by client");
                return;
            }
            StringBuilder response = new StringBuilder();
            boolean finished = ctx.getAuthenticationHandler().auth(commandString, response, ctx);
            smtpState.setAuthenticating(!finished);
            if (!finished) {
                this.sendResponse(ioSession, response.toString());
                return;
            }
            smtpState.setAuthenticated(true);
            this.sendResponse(ioSession, "235 Authentication successful");
        }
        catch (LoginFailedException ex) {
            this.sendResponse(ioSession, "535 Authentication failure");
            smtpState.setAuthenticated(false);
            smtpState.setAuthenticating(false);
        }
    }
}

