/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands.impl;

import java.io.IOException;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.SMTPState;
import org.mailster.smtp.core.commands.AbstractCommand;

public class DataCommand
extends AbstractCommand {
    public DataCommand() {
        super("DATA", "The DATA command initiates the message transmission.\nMessage ends with <CR><LF>.<CR><LF>");
    }

    @Override
    public void execute(String commandString, IoSession ioSession, SMTPContext ctx) throws IOException {
        SMTPState smtpState = ctx.getSMTPState();
        if (!smtpState.getHasSender()) {
            this.sendResponse(ioSession, "503 Error: need MAIL command");
            return;
        }
        if (smtpState.getRecipientCount() == 0) {
            this.sendResponse(ioSession, "503 Error: need RCPT command");
            return;
        }
        smtpState.setDataMode(true);
        this.sendResponse(ioSession, "354 End data with <CR><LF>.<CR><LF>");
    }
}

