/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands.impl;

import java.io.IOException;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.api.handler.RejectException;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.SMTPState;
import org.mailster.smtp.core.commands.AbstractCommand;

public class MailCommand
extends AbstractCommand {
    public MailCommand() {
        super("MAIL", "The MAIL FROM command specifies the sender", "FROM: <address>\n address = the email address of the sender");
    }

    @Override
    public void execute(String commandString, IoSession ioSession, SMTPContext ctx) throws IOException {
        SMTPState smtpState = ctx.getSMTPState();
        if (!smtpState.getHasSeenHelo()) {
            this.sendResponse(ioSession, "503 Error: send HELO/EHLO first");
        } else if (smtpState.getHasSender()) {
            this.sendResponse(ioSession, "503 Sender already specified");
        } else {
            if (commandString.trim().equals("MAIL FROM:")) {
                this.sendResponse(ioSession, "501 Syntax: MAIL FROM: <address>");
                return;
            }
            String args = this.getArgPredicate(commandString);
            if (!args.toUpperCase().startsWith("FROM:")) {
                this.sendResponse(ioSession, "501 Syntax: MAIL FROM: <address>  Error in parameters: \"" + this.getArgPredicate(commandString) + "\"");
                return;
            }
            String emailAddress = this.extractEmailAddress(args, 5);
            if (this.isValidEmailAddress(emailAddress)) {
                try {
                    ctx.getDeliveryHandler().from(emailAddress);
                    smtpState.setHasSender(true);
                    this.sendResponse(ioSession, "250 Ok");
                }
                catch (RejectException ex) {
                    this.sendResponse(ioSession, ex.getMessage());
                }
            } else {
                this.sendResponse(ioSession, "553 <" + emailAddress + "> Invalid email address");
            }
        }
    }
}

