/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands.impl;

import java.io.IOException;
import org.apache.mina.core.session.IoSession;
import org.mailster.smtp.api.handler.RejectException;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.SMTPState;
import org.mailster.smtp.core.commands.AbstractCommand;

public class ReceiptCommand
extends AbstractCommand {
    public ReceiptCommand() {
        super("RCPT", "The RCPT command specifies the recipient. This command can be used\nany number of times to specify multiple recipients.", "TO: <recipient>\n recipient = the email address of the recipient of the message");
    }

    @Override
    public void execute(String commandString, IoSession ioSession, SMTPContext ctx) throws IOException {
        SMTPState smtpState = ctx.getSMTPState();
        if (!smtpState.getHasSender()) {
            this.sendResponse(ioSession, "503 Error: need MAIL command");
            return;
        }
        int max = ctx.getSMTPServerConfig().getMaxRecipients();
        if (max > -1 && smtpState.getRecipientCount() >= max) {
            this.sendResponse(ioSession, "452 Too many recipients");
            return;
        }
        String args = this.getArgPredicate(commandString);
        if (args.toUpperCase().startsWith("TO:")) {
            String recipientAddress = this.extractEmailAddress(args, 3);
            if (this.isValidEmailAddress(recipientAddress)) {
                try {
                    ctx.getDeliveryHandler().recipient(recipientAddress);
                    smtpState.addRecipient();
                    this.sendResponse(ioSession, "250 Ok");
                }
                catch (RejectException ex) {
                    this.sendResponse(ioSession, ex.getMessage());
                }
            } else {
                this.sendResponse(ioSession, "553 <" + recipientAddress + "> Invalid email address");
            }
        } else {
            this.sendResponse(ioSession, "501 Syntax: RCPT TO: <address> Error in parameters: \"" + args + "\"");
        }
    }
}

