/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.core.commands.impl;

import java.io.IOException;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.mailster.smtp.core.SMTPContext;
import org.mailster.smtp.core.commands.AbstractCommand;
import org.mailster.smtp.util.DummySSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartTLSCommand
extends AbstractCommand {
    private static final Logger LOG = LoggerFactory.getLogger(StartTLSCommand.class);
    private static SslFilter sslFilter;

    public StartTLSCommand() {
        super("STARTTLS", "The STARTTLS command starts a secured connection for the current\nSMTP session");
    }

    public static void setSSLFilter(SslFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter argument can't be null");
        }
        sslFilter = filter;
    }

    @Override
    public void execute(String commandString, IoSession ioSession, SMTPContext ctx) throws IOException {
        if (commandString.trim().indexOf(" ") > 0) {
            this.sendResponse(ioSession, "501 Syntax error (no parameters allowed)");
            return;
        }
        try {
            if (sslFilter.isSslStarted(ioSession)) {
                this.sendResponse(ioSession, "454 TLS not available due to temporary reason: TLS already active");
                return;
            }
            ioSession.getFilterChain().addFirst("SSLfilter", (IoFilter)sslFilter);
            ioSession.setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE, (Object)Boolean.TRUE);
            this.sendResponse(ioSession, "220 Ready to start TLS");
            assert (ioSession.getAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE) == null);
            ctx.getSMTPState().resetAll();
            ctx.getDeliveryHandler().resetMessageState();
        }
        catch (Exception e) {
            LOG.debug("startTLS() failed: {}", (Object)e.getMessage());
            LOG.trace("startTLS() failure stack trace", (Throwable)e);
        }
    }

    static {
        try {
            DummySSLSocketFactory socketFactory = new DummySSLSocketFactory();
            sslFilter = new SslFilter(socketFactory.getSSLContext());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

