/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;

public class CharTerminatedInputStream
extends InputStream {
    private InputStream in;
    private int[] match;
    private int[] buffer;
    private int pos = 0;
    private boolean endFound = false;

    public CharTerminatedInputStream(InputStream in, char[] terminator) {
        if (terminator == null) {
            throw new IllegalArgumentException("The terminating character array cannot be null.");
        }
        if (terminator.length == 0) {
            throw new IllegalArgumentException("The terminating character array cannot be of zero length.");
        }
        this.match = new int[terminator.length];
        this.buffer = new int[terminator.length];
        for (int i = 0; i < terminator.length; ++i) {
            this.match[i] = terminator[i];
        }
        this.in = in;
    }

    @Override
    public int read() throws IOException {
        if (this.endFound) {
            return -1;
        }
        if (this.pos == 0) {
            int b = this.in.read();
            if (b == -1) {
                throw new ProtocolException("pre-mature end of data");
            }
            if (b != this.match[0]) {
                return b;
            }
            this.buffer[0] = b;
            ++this.pos;
        } else if (this.buffer[0] != this.match[0]) {
            return this.topChar();
        }
        for (int i = 0; i < this.match.length; ++i) {
            if (i >= this.pos) {
                int b = this.in.read();
                if (b == -1) {
                    return this.topChar();
                }
                this.buffer[this.pos] = b;
                ++this.pos;
            }
            if (this.buffer[i] == this.match[i]) continue;
            return this.topChar();
        }
        this.endFound = true;
        return -1;
    }

    private int topChar() {
        int b = this.buffer[0];
        if (this.pos > 1) {
            System.arraycopy(this.buffer, 1, this.buffer, 0, this.pos - 1);
        }
        --this.pos;
        return b;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

