/*
 * Decompiled with CFR 0.152.
 */
package org.mailster.smtp.util;

import jakarta.mail.util.SharedByteArrayInputStream;
import java.io.InputStream;
import org.mailster.smtp.util.CharTerminatedInputStream;
import org.mailster.smtp.util.DotUnstuffingInputStream;
import org.mailster.smtp.util.SharedTmpFileInputStream;

public class SharedStreamUtils {
    public static final char[] SMTP_TERMINATOR = new char[]{'\r', '\n', '.', '\r', '\n'};

    public static InputStream getPrivateInputStream(InputStream data) {
        return SharedStreamUtils.getPrivateInputStream(true, data);
    }

    public static InputStream getPrivateInputStream(boolean useCopy, InputStream data) {
        InputStream in = data;
        if (useCopy) {
            if (data instanceof SharedByteArrayInputStream) {
                in = ((SharedByteArrayInputStream)data).newStream(0L, -1L);
            } else if (data instanceof SharedTmpFileInputStream) {
                in = ((SharedTmpFileInputStream)data).newStream(0L, -1L);
            } else {
                throw new IllegalArgumentException("Unexpected data stream type : " + data.getClass().getName());
            }
        }
        in = new CharTerminatedInputStream(in, SMTP_TERMINATOR);
        in = new DotUnstuffingInputStream(in);
        return in;
    }
}

