/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.CommonFont;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.GenericFontProgram;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.cwt.freetype.SfntName;
import de.intarsys.tools.locator.ILocator;

public class GenericFont
extends CommonFont {
    private String fontType;
    private String fontName;
    private String fontNamePostScript;
    private String fontFamilyName;
    private FontStyle fontStyle;

    public static GenericFont createNew(ILocator locator, Face face) {
        String fontPSName = face.getPostscriptName();
        String familyName = face.getFamilyName();
        String styleName = face.getStyleName();
        String fontName = null;
        int sfntCount = face.getSfntNameCount();
        int i = 0;
        while (i < sfntCount) {
            SfntName sfntName = face.getSfntName(i);
            if (sfntName.getNameId() == 4) {
                fontName = sfntName.getName();
                if (sfntName.getPlatformId() == 3) break;
            }
            ++i;
        }
        if (fontPSName == null) {
            fontPSName = familyName;
        }
        if (fontName == null) {
            fontName = fontPSName;
        }
        FontStyle style = FontStyle.getFontStyle(styleName);
        GenericFont font = new GenericFont();
        GenericFontProgram fontProgram = new GenericFontProgram(font, locator);
        font.setFontProgram(fontProgram);
        font.setFontFamilyName(familyName);
        font.setFontNamePostScript(fontPSName);
        font.setFontName(fontName);
        font.setFontStyle(style);
        String type = locator.getType();
        if (type != null) {
            type = type.toLowerCase();
        }
        if ("ttf".equals(type) || "ttc".equals(type) || "otf".equals(type) || "otc".equals(type)) {
            font.setFontType("TrueType");
        } else if ("pfb".equals(type)) {
            font.setFontType("Type1");
        } else {
            font.setFontType("Unknown");
        }
        return font;
    }

    protected GenericFont() {
    }

    @Override
    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getFontNameCanonical() {
        String tempFamilyName = null;
        FontStyle tempStyle = null;
        tempFamilyName = this.getFontFamilyName() == null ? FontTools.getFontFamilyName(this.getFontName()) : this.getFontFamilyName();
        tempStyle = this.getFontStyle() == null ? FontTools.getFontStyle(this.getFontName()) : this.getFontStyle();
        return FontTools.createCanonicalName(tempFamilyName, tempStyle.getId());
    }

    @Override
    public String getFontNamePostScript() {
        return this.fontNamePostScript;
    }

    @Override
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontType() {
        return this.fontType;
    }

    protected void setFontFamilyName(String familyName) {
        this.fontFamilyName = familyName;
    }

    protected void setFontName(String fontName) {
        this.fontName = fontName;
    }

    protected void setFontNamePostScript(String fontPSName) {
        this.fontNamePostScript = fontPSName;
    }

    protected void setFontStyle(FontStyle style) {
        this.fontStyle = style;
    }

    protected void setFontType(String fontType) {
        this.fontType = fontType;
    }
}

