/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.FontEnvironment;
import de.intarsys.cwt.font.FontFamily;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.font.IFontFamily;
import de.intarsys.cwt.font.IFontQuery;
import de.intarsys.cwt.font.IFontRegistry;
import de.intarsys.cwt.font.PACKAGE;
import de.intarsys.tools.collection.ListTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardFontRegistry
implements IFontRegistry {
    private final Map<String, IFontFamily> fontFamilyMap = new HashMap<String, IFontFamily>();
    private final List<IFontFamily> fontFamilies = new ArrayList<IFontFamily>();
    private final Map<String, Object> fontMap = new HashMap<String, Object>();
    private final List<IFont> fonts = new ArrayList<IFont>();
    private static final Logger Log = PACKAGE.Log;

    protected IFont basicLookup(String key, IFontQuery query) {
        if (key == null) {
            return null;
        }
        Object result = this.fontMap.get(key);
        if (result == null) {
            Log.log(Level.FINEST, "font registry missed " + key);
            return null;
        }
        if (result instanceof IFont) {
            Log.log(Level.FINEST, "font registry found " + key);
            return (IFont)result;
        }
        for (IFont font : (List)result) {
            if (!this.basicMatchFamilyStyle(query, font)) continue;
            Log.log(Level.FINEST, "font registry resolved by family style " + key);
            return font;
        }
        for (IFont font : (List)result) {
            if (!this.basicMatchFamily(query, font)) continue;
            Log.log(Level.FINEST, "font registry resolved by family " + key);
            return font;
        }
        return null;
    }

    protected boolean basicMatchFamily(IFontQuery query, IFont font) {
        return query.getFontFamilyName().indexOf(font.getFontFamilyName()) >= 0;
    }

    protected boolean basicMatchFamilyStyle(IFontQuery query, IFont font) {
        return query.getFontNameCanonical().equals(font.getFontNameCanonical());
    }

    protected void basicRegister(String key, IFont value) {
        String program = "embedded font";
        if (value.getFontProgram() != null) {
            program = value.getFontProgram().getLocator().getFullName();
        }
        Log.log(Level.FINEST, "font registry register " + program + " with " + key);
        Object previous = this.fontMap.put(key, value);
        if (previous == null) {
            return;
        }
        if (previous instanceof List) {
            ((List)previous).add(value);
            this.fontMap.put(key, previous);
        } else {
            this.fontMap.put(key, ListTools.with((Object[])new Object[]{previous, value}));
        }
    }

    @Override
    public synchronized IFontFamily[] getFontFamilies() {
        FontEnvironment.get().registerUserFonts();
        FontEnvironment.get().registerSystemFonts();
        return this.fontFamilies.toArray(new IFontFamily[this.fontFamilies.size()]);
    }

    @Override
    public synchronized IFont[] getFonts() {
        FontEnvironment.get().registerUserFonts();
        FontEnvironment.get().registerSystemFonts();
        return this.fonts.toArray(new IFont[this.fonts.size()]);
    }

    protected Object getLookupKeyFontFamily(IFontQuery query) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (query.getFontType() == null) {
            sb.append("Any");
        } else {
            sb.append(query.getFontType());
        }
        sb.append("]");
        sb.append(query.getFontFamilyName());
        return sb.toString();
    }

    protected String getLookupKeyFontName(IFontQuery query) {
        if (query.getFontName() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (query.getFontType() == null) {
            sb.append("Any");
        } else {
            sb.append(query.getFontType());
        }
        sb.append("]");
        sb.append(query.getFontName());
        return sb.toString();
    }

    protected String getLookupKeyFontNameAsCanonical(IFontQuery query) {
        if (query.getFontName() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (query.getFontType() == null) {
            sb.append("Any");
        } else {
            sb.append(query.getFontType());
        }
        sb.append("-canonical]");
        sb.append(query.getFontName());
        return sb.toString();
    }

    protected String getLookupKeyFontNameCanonical(IFontQuery query) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (query.getFontType() == null) {
            sb.append("Any");
        } else {
            sb.append(query.getFontType());
        }
        sb.append("-canonical]");
        sb.append(query.getFontNameCanonical());
        return sb.toString();
    }

    protected String getLookupKeyFontNamePostScript(IFontQuery query) {
        if (query.getFontName() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (query.getFontType() == null) {
            sb.append("Any");
        } else {
            sb.append(query.getFontType());
        }
        sb.append("-postscript]");
        sb.append(query.getFontName());
        return sb.toString();
    }

    @Override
    public IFont lookupFont(IFontQuery query) {
        IFont result = this.basicLookup(this.getLookupKeyFontName(query), query);
        if (result == null && (result = this.basicLookup(this.getLookupKeyFontNamePostScript(query), query)) == null && (result = this.basicLookup(this.getLookupKeyFontNameCanonical(query), query)) == null) {
            result = this.basicLookup(this.getLookupKeyFontNameAsCanonical(query), query);
        }
        return result;
    }

    @Override
    public IFontFamily lookupFontFamily(IFontQuery query) {
        return this.fontFamilyMap.get(this.getLookupKeyFontFamily(query));
    }

    @Override
    public void registerFont(IFont font) {
        String type = font.getFontType();
        String familyName = font.getFontFamilyName();
        if (familyName != null) {
            String familyKey = "[" + type + "]" + familyName;
            IFontFamily fontFamily = this.fontFamilyMap.get(familyKey);
            if (fontFamily == null) {
                fontFamily = new FontFamily(familyName);
                this.fontFamilyMap.put(familyKey, fontFamily);
                this.fontFamilies.add(fontFamily);
            }
            fontFamily.registerFont(font);
            familyKey = "[Any]" + familyName;
            fontFamily = this.fontFamilyMap.get(familyKey);
            if (fontFamily == null) {
                fontFamily = new FontFamily(familyName);
                this.fontFamilyMap.put(familyKey, fontFamily);
            }
            fontFamily.registerFont(font);
        }
        String fontName = font.getFontName();
        String fontNamePostScript = font.getFontNamePostScript();
        String fontNameCanonical = font.getFontNameCanonical();
        String fontKey = "[" + type + "]" + fontName;
        this.basicRegister(fontKey, font);
        fontKey = "[" + type + "-postscript]" + fontNamePostScript;
        this.basicRegister(fontKey, font);
        fontKey = "[" + type + "-canonical]" + fontNameCanonical;
        this.basicRegister(fontKey, font);
        fontKey = "[Any]" + fontName;
        this.basicRegister(fontKey, font);
        fontKey = "[Any-postscript]" + fontNamePostScript;
        this.basicRegister(fontKey, font);
        fontKey = "[Any-canonical]" + fontNameCanonical;
        this.basicRegister(fontKey, font);
        this.fonts.add(font);
    }

    protected String removeSpaces(String name) {
        int pos = 0;
        while ((pos = name.indexOf(32)) != -1) {
            name = String.valueOf(name.substring(0, pos)) + name.substring(pos + 1);
        }
        return name;
    }
}

