/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontHeader;
import de.intarsys.cwt.font.truetype.TTHorizontalHeader;
import de.intarsys.cwt.font.truetype.TTMetrics;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTNaming;
import de.intarsys.cwt.font.truetype.TTPostScriptInformation;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TTFontParser {
    private TTTable[] tables;

    public Map parseTable_cmap(TTTable data) throws IOException {
        HashMap<String, TTTable> result = new HashMap<String, TTTable>();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            random.seekBy(2L);
            int count = this.readUShort(random);
            int i = 0;
            while (i < count) {
                int platformID = this.readUShort(random);
                int platformSpecificID = this.readUShort(random);
                int offset = this.readInt(random);
                TTTable subtable = new TTTable(data.getFont(), data.getOffset() + (long)offset, -1L);
                String key = platformID + ":" + platformSpecificID;
                result.put(key, subtable);
                ++i;
            }
            HashMap<String, TTTable> hashMap = result;
            return hashMap;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public Map parseTable_cmap_subtable(TTTable data) throws IOException {
        Map result = null;
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            int format = this.readUShort(random);
            switch (format) {
                case 0: {
                    result = this.readCMapFormat0(random);
                    break;
                }
                case 4: {
                    result = this.readCMapFormat4(random);
                    break;
                }
                case 6: {
                    result = this.readCMapFormat6(random);
                }
            }
            Map map = result;
            return map;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTFontHeader parseTable_head(TTTable data) throws IOException {
        TTFontHeader result = new TTFontHeader();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            random.seekBy(16L);
            result.setFlags(this.readUShort(random));
            result.setUnitsPerEm(this.readUShort(random));
            random.seekBy(16L);
            result.setXMin(this.readShort(random));
            result.setYMin(this.readShort(random));
            result.setXMax(this.readShort(random));
            result.setYMax(this.readShort(random));
            result.setMacStyle(this.readUShort(random));
            random.seekBy(4L);
            result.setShortLocationFormat(this.readShort(random) == 0);
            TTFontHeader tTFontHeader = result;
            return tTFontHeader;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTHorizontalHeader parseTable_hhea(TTTable data) throws IOException {
        TTHorizontalHeader result = new TTHorizontalHeader();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            random.seekBy(4L);
            result.setAscender(this.readShort(random));
            result.setDescender(this.readShort(random));
            result.setLineGap(this.readShort(random));
            result.setAdvanceWidthMax(this.readUShort(random));
            result.setMinLeftSideBearing(this.readShort(random));
            result.setMinRightSideBearing(this.readShort(random));
            result.setXMaxExtent(this.readShort(random));
            result.setCaretSlopeRise(this.readShort(random));
            result.setCaretSlopeRun(this.readShort(random));
            random.seekBy(12L);
            result.setNumberOfHMetrics(this.readUShort(random));
            TTHorizontalHeader tTHorizontalHeader = result;
            return tTHorizontalHeader;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public int[] parseTable_hmtx(TTTable data, int count) throws IOException {
        int[] widths = new int[count];
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            int i = 0;
            while (i < count) {
                widths[i] = this.readUShort(random);
                this.readShort(random);
                ++i;
            }
            int[] nArray = widths;
            return nArray;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public int[] parseTable_loca(TTTable data, boolean shortLocationFormat) throws IOException {
        int count = 0;
        IRandomAccess random = data.getRandomAccess();
        try {
            int[] locations;
            random.seek(0L);
            if (shortLocationFormat) {
                count = (int)random.getLength() / 2;
                locations = new int[count];
                int i = 0;
                while (i < count) {
                    locations[i] = this.readUShort(random) << 1;
                    ++i;
                }
            } else {
                count = (int)random.getLength() / 4;
                locations = new int[count];
                int i = 0;
                while (i < count) {
                    locations[i] = this.readInt(random);
                    ++i;
                }
            }
            int[] nArray = locations;
            return nArray;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTNaming parseTable_name(TTTable data) throws IOException {
        TTNaming result = new TTNaming();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            random.seekBy(2L);
            int count = this.readUShort(random);
            int stringTableOffset = this.readUShort(random);
            int i = 0;
            while (i < count) {
                TTNameRecord record = this.readNameRecord(random, stringTableOffset);
                if (record.getPlatformID() == 3 && record.getLanguageID() == 1033) {
                    result.add(record.getNameID(), record);
                }
                ++i;
            }
            TTNaming tTNaming = result;
            return tTNaming;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTMetrics parseTable_os2(TTTable data) throws IOException {
        TTMetrics result = new TTMetrics();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            random.seekBy(2L);
            result.setXAvgCharWidth(this.readShort(random));
            result.setUsWeightClass(this.readUShort(random));
            result.setUsWidthClass(this.readUShort(random));
            result.setFsType(this.readUShort(random));
            result.setYSubscriptXSize(this.readShort(random));
            result.setYSubscriptYSize(this.readShort(random));
            result.setYSubscriptXOffset(this.readShort(random));
            result.setYSubscriptYOffset(this.readShort(random));
            result.setYSuperscriptXSize(this.readShort(random));
            result.setYSuperscriptYSize(this.readShort(random));
            result.setYSuperscriptXOffset(this.readShort(random));
            result.setYSuperscriptYOffset(this.readShort(random));
            result.setYStrikeoutSize(this.readShort(random));
            result.setYStrikeoutPosition(this.readShort(random));
            result.setSFamilyClass(this.readShort(random));
            result.setPanose(this.readBytes(random, 10));
            random.seekBy(20L);
            result.setFsSelection(this.readUShort(random));
            result.setUsFirstCharIndex(this.readUShort(random));
            result.setUsLastCharIndex(this.readUShort(random));
            result.setSTypoAscender(this.readShort(random));
            result.setSTypoDescender(this.readShort(random));
            result.setSTypoLineGap(this.readShort(random));
            result.setUsWinAscent(this.readUShort(random));
            result.setUsWinDescent(this.readUShort(random));
            result.setSxHeight(this.readShort(random));
            result.setSCapHeight(this.readShort(random));
            result.setUsDefaultChar(this.readUShort(random));
            result.setUsMaxContext(this.readUShort(random));
            TTMetrics tTMetrics = result;
            return tTMetrics;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTPostScriptInformation parseTable_post(TTTable data) throws IOException {
        TTPostScriptInformation result = new TTPostScriptInformation();
        IRandomAccess random = data.getRandomAccess();
        try {
            random.seek(0L);
            result.setVersion(this.readFixed(random));
            result.setItalicAngle(this.readFixed(random));
            result.setUnderlinePosition(this.readShort(random));
            result.setUnderlineThickness(this.readShort(random));
            TTPostScriptInformation tTPostScriptInformation = result;
            return tTPostScriptInformation;
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
    }

    public TTTable[] parseTables(TTFont font) throws IOException {
        IRandomAccess random = null;
        try {
            random = font.getLocator().getRandomAccess();
            this.readTables(font, random);
            font.setTables(this.tables);
        }
        finally {
            StreamTools.close((IRandomAccess)random);
        }
        return this.tables;
    }

    public byte[] readBytes(IRandomAccess random, int count) throws IOException {
        byte[] bytes = new byte[count];
        int bytesRead = random.read(bytes);
        if (bytesRead < bytes.length) {
            return null;
        }
        return bytes;
    }

    protected Map readCMapFormat0(IRandomAccess random) throws IOException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        random.seekBy(4L);
        int i = 0;
        while (i < 256) {
            int glyphCode = random.read();
            result.put(new Integer(i), new Integer(glyphCode));
            ++i;
        }
        return result;
    }

    protected Map readCMapFormat4(IRandomAccess random) throws IOException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        int length = this.readUShort(random);
        random.seekBy(2L);
        int segCount = this.readUShort(random) / 2;
        random.seekBy(6L);
        int[] endIndices = new int[segCount];
        int i = 0;
        while (i < segCount) {
            endIndices[i] = this.readUShort(random);
            ++i;
        }
        random.seekBy(2L);
        int[] startIndices = new int[segCount];
        int i2 = 0;
        while (i2 < segCount) {
            startIndices[i2] = this.readUShort(random);
            ++i2;
        }
        int[] deltas = new int[segCount];
        int i3 = 0;
        while (i3 < segCount) {
            deltas[i3] = this.readUShort(random);
            ++i3;
        }
        int[] rangeOffsets = new int[segCount];
        int i4 = 0;
        while (i4 < segCount) {
            rangeOffsets[i4] = this.readUShort(random);
            ++i4;
        }
        int glyphIndexCount = length / 2 - 8 - segCount * 4;
        int[] glyphIndices = new int[glyphIndexCount];
        int i5 = 0;
        while (i5 < glyphIndexCount) {
            glyphIndices[i5] = this.readUShort(random);
            ++i5;
        }
        int i6 = 0;
        while (i6 < segCount) {
            int charCode = startIndices[i6];
            while (charCode <= endIndices[i6] && charCode != 65535) {
                int glyphCode;
                if (rangeOffsets[i6] == 0) {
                    glyphCode = deltas[i6] + charCode & 0xFFFF;
                } else {
                    int index = charCode - startIndices[i6] + rangeOffsets[i6] / 2;
                    glyphCode = glyphIndices[index = index - segCount + i6];
                    if (glyphCode != 0) {
                        glyphCode = deltas[i6] + glyphCode & 0xFFFF;
                    }
                }
                result.put(new Integer(charCode), new Integer(glyphCode));
                ++charCode;
            }
            ++i6;
        }
        return result;
    }

    protected Map readCMapFormat6(IRandomAccess random) throws IOException {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        random.seekBy(4L);
        int firstIndex = this.readUShort(random);
        int count = this.readUShort(random);
        int lastIndex = firstIndex + count;
        int i = firstIndex;
        while (i < lastIndex) {
            int glyphCode = this.readUShort(random);
            result.put(new Integer(i), new Integer(glyphCode));
            ++i;
        }
        return result;
    }

    public float readFixed(IRandomAccess random) throws IOException {
        int i = this.readInt(random);
        boolean negative = false;
        if (i < 0) {
            negative = true;
            i *= -1;
        }
        float hi = i >> 16;
        float low = i & 0xFFFF;
        while (low >= 1.0f) {
            low /= 10.0f;
        }
        if (negative) {
            return -1.0f * (hi + low);
        }
        return hi + low;
    }

    public int readInt(IRandomAccess random) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = random.read();
        if ((b1 | (b2 = random.read()) | (b3 = random.read()) | (b4 = random.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (b1 << 24) + (b2 << 16) + (b3 << 8) + b4;
    }

    protected TTNameRecord readNameRecord(IRandomAccess random, int stringTableOffset) throws IOException {
        TTNameRecord record = new TTNameRecord();
        record.setPlatformID(this.readUShort(random));
        record.setEncodingID(this.readUShort(random));
        record.setLanguageID(this.readUShort(random));
        record.setNameID(this.readUShort(random));
        record.setLength(this.readUShort(random));
        int nameOffset = this.readUShort(random);
        byte[] value = new byte[record.getLength()];
        random.mark();
        random.seek((long)(stringTableOffset + nameOffset));
        random.read(value, 0, record.getLength());
        record.setValue(new String(value, "UTF-16BE"));
        random.reset();
        return record;
    }

    public short readShort(IRandomAccess random) throws IOException {
        int b2;
        int b1 = random.read();
        if ((b1 | (b2 = random.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (short)((b1 << 8) + b2);
    }

    public TTTable readTable(TTFont font, IRandomAccess random) throws IOException {
        byte[] name = this.readBytes(random, 4);
        int checksum = this.readInt(random);
        int offset = this.readInt(random);
        int length = this.readInt(random);
        TTTable result = new TTTable(font, offset, length);
        result.setName(name);
        result.setChecksum(checksum);
        return result;
    }

    public void readTables(TTFont font, IRandomAccess random) throws IOException {
        font.setSfntVersion(this.readInt(random));
        int tableCount = this.readUShort(random);
        random.seekBy(6L);
        this.tables = new TTTable[tableCount];
        int i = 0;
        while (i < tableCount) {
            this.tables[i] = this.readTable(font, random);
            ++i;
        }
    }

    public long readUInt(IRandomAccess random) throws IOException {
        int b4;
        int b3;
        int b2;
        int b1 = random.read();
        if ((b1 | (b2 = random.read()) | (b3 = random.read()) | (b4 = random.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return ((long)b1 << 24) + (long)(b2 << 16) + (long)(b3 << 8) + (long)b4;
    }

    public int readUShort(IRandomAccess random) throws IOException {
        int b2;
        int b1 = random.read();
        if ((b1 | (b2 = random.read())) < 0) {
            throw new IOException("unexpected end of stream");
        }
        return (b1 << 8) + b2;
    }
}

