/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTNameRecord;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;

public class TTFontSerializer {
    private TTFont font;
    private int tableOffset = 0;

    public TTFont getFont() {
        return this.font;
    }

    public void write(IRandomAccess random, TTFont pFont) throws IOException {
        this.font = pFont;
        this.writeFontHeader(random);
        this.writeTableDirectory(random);
        this.writeTables(random);
    }

    public void write_loca(IRandomAccess random, int[] locations, boolean shortFormat) throws IOException {
        int i = 0;
        while (i < locations.length) {
            if (shortFormat) {
                this.writeShort(random, locations[i] >> 1);
            } else {
                this.writeInt(random, locations[i]);
            }
            ++i;
        }
    }

    public void write_name(IRandomAccess random, TTNameRecord[] names) throws IOException {
        int offset = 6 + names.length * 12;
        this.writeShort(random, 0);
        this.writeShort(random, names.length);
        this.writeShort(random, offset);
        int nameOffset = 0;
        int i = 0;
        while (i < names.length) {
            this.writeShort(random, names[i].getPlatformID());
            this.writeShort(random, names[i].getEncodingID());
            this.writeShort(random, names[i].getLanguageID());
            this.writeShort(random, names[i].getNameID());
            this.writeShort(random, names[i].getLength());
            this.writeShort(random, nameOffset);
            nameOffset += names[i].getLength();
            ++i;
        }
        i = 0;
        while (i < names.length) {
            this.writeBytes(random, names[i].getValue().getBytes("UTF-16BE"), 0, names[i].getLength());
            ++i;
        }
    }

    public void writeByte(IRandomAccess random, int value) throws IOException {
        random.write(value);
    }

    public void writeBytes(IRandomAccess random, byte[] value, int off, int len) throws IOException {
        random.write(value, off, len);
    }

    protected void writeFontHeader(IRandomAccess random) throws IOException {
        int numTables = this.getFont().getTables().length;
        int maxPower = 1;
        int log2MaxPower = 0;
        while (maxPower <= numTables) {
            maxPower <<= 1;
            ++log2MaxPower;
        }
        if (log2MaxPower > 0) {
            maxPower >>= 1;
            --log2MaxPower;
        }
        this.writeInt(random, 65536);
        this.writeShort(random, numTables);
        this.writeShort(random, maxPower << 4);
        this.writeShort(random, log2MaxPower);
        this.writeShort(random, numTables - maxPower << 4);
    }

    public void writeInt(IRandomAccess random, int value) throws IOException {
        random.write((int)((byte)(value >> 24)));
        random.write((int)((byte)(value >> 16)));
        random.write((int)((byte)(value >> 8)));
        random.write((int)((byte)value));
    }

    public void writeShort(IRandomAccess random, int value) throws IOException {
        random.write((int)((byte)(value >> 8)));
        random.write((int)((byte)value));
    }

    protected void writeTableDirectory(IRandomAccess random) throws IOException {
        int tableCount = this.getFont().getTables().length;
        this.tableOffset = tableCount * 16 + 12;
        int i = 0;
        while (i < tableCount) {
            TTTable table = this.getFont().getTables()[i];
            this.writeTableDirectoryTable(random, table);
            ++i;
        }
    }

    protected void writeTableDirectoryTable(IRandomAccess random, TTTable table) throws IOException {
        int length = (int)table.getLength();
        this.writeBytes(random, table.getName(), 0, table.getName().length);
        this.writeInt(random, table.getChecksum());
        this.writeInt(random, this.tableOffset);
        this.writeInt(random, length);
        this.tableOffset = this.tableOffset + length + 3 & 0xFFFFFFFC;
    }

    protected void writeTables(IRandomAccess random) throws IOException {
        int tableCount = this.getFont().getTables().length;
        int i = 0;
        while (i < tableCount) {
            TTTable table = this.getFont().getTables()[i];
            this.writeTablesTable(random, table);
            ++i;
        }
    }

    protected void writeTablesTable(IRandomAccess random, TTTable table) throws IOException {
        IRandomAccess tableRandom = table.getRandomAccess();
        try {
            tableRandom.seek(0L);
            int length = (int)table.getLength();
            int i = 0;
            while (i < length) {
                this.writeByte(random, tableRandom.read());
                ++i;
            }
            i = length;
            while (i < (length + 3 & 0xFFFFFFFC)) {
                this.writeByte(random, 0);
                ++i;
            }
        }
        finally {
            StreamTools.close((IRandomAccess)tableRandom);
        }
    }
}

