/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.hybrid.image;

import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.hybrid.image.CwtHybridImage;
import de.intarsys.cwt.hybrid.image.ImageIOImageContainer;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.IImageContainer;
import de.intarsys.cwt.image.ImageEntry;
import de.intarsys.cwt.swt.image.ISwtImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class ImageIOImageEntry
extends ImageEntry
implements IAwtImage,
ISwtImage {
    private static final int width = 400;
    private static final int height = 400;
    private int index;

    public ImageIOImageEntry(IImageContainer container, int index) {
        super(container);
        this.index = index;
    }

    @Override
    public void drawFromGraphicsContext(IGraphicsContext graphicsContext, float x, float y) {
        this.getDelegate().drawFromGraphicsContext(graphicsContext, x, y);
    }

    @Override
    public BufferedImage getBufferedImage() {
        return ((IAwtImage)this.getDelegate()).getBufferedImage();
    }

    @Override
    protected synchronized IImage getErrorImage(Exception e) {
        BufferedImage image = new BufferedImage(400, 400, 1);
        Graphics2D gc = image.createGraphics();
        gc.setBackground(Color.WHITE);
        gc.fillRect(0, 0, 400, 400);
        gc.setColor(Color.RED);
        gc.drawLine(0, 0, 400, 400);
        gc.drawLine(0, 400, 400, 0);
        gc.setColor(Color.BLACK);
        gc.drawString("error loading image (" + e.getMessage() + ")", 10, 20);
        return new CwtHybridImage(image);
    }

    @Override
    public Image getImage(Device device) {
        return ((ISwtImage)this.getDelegate()).getImage(device);
    }

    @Override
    public ImageData getImageData() {
        return ((ISwtImage)this.getDelegate()).getImageData();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    protected IImage loadContent() throws IOException {
        return this.myContainer().loadImage(this.getIndex());
    }

    private ImageIOImageContainer myContainer() {
        return (ImageIOImageContainer)this.getContainer();
    }
}

