/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.environment;

import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IGraphicsObject;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsEnvironment;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import de.intarsys.tools.geometry.ShapeTools;
import de.intarsys.tools.geometry.TransformedShape;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Transform;

public class CwtSwtGraphicsContext
implements IGraphicsContext {
    static final int BACKGROUND = 2;
    static final int FOREGROUND = 1;
    private static ResourceTracker tracker = new ResourceTracker(){

        protected void basicDispose(Object resource) {
            ((Path)resource).dispose();
        }
    };
    private boolean applyAlphaBackground;
    private boolean applyAlphaForeground;
    private boolean applyTransform = false;
    private java.awt.Color backgroundColor = null;
    private Pattern backgroundPattern;
    private BlendMode blendMode = (BlendMode)BlendMode.META.getDefault();
    private AffineTransform cachedAWTShapeTransform;
    private Transform cachedSWTShapeTransform;
    private TransformedShape currentClip;
    private AffineTransform currentTransform;
    private Device device;
    private float[] elements = new float[6];
    private double[] flatmatrix = new double[6];
    private org.eclipse.swt.graphics.Font font;
    private Transform fontTransform;
    private java.awt.Color foregroundColor;
    private Pattern foregroundPattern;
    private GC gc;
    private int swtBackgroundAlpha = 255;
    private Color swtBackgroundColor = null;
    private int swtForegroundAlpha;
    private Color swtForegroundColor;
    private Transform swtTransform;

    public static Path toPath(Device device, PathIterator pathIterator) {
        Path path = new Path(device);
        if (pathIterator.isDone()) {
            path.addRectangle(0.0f, 0.0f, 0.0f, 0.0f);
            return path;
        }
        float[] coords = new float[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 4: {
                    path.close();
                    break;
                }
                case 3: {
                    path.cubicTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                default: {
                    throw new InternalError("Program execution should not reach this point.");
                }
            }
            pathIterator.next();
        }
        return path;
    }

    public static Rectangle2D toRectangle2D(Rectangle rect) {
        return new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
    }

    public static Transform toTransform(Device device, AffineTransform at) {
        double[] tempElements = new double[6];
        at.getMatrix(tempElements);
        return new Transform(device, (float)tempElements[0], (float)tempElements[1], (float)tempElements[2], (float)tempElements[3], (float)tempElements[4], (float)tempElements[5]);
    }

    public static Transform toTransform(Device device, Transform st, AffineTransform at) {
        if (st == null) {
            return new Transform(device, (float)at.getScaleX(), (float)at.getShearX(), (float)at.getShearY(), (float)at.getScaleY(), (float)at.getTranslateX(), (float)at.getTranslateY());
        }
        st.setElements((float)at.getScaleX(), (float)at.getShearX(), (float)at.getShearY(), (float)at.getScaleY(), (float)at.getTranslateX(), (float)at.getTranslateY());
        return st;
    }

    public CwtSwtGraphicsContext(GC paramGC, Device paramDevice) {
        this.device = paramDevice;
        this.font = null;
        this.swtForegroundAlpha = 255;
        this.swtForegroundColor = null;
        this.foregroundColor = null;
        this.gc = paramGC;
        this.applyAlphaForeground = false;
        this.applyAlphaBackground = false;
        this.swtTransform = new Transform(paramDevice);
        paramGC.getTransform(this.swtTransform);
        this.swtTransform.getElements(this.elements);
        this.currentTransform = new AffineTransform(this.elements);
        Rectangle2D rect = CwtSwtGraphicsContext.toRectangle2D(paramGC.getClipping());
        this.currentClip = ApplySpaceChangeShape.create((Shape)new Area(rect), (AffineTransform)this.currentTransform);
        paramGC.setAntialias(0);
        paramGC.setInterpolation(0);
    }

    protected void applyAlphaBackground() {
        if (this.applyAlphaBackground) {
            this.applyAlphaBackground = false;
            if (this.gc.getAlpha() != this.swtBackgroundAlpha) {
                this.gc.setAlpha(this.swtBackgroundAlpha);
                if (this.swtForegroundAlpha != this.swtBackgroundAlpha) {
                    this.applyAlphaForeground = true;
                }
            }
        }
    }

    protected void applyAlphaForeground() {
        if (this.applyAlphaForeground) {
            this.applyAlphaForeground = false;
            if (this.gc.getAlpha() != this.swtForegroundAlpha) {
                this.gc.setAlpha(this.swtForegroundAlpha);
                if (this.swtBackgroundAlpha != this.swtForegroundAlpha) {
                    this.applyAlphaBackground = true;
                }
            }
        }
    }

    protected void applyClip() {
        if (this.currentClip == null) {
            this.gc.setClipping(null);
        } else {
            this.applyTransform();
            PathIterator pathIterator = this.currentClip.getPathIterator(null);
            if (pathIterator.getWindingRule() == 0) {
                this.gc.setFillRule(1);
            } else {
                this.gc.setFillRule(2);
            }
            Path clipPath = CwtSwtGraphicsContext.toPath(this.device, pathIterator);
            this.gc.setClipping(clipPath);
            clipPath.dispose();
        }
    }

    protected void applyTransform() {
        if (this.applyTransform) {
            this.applyTransform = false;
            this.currentTransform.getMatrix(this.flatmatrix);
            this.swtTransform.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
            this.gc.setTransform(this.swtTransform);
        }
    }

    @Override
    public void clip(Shape shape) {
        Area tempShape = ShapeTools.createArea((Shape)shape, (boolean)false);
        if (this.currentClip == null) {
            this.currentClip = ApplySpaceChangeShape.create((Shape)tempShape, (AffineTransform)this.currentTransform);
        } else {
            Area tempClip = ShapeTools.createArea((Shape)this.currentClip, (boolean)true);
            tempClip.intersect(tempShape);
            this.currentClip = ApplySpaceChangeShape.create((Shape)tempClip, (AffineTransform)this.currentTransform);
        }
        this.applyClip();
    }

    protected Path createPath(Shape s) {
        Path path;
        if (s instanceof IGraphicsObject && (path = (Path)((IGraphicsObject)((Object)s)).getData()) != null && !path.isDisposed() && !path.getDevice().isDisposed()) {
            return path;
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)s;
            path = new Path(this.device);
            path.addRectangle((float)rect.getX(), (float)rect.getY(), (float)rect.getWidth(), (float)rect.getHeight());
        } else {
            path = CwtSwtGraphicsContext.toPath(this.device, s.getPathIterator(null));
        }
        tracker.trackPhantom((Object)s, (Object)path);
        if (s instanceof IGraphicsObject) {
            ((IGraphicsObject)((Object)s)).setData(path);
        }
        return path;
    }

    @Override
    public void dispose() {
        this.applyTransform();
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
        }
        if (this.backgroundPattern != null) {
            this.backgroundPattern.dispose();
        }
        if (this.font != null) {
            this.font.dispose();
        }
        if (this.fontTransform != null) {
            this.fontTransform.dispose();
        }
        if (this.swtForegroundColor != null) {
            this.swtForegroundColor.dispose();
        }
        if (this.foregroundPattern != null) {
            this.foregroundPattern.dispose();
        }
        if (this.swtTransform != null) {
            this.swtTransform.dispose();
        }
        if (this.cachedSWTShapeTransform != null) {
            this.cachedSWTShapeTransform.dispose();
        }
    }

    @Override
    public void draw(Shape s) {
        this.applyAlphaForeground();
        if (s instanceof TransformedShape && this.gc.getForegroundPattern() == null) {
            AffineTransform awtShapeTransform = ((TransformedShape)s).getTransform();
            if (awtShapeTransform != null) {
                if (awtShapeTransform != this.cachedAWTShapeTransform) {
                    this.cachedAWTShapeTransform = awtShapeTransform;
                    if (this.cachedSWTShapeTransform != null) {
                        this.cachedSWTShapeTransform.dispose();
                    }
                    this.cachedSWTShapeTransform = CwtSwtGraphicsContext.toTransform(this.device, awtShapeTransform);
                }
                Transform tempTransform = new Transform(this.device);
                this.currentTransform.getMatrix(this.flatmatrix);
                tempTransform.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
                tempTransform.multiply(this.cachedSWTShapeTransform);
                this.gc.setTransform(tempTransform);
            } else {
                this.applyTransform();
            }
            Shape baseShape = ((TransformedShape)s).getBaseShape();
            this.gc.drawPath(this.createPath(baseShape));
            this.gc.setTransform(this.swtTransform);
        } else {
            this.applyTransform();
            this.gc.drawPath(this.createPath(s));
        }
    }

    @Override
    public void drawImage(IImage image, float x, float y) {
        this.applyAlphaBackground();
        this.applyTransform();
        image.drawFromGraphicsContext(this, x, y);
    }

    @Override
    public void drawString(String s, float x, float y) {
        this.applyTransform();
        this.applyAlphaForeground();
        boolean reset = false;
        int actualX = (int)x;
        int actualY = (int)y;
        if (this.fontTransform != null) {
            actualX = 0;
            actualY = 0;
            if (this.swtTransform == null) {
                this.swtTransform = new Transform(this.device);
            }
            this.gc.getTransform(this.swtTransform);
            this.swtTransform.getElements(this.elements);
            this.swtTransform.translate(x, y);
            float[] point = new float[]{0.0f, 0 - this.gc.textExtent((String)s).y};
            this.fontTransform.transform(point);
            this.swtTransform.translate(point[0], point[1]);
            this.swtTransform.multiply(this.fontTransform);
            this.gc.setTransform(this.swtTransform);
            reset = true;
        }
        try {
            this.gc.drawString(s, actualX, actualY);
        }
        finally {
            if (reset) {
                this.swtTransform.setElements(this.elements[0], this.elements[1], this.elements[2], this.elements[3], this.elements[4], this.elements[5]);
                this.gc.setTransform(this.swtTransform);
            }
        }
    }

    @Override
    public void fill(Shape s) {
        this.applyAlphaBackground();
        if (s instanceof TransformedShape && this.gc.getBackgroundPattern() == null) {
            AffineTransform awtShapeTransform = ((TransformedShape)s).getTransform();
            if (awtShapeTransform != null) {
                if (awtShapeTransform != this.cachedAWTShapeTransform) {
                    this.cachedAWTShapeTransform = awtShapeTransform;
                    if (this.cachedSWTShapeTransform != null) {
                        this.cachedSWTShapeTransform.dispose();
                    }
                    this.cachedSWTShapeTransform = CwtSwtGraphicsContext.toTransform(this.device, awtShapeTransform);
                }
                Transform tempTransform = new Transform(this.device);
                this.currentTransform.getMatrix(this.flatmatrix);
                tempTransform.setElements((float)this.flatmatrix[0], (float)this.flatmatrix[1], (float)this.flatmatrix[2], (float)this.flatmatrix[3], (float)this.flatmatrix[4], (float)this.flatmatrix[5]);
                tempTransform.multiply(this.cachedSWTShapeTransform);
                this.gc.setTransform(tempTransform);
            } else {
                this.applyTransform();
            }
            Shape baseShape = ((TransformedShape)s).getBaseShape();
            if (ShapeTools.getWindingRule((Shape)baseShape) == 0) {
                this.gc.setFillRule(1);
            } else {
                this.gc.setFillRule(2);
            }
            Path path = this.createPath(baseShape);
            this.gc.fillPath(path);
            this.gc.setTransform(this.swtTransform);
        } else {
            this.applyTransform();
            PathIterator pathIterator = s.getPathIterator(null);
            if (pathIterator.getWindingRule() == 0) {
                this.gc.setFillRule(1);
            } else {
                this.gc.setFillRule(2);
            }
            Path path = this.createPath(s);
            this.gc.fillPath(path);
        }
    }

    @Override
    public java.awt.Color getBackgroundColor() {
        if (this.backgroundColor == null) {
            RGB rgb = this.swtBackgroundColor.getRGB();
            this.backgroundColor = new java.awt.Color(rgb.red, rgb.green, rgb.blue);
        }
        return this.backgroundColor;
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public Shape getClip() {
        if (this.currentClip == null) {
            return null;
        }
        return (Shape)this.currentClip.clone();
    }

    public Device getDevice() {
        return this.device;
    }

    public Font getFont() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    @Override
    public java.awt.Color getForegroundColor() {
        if (this.foregroundColor == null) {
            RGB rgb = this.swtForegroundColor.getRGB();
            this.foregroundColor = new java.awt.Color(rgb.red, rgb.green, rgb.blue);
        }
        return this.foregroundColor;
    }

    public GC getGc() {
        return this.gc;
    }

    @Override
    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtSwtGraphicsEnvironment.get();
    }

    @Override
    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = new RenderingHints(null);
        int value = this.gc.getAntialias();
        if (value == -1) {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        } else if (value == 0) {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        } else {
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        value = this.gc.getInterpolation();
        if (value == 2) {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        } else {
            renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        }
        value = this.gc.getTextAntialias();
        if (value == -1) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        } else if (value == 0) {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        } else {
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        return renderingHints;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.currentTransform.clone();
    }

    protected float[] getTransformationValues(AffineTransform tx) {
        tx.getMatrix(this.flatmatrix);
        this.elements[0] = (float)this.flatmatrix[0];
        this.elements[1] = (float)this.flatmatrix[1];
        this.elements[2] = (float)this.flatmatrix[2];
        this.elements[3] = (float)this.flatmatrix[3];
        this.elements[4] = (float)this.flatmatrix[4];
        this.elements[5] = (float)this.flatmatrix[5];
        return this.elements;
    }

    public void resetAdvanced() {
        this.gc.setAdvanced(false);
    }

    @Override
    public void rotate(float theta) {
        this.currentTransform.rotate(theta);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    @Override
    public void scale(float x, float y) {
        this.currentTransform.scale(x, y);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    @Override
    public void setBackgroundColor(java.awt.Color color) {
        this.backgroundColor = color;
        this.swtBackgroundAlpha = color.getAlpha();
        this.applyAlphaBackground = true;
        Color newColor = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
        this.setBackgroundColor(newColor);
    }

    public void setBackgroundColor(Color resource) {
        if (this.swtBackgroundColor != null) {
            this.swtBackgroundColor.dispose();
        }
        this.swtBackgroundColor = resource;
        this.backgroundColor = null;
        this.gc.setBackground(this.swtBackgroundColor);
    }

    @Override
    public void setBackgroundPaint(IPaint paint) {
        this.swtBackgroundAlpha = (int)(paint.getAlphaValue() * 255.0f);
        this.applyAlphaBackground = true;
        paint.setBackgroundPaintFromGraphicsContext(this);
    }

    public void setBackgroundPattern(Pattern resource) {
        if (this.backgroundPattern != null) {
            this.backgroundPattern.dispose();
        }
        this.backgroundPattern = resource;
        this.gc.setBackgroundPattern(this.backgroundPattern);
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    public void setClip(Shape shape) {
        this.currentClip = shape == null ? null : ApplySpaceChangeShape.create((Shape)ShapeTools.createArea((Shape)shape, (boolean)false), (AffineTransform)this.currentTransform);
        this.applyClip();
    }

    @Override
    public void setFont(Font awtFont) {
        AffineTransform tx;
        if (this.font != null) {
            this.font.dispose();
        }
        int style = 0;
        if ((awtFont.getStyle() & 1) > 0) {
            style |= 1;
        }
        if ((awtFont.getStyle() & 2) > 0) {
            style |= 2;
        }
        if (this.fontTransform != null) {
            this.fontTransform.dispose();
        }
        this.fontTransform = (tx = awtFont.getTransform()).isIdentity() ? null : new Transform(this.device, this.getTransformationValues(tx));
        this.font = new org.eclipse.swt.graphics.Font(this.device, awtFont.getFontName(), awtFont.getSize(), style);
        this.gc.setFont(this.font);
    }

    @Override
    public void setForegroundColor(java.awt.Color color) {
        this.foregroundColor = color;
        this.swtForegroundAlpha = color.getAlpha();
        this.applyAlphaForeground = true;
        Color newColor = new Color(this.device, color.getRed(), color.getGreen(), color.getBlue());
        this.setForegroundColor(newColor);
    }

    public void setForegroundColor(Color resource) {
        if (this.swtForegroundColor != null) {
            this.swtForegroundColor.dispose();
        }
        this.swtForegroundColor = resource;
        this.foregroundColor = null;
        this.gc.setForeground(this.swtForegroundColor);
    }

    @Override
    public void setForegroundPaint(IPaint paint) {
        this.swtForegroundAlpha = (int)(paint.getAlphaValue() * 255.0f);
        this.applyAlphaForeground = true;
        paint.setForegroundPaintFromGraphicsContext(this);
    }

    public void setForegroundPattern(Pattern resource) {
        if (this.foregroundPattern != null) {
            this.foregroundPattern.dispose();
        }
        this.foregroundPattern = resource;
        this.gc.setForegroundPattern(this.foregroundPattern);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        if (hintKey == RenderingHints.KEY_ALPHA_INTERPOLATION) {
            return;
        }
        if (hintKey == RenderingHints.KEY_ANTIALIASING) {
            if (hintValue == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
                this.gc.setAntialias(-1);
            } else if (hintValue == RenderingHints.VALUE_ANTIALIAS_OFF) {
                this.gc.setAntialias(0);
            } else {
                this.gc.setAntialias(1);
            }
            return;
        }
        if (hintKey == RenderingHints.KEY_COLOR_RENDERING) {
            return;
        }
        if (hintKey == RenderingHints.KEY_DITHERING) {
            return;
        }
        if (hintKey == RenderingHints.KEY_FRACTIONALMETRICS) {
            return;
        }
        if (hintKey == RenderingHints.KEY_INTERPOLATION) {
            if (hintValue == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.gc.setInterpolation(2);
            } else if (hintValue == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.gc.setInterpolation(2);
            } else {
                this.gc.setInterpolation(1);
            }
            return;
        }
        if (hintKey == RenderingHints.KEY_RENDERING) {
            return;
        }
        if (hintKey == RenderingHints.KEY_STROKE_CONTROL) {
            return;
        }
        if (hintKey == RenderingHints.KEY_TEXT_ANTIALIASING) {
            if (hintValue == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                this.gc.setTextAntialias(-1);
            } else if (hintValue == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                this.gc.setTextAntialias(0);
            } else {
                this.gc.setTextAntialias(1);
            }
        }
    }

    @Override
    public void setRenderingHints(Map hints) {
        hints.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION);
        if (hints.containsKey(RenderingHints.KEY_ANTIALIASING)) {
            if (hints.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_DEFAULT) {
                this.gc.setAntialias(-1);
            } else if (hints.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_OFF) {
                this.gc.setAntialias(0);
            } else {
                this.gc.setAntialias(1);
            }
        } else {
            this.gc.setAntialias(-1);
        }
        hints.containsKey(RenderingHints.KEY_COLOR_RENDERING);
        hints.containsKey(RenderingHints.KEY_DITHERING);
        hints.containsKey(RenderingHints.KEY_FRACTIONALMETRICS);
        if (hints.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (hints.get(RenderingHints.KEY_INTERPOLATION) == RenderingHints.VALUE_INTERPOLATION_BICUBIC) {
                this.gc.setInterpolation(2);
            } else if (hints.get(RenderingHints.KEY_INTERPOLATION) == RenderingHints.VALUE_INTERPOLATION_BILINEAR) {
                this.gc.setInterpolation(2);
            } else {
                this.gc.setInterpolation(1);
            }
        } else {
            this.gc.setInterpolation(0);
        }
        hints.containsKey(RenderingHints.KEY_RENDERING);
        hints.containsKey(RenderingHints.KEY_STROKE_CONTROL);
        if (hints.containsKey(RenderingHints.KEY_TEXT_ANTIALIASING)) {
            if (hints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                this.gc.setTextAntialias(-1);
            } else if (hints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF) {
                this.gc.setTextAntialias(0);
            } else {
                this.gc.setTextAntialias(1);
            }
        } else {
            this.gc.setTextAntialias(-1);
        }
    }

    @Override
    public void setStroke(Stroke s) {
        if (s instanceof BasicStroke) {
            BasicStroke stroke = (BasicStroke)s;
            LineAttributes attributes = new LineAttributes(stroke.getLineWidth());
            float[] dash = stroke.getDashArray();
            if (dash == null) {
                attributes.style = 1;
            } else {
                int index = 0;
                while (index < dash.length) {
                    if (dash[index] <= 0.0f) {
                        dash[index] = 1.0f;
                    }
                    ++index;
                }
                attributes.style = 6;
                attributes.dash = dash;
            }
            int value = stroke.getEndCap();
            attributes.cap = value == 0 ? 1 : (value == 1 ? 2 : 3);
            value = stroke.getLineJoin();
            attributes.join = value == 2 ? 3 : (value == 0 ? 1 : 2);
            this.gc.setLineAttributes(attributes);
            this.gc.setLineCap(attributes.cap);
            return;
        }
    }

    @Override
    public void setTransform(AffineTransform pTransform) {
        this.currentTransform = (AffineTransform)pTransform.clone();
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip = ApplySpaceChangeShape.setTransform((Shape)this.currentClip, (AffineTransform)this.currentTransform);
        }
    }

    public java.awt.Point textExtent(String s) {
        Point extent = this.gc.textExtent(s);
        return new java.awt.Point(extent.x, extent.y);
    }

    @Override
    public void transform(AffineTransform deltaTransform) {
        this.currentTransform.concatenate(deltaTransform);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }

    @Override
    public void translate(float x, float y) {
        this.currentTransform.translate(x, y);
        this.applyTransform = true;
        if (this.currentClip != null) {
            this.currentClip.invalidate();
        }
    }
}

