/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.ComponentOrder;
import de.intarsys.cwt.swt.image.IImageConverter;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;

public class ICAnyByteToPlatform
implements IImageConverter {
    @Override
    public boolean accept(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        if (colorModel.getTransparency() == 2) {
            return false;
        }
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        return dataBuffer instanceof DataBufferByte;
    }

    @Override
    public ImageData createImageData(BufferedImage srcImage) {
        ColorConvertOp colorConvertOp = new ColorConvertOp(null);
        ColorSpace destColorSpace = ColorSpace.getInstance(1000);
        ColorModel srcColorModel = srcImage.getColorModel();
        ComponentColorModel destColorModel = new ComponentColorModel(destColorSpace, false, false, 1, 0);
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        int[] bandOffsets = ComponentOrder.PlatformInstance.getBandOffsets();
        WritableRaster destRaster = Raster.createInterleavedRaster(0, srcWidth, srcHeight, srcWidth * 3, 3, bandOffsets, new Point(0, 0));
        BufferedImage destImage = new BufferedImage(destColorModel, destRaster, false, null);
        colorConvertOp.filter(srcImage, destImage);
        int srcTransparency = srcColorModel.getTransparency();
        byte[] srcData = ((DataBufferByte)srcImage.getRaster().getDataBuffer()).getData();
        byte[] destData = ((DataBufferByte)destRaster.getDataBuffer()).getData();
        byte[] alphaData = null;
        if (srcTransparency == 3) {
            int srcNumComponents = srcColorModel.getNumComponents();
            alphaData = new byte[srcWidth * srcHeight];
            int index = 0;
            while (index < alphaData.length) {
                alphaData[index] = srcData[index * srcNumComponents + srcNumComponents - 1];
                ++index;
            }
        }
        byte[] data = destData;
        ImageData imageData = new ImageData(srcWidth, srcHeight, 24, ComponentOrder.PlatformInstance.getPaletteData(), 3, data);
        imageData.alphaData = alphaData;
        return imageData;
    }
}

