/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.ComponentOrder;
import de.intarsys.cwt.swt.image.IImageConverter;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;

public class ICComponentByteTransparentToPlatform
implements IImageConverter {
    @Override
    public boolean accept(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        if (!(colorModel instanceof ComponentColorModel)) {
            return false;
        }
        if (colorModel.getColorSpace() instanceof ICC_ColorSpace) {
            return false;
        }
        if (colorModel.getTransparency() != 3) {
            return false;
        }
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        return dataBuffer instanceof DataBufferByte;
    }

    @Override
    public ImageData createImageData(BufferedImage srcImage) {
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        int srcSize = srcWidth * srcHeight;
        byte[] alphaData = new byte[srcSize];
        byte[] data = new byte[srcSize * 3];
        Object[] allCache = new Object[256];
        ColorModel srcColorModel = srcImage.getColorModel();
        ColorSpace srcColorSpace = srcColorModel.getColorSpace();
        int srcNumColorComponents = srcColorModel.getNumColorComponents();
        WritableRaster srcRaster = srcImage.getRaster();
        byte[] srcData = ((DataBufferByte)srcRaster.getDataBuffer()).getData();
        float[] temp = new float[srcNumColorComponents];
        ComponentSampleModel srcSampleModel = (ComponentSampleModel)srcImage.getSampleModel();
        int[] srcBandOffsets = srcSampleModel.getBandOffsets();
        int[] bandOffsets = ComponentOrder.PlatformInstance.getBandOffsets();
        int srcNumComponents = srcColorModel.getNumComponents();
        int index = 0;
        while (index < srcSize) {
            int value;
            Object[] componentCache = allCache;
            int subIndex = 0;
            while (subIndex < srcNumColorComponents - 1) {
                value = srcData[index * srcNumComponents + srcBandOffsets[subIndex]] & 0xFF;
                Object[] current = (Object[])componentCache[value];
                if (current == null) {
                    componentCache[value] = current = new Object[256];
                }
                componentCache = current;
                ++subIndex;
            }
            value = srcData[index * srcNumComponents + srcBandOffsets[srcNumColorComponents - 1]] & 0xFF;
            byte[] rgbs = (byte[])componentCache[value];
            if (rgbs == null) {
                temp[srcNumColorComponents - 1] = (float)value / 255.0f;
                int subIndex2 = 0;
                while (subIndex2 < srcNumColorComponents - 1) {
                    temp[subIndex2] = (float)(srcData[index * srcNumComponents + srcBandOffsets[subIndex2]] & 0xFF) / 255.0f;
                    ++subIndex2;
                }
                float[] rgb = srcColorSpace.toRGB(temp);
                rgbs = new byte[]{(byte)(rgb[0] * 255.0f), (byte)(rgb[1] * 255.0f), (byte)(rgb[2] * 255.0f)};
                componentCache[value] = rgbs;
            }
            data[index * 3] = rgbs[bandOffsets[0]];
            data[index * 3 + 1] = rgbs[bandOffsets[1]];
            data[index * 3 + 2] = rgbs[bandOffsets[2]];
            alphaData[index] = srcData[index * srcNumComponents + srcNumComponents - 1];
            ++index;
        }
        ImageData imageData = new ImageData(srcWidth, srcHeight, 24, ComponentOrder.PlatformInstance.getPaletteData(), 3, data);
        imageData.alphaData = alphaData;
        return imageData;
    }
}

