/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.IImageConverter;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;

public class ICComponentGrayByteOpaqueToSame
implements IImageConverter {
    @Override
    public boolean accept(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        if (!(colorModel instanceof ComponentColorModel)) {
            return false;
        }
        if (!ColorSpace.getInstance(1003).equals(colorModel.getColorSpace())) {
            return false;
        }
        if (colorModel.getTransparency() != 1) {
            return false;
        }
        DataBuffer dataBuffer = image.getRaster().getDataBuffer();
        return dataBuffer instanceof DataBufferByte;
    }

    @Override
    public ImageData createImageData(BufferedImage srcImage) {
        byte[] srcData;
        int srcWidth = srcImage.getWidth();
        int srcHeight = srcImage.getHeight();
        WritableRaster srcRaster = srcImage.getRaster();
        byte[] data = srcData = ((DataBufferByte)srcRaster.getDataBuffer()).getData();
        ImageData imageData = new ImageData(srcWidth, srcHeight, 8, new PaletteData(255, 255, 255), 1, data);
        return imageData;
    }
}

