/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.swt.image;

import de.intarsys.cwt.swt.image.ICAnyByteToPlatform;
import de.intarsys.cwt.swt.image.ICAnyToPlatform;
import de.intarsys.cwt.swt.image.ICComponentByteOpaqueToPlatform;
import de.intarsys.cwt.swt.image.ICComponentByteTransparentToPlatform;
import de.intarsys.cwt.swt.image.ICComponentGrayByteOpaqueToSame;
import de.intarsys.cwt.swt.image.ICComponentGrayByteTransparentToSame;
import de.intarsys.cwt.swt.image.ICComponentOpaqueToPlatform;
import de.intarsys.cwt.swt.image.ICComponentRGBByteOpaqueToPlatform;
import de.intarsys.cwt.swt.image.ICComponentRGBByteOpaqueToSame;
import de.intarsys.cwt.swt.image.ICComponentRGBByteTransparentToPlatform;
import de.intarsys.cwt.swt.image.ICIndexedRGBByteOpaqueToSame;
import de.intarsys.cwt.swt.image.IImageConverter;
import de.intarsys.cwt.swt.image.PACKAGE;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.ImageData;

public class ImageConverterAwt2Swt {
    private static final Logger Log = PACKAGE.Log;
    private static List<IImageConverter> ImageConverters = new ArrayList<IImageConverter>();
    private BufferedImage bufferedImage;
    private ImageData imageData;

    static {
        ImageConverters.add(new ICComponentRGBByteOpaqueToSame());
        ImageConverters.add(new ICComponentRGBByteOpaqueToPlatform());
        ImageConverters.add(new ICComponentRGBByteTransparentToPlatform());
        ImageConverters.add(new ICComponentGrayByteOpaqueToSame());
        ImageConverters.add(new ICComponentGrayByteTransparentToSame());
        ImageConverters.add(new ICIndexedRGBByteOpaqueToSame());
        ImageConverters.add(new ICComponentByteOpaqueToPlatform());
        ImageConverters.add(new ICComponentByteTransparentToPlatform());
        ImageConverters.add(new ICComponentOpaqueToPlatform());
        ImageConverters.add(new ICAnyByteToPlatform());
        ImageConverters.add(new ICAnyToPlatform());
    }

    public ImageConverterAwt2Swt(BufferedImage paramBufferedImage) {
        this.bufferedImage = paramBufferedImage;
    }

    protected ImageData createImageData() {
        for (IImageConverter imageConverter : ImageConverters) {
            if (!imageConverter.accept(this.bufferedImage)) continue;
            try {
                this.imageData = imageConverter.createImageData(this.bufferedImage);
                return this.imageData;
            }
            catch (Throwable t) {
                if (t instanceof OutOfMemoryError) {
                    throw t;
                }
                Log.log(Level.SEVERE, t.getMessage(), t);
            }
        }
        throw new UnsupportedOperationException();
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public ImageData getImageData() {
        if (this.imageData == null) {
            this.imageData = this.createImageData();
        }
        return this.imageData;
    }
}

